/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ujorm.Ujo;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;

public class UjoSequencer {
    private static final Logger LOGGER = Logger.getLogger(UjoSequencer.class.getName());
    protected final MetaTable table;
    protected long sequence = 0L;
    protected long seqLimit = 0L;
    protected long maxValue = 0L;

    public UjoSequencer(MetaTable table) {
        this.table = table;
    }

    public synchronized long nextValue(Session session) {
        if (this.sequence < this.seqLimit) {
            return ++this.sequence;
        }
        MetaDatabase db = (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
        Connection connection = null;
        ResultSet res = null;
        String sql = null;
        PreparedStatement statement = null;
        StringBuilder out = new StringBuilder(64);
        try {
            connection = session.getSeqConnection(db);
            String tableName = db.getDialect().printFullTableName(this.getTable(), true, out).toString();
            out.setLength(0);
            out.setLength(0);
            sql = db.getDialect().printSequenceNextValue(this, out).toString();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, sql + "; [" + tableName + ']');
            }
            statement = connection.prepareStatement(sql);
            statement.setString(1, tableName);
            int i = statement.executeUpdate();
            if (i == 0) {
                out.setLength(0);
                sql = db.getDialect().printSequenceInit(this, out).toString();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, sql + "; [" + tableName + ']');
                }
                statement = connection.prepareStatement(sql);
                statement.setString(1, tableName);
                statement.executeUpdate();
            }
            out.setLength(0);
            sql = db.getDialect().printSequenceCurrentValue(this, out).toString();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, sql + "; [" + tableName + ']');
            }
            statement = connection.prepareStatement(sql);
            statement.setString(1, tableName);
            res = statement.executeQuery();
            res.next();
            this.seqLimit = res.getLong(1);
            int step = res.getInt(2);
            this.maxValue = res.getLong(3);
            this.sequence = this.seqLimit - (long)step + 1L;
            if (this.maxValue != 0L) {
                if (this.seqLimit > this.maxValue) {
                    this.seqLimit = this.maxValue;
                    if (this.sequence > this.maxValue) {
                        String msg = "The sequence '" + tableName + "' needs to raise the maximum value: " + this.maxValue;
                        throw new IllegalStateException(msg);
                    }
                    statement.close();
                    sql = db.getDialect().printSetMaxSequence(this, out).toString();
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, sql + "; [" + tableName + ']');
                    }
                    statement = connection.prepareStatement(sql);
                    statement.setString(1, tableName);
                    statement.execute();
                }
                if (this.maxValue > Long.MAX_VALUE - (long)step) {
                    String msg = "The sequence attribute '" + tableName + ".maxValue' is too hight," + " the recommended maximal value is: " + (Long.MAX_VALUE - (long)step) + " (Long.MAX_VALUE-step)";
                    LOGGER.log(Level.WARNING, msg);
                }
            }
            connection.commit();
        }
        catch (Throwable e) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex) {
                        LOGGER.log(Level.WARNING, "Rollback fails");
                    }
                }
                IllegalStateException exception = e instanceof IllegalStateException ? (IllegalStateException)e : new IllegalStateException("ILLEGAL SQL: " + sql, e);
                throw exception;
            }
            catch (Throwable throwable) {
                MetaDatabase.close(null, statement, res, true);
                throw throwable;
            }
        }
        MetaDatabase.close(null, statement, res, true);
        return this.sequence;
    }

    public String getDatabaseSchema() {
        return (String)MetaDatabase.SCHEMA.of((Ujo)this.getDatabase());
    }

    public int getIncrement() {
        int result = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)this.table.getDatabase().getParams());
        return result;
    }

    public int getInitDbCache() {
        return 1;
    }

    public MetaDatabase getDatabase() {
        return (MetaDatabase)MetaTable.DATABASE.of((Ujo)this.table);
    }

    public MetaTable getTable() {
        return this.table;
    }

    public boolean isSequenceTableRequired() {
        return true;
    }
}

