/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.ao;

import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.ao.ManyCacheKey;
import org.ujorm.orm.ao.OneCacheKey;
import org.ujorm.orm.ao.UjoCacheKey;
import org.ujorm.orm.metaModel.MetaPKey;

public abstract class CacheKey {
    private int hash = 0;

    public abstract int size();

    public abstract Object getValue(int var1);

    public abstract Class getType();

    public boolean equals(Object obj) {
        CacheKey cache = (CacheKey)obj;
        if (cache == null || this.getType() != cache.getType()) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            Object v2;
            Object v1 = this.getValue(i);
            if (v1.equals(v2 = cache.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int h = 7 + this.getType().hashCode();
            for (int i = this.size() - 1; i >= 0; --i) {
                h = 67 * h + this.getValue(i).hashCode();
            }
            this.hash = h != 0 ? h : 1;
        }
        return this.hash;
    }

    public static CacheKey newInstance(OrmUjo bo, MetaPKey pkey) {
        return new UjoCacheKey(bo, pkey);
    }

    public static CacheKey newInstance(Class type, Object pk) {
        return new OneCacheKey(type, pk);
    }

    public static CacheKey newInstance(Class type, Object ... pks) {
        return new ManyCacheKey(type, pks);
    }
}

