/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaTable;

public class DerbyDialect
extends SqlDialect {
    public String getJdbcUrl() {
        return "jdbc:derby:c:\\temp\\derby-sample;create=true";
    }

    public String getJdbcDriver() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    public Appendable printCreateSchema(String schema, Appendable out) throws IOException {
        out.append("CREATE SCHEMA ");
        out.append(schema);
        return out;
    }

    public Appendable printForeignKey(MetaColumn column, MetaTable table, Appendable out) throws IOException {
        List<MetaColumn> fColumns = column.getForeignColumns();
        MetaTable foreignTable = fColumns.get(0).getTable();
        int columnsSize = fColumns.size();
        out.append("ALTER TABLE ");
        this.printFullTableName(table, out);
        out.append("\n\tADD CONSTRAINT fk_");
        out.append((CharSequence)MetaTable.NAME.of((Ujo)table));
        out.append('_');
        out.append((CharSequence)MetaColumn.NAME.of((Ujo)column));
        out.append(" FOREIGN KEY");
        for (int i = 0; i < columnsSize; ++i) {
            out.append(i == 0 ? "(" : ", ");
            String name = column.getForeignColumnName(i);
            out.append(name);
        }
        out.append(")\n\tREFERENCES ");
        this.printFullTableName(foreignTable, out);
        String separator = "(";
        for (MetaColumn fColumn : fColumns) {
            out.append(separator);
            separator = ", ";
            out.append((CharSequence)MetaColumn.NAME.of((Ujo)fColumn));
        }
        out.append(")");
        return out;
    }

    public void printOffset(Query query, Appendable out) throws IOException {
        out.append(" OFFSET " + query.getOffset());
        out.append(" ROWS");
    }

    public Appendable printComment(MetaTable table, Appendable out) throws IOException {
        return out;
    }

    public Appendable printComment(MetaColumn table, Appendable out) throws IOException {
        return out;
    }
}

