/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirebirdDialect
extends SqlDialect {
    @Override
    public String getJdbcDriver() {
        return "org.firebirdsql.jdbc.FBDriver";
    }

    @Override
    public String getJdbcUrl() {
        return "jdbc:firebirdsql:localhost/3050:DbFile?lc_ctype=UTF8";
    }

    @Override
    public Appendable printCreateSchema(String schema, Appendable out) throws IOException {
        return out;
    }

    @Override
    protected Appendable printLockForSelect(Query query, Appendable out) throws IOException, UnsupportedOperationException {
        out.append("FOR UPDATE WITH LOCK");
        return out;
    }

    @Override
    public Appendable printAlterTable(MetaColumn column, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(column.getTable(), out);
        out.append(" ADD ");
        if (column.isForeignKey()) {
            this.printFKColumnsDeclaration(column, out);
        } else {
            this.printColumnDeclaration(column, null, out);
        }
        if (column.hasDefaultValue()) {
            int i;
            String notNull = " NOT NULL";
            if (column.isMandatory() && (i = out.toString().indexOf(" NOT NULL")) >= 0 && out instanceof StringBuilder) {
                ((StringBuilder)out).delete(i, i + " NOT NULL".length());
            }
            this.printDefaultValue(column, out);
            if (column.isMandatory()) {
                out.append(" NOT NULL");
            }
        }
        return out;
    }

    @Override
    public boolean isMultiRowInsertSupported() {
        return false;
    }

    @Override
    public Appendable printInsert(List<? extends OrmUjo> bo, int idxFrom, int idxTo, Appendable out) throws IOException {
        return this.printInsertBySelect(bo, idxFrom, idxTo, "FROM RDB$DATABASE", out);
    }
}

