/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.sql.Date;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSqlDialect
extends SqlDialect {
    @Override
    public String getJdbcUrl() {
        return "jdbc:sqlserver://localhost:1433";
    }

    @Override
    public String getJdbcDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public Appendable printUpdate(MetaTable table, List<MetaColumn> changedColumns, CriterionDecoder decoder, Appendable out) throws IOException {
        out.append("UPDATE ");
        out.append(table.getAlias());
        out.append("\n\tSET ");
        for (int i = 0; i < changedColumns.size(); ++i) {
            MetaColumn ormColumn = changedColumns.get(i);
            if (ormColumn.isPrimaryKey()) {
                throw new IllegalStateException("Primary key can not be changed: " + (Object)((Object)ormColumn));
            }
            out.append(i == 0 ? "" : ", ");
            out.append((CharSequence)MetaColumn.NAME.of((Ujo)ormColumn));
            out.append("=?");
        }
        out.append("\n\tFROM ");
        this.printTableAliasDefinition(table, out);
        out.append("\n\tWHERE ");
        out.append(decoder.getWhere());
        return out;
    }

    @Override
    public Appendable printDelete(MetaTable table, CriterionDecoder decoder, Appendable out) throws IOException {
        out.append("DELETE ");
        out.append(table.getAlias());
        out.append("\n\tFROM ");
        this.printTableAliasDefinition(table, out);
        out.append("\n\tWHERE ");
        out.append(decoder.getWhere());
        return out;
    }

    @Override
    protected String getColumnType(MetaColumn column) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))) {
            case TIMESTAMP: {
                return "DATETIME";
            }
            case BOOLEAN: {
                return "TINYINT";
            }
        }
        return super.getColumnType(column);
    }

    @Override
    public Appendable printComment(MetaTable table, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(table, out);
        out.append(" COMMENT = '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)table), out);
        out.append("'");
        return out;
    }

    @Override
    public Appendable printComment(MetaColumn column, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(column.getTable(), out);
        out.append(" MODIFY COLUMN ");
        if (column.isPrimaryKey()) {
            String pk = " PRIMARY KEY";
            String statement = this.printColumnDeclaration(column, null, new StringBuilder()).toString();
            out.append(statement.replaceAll(pk, " "));
        } else if (column.isForeignKey()) {
            this.printFKColumnsDeclaration(column, out);
        } else {
            this.printColumnDeclaration(column, null, out);
        }
        out.append(" COMMENT '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)column), out);
        out.append("'");
        return out;
    }

    @Override
    public Appendable printCreateSchema(String schema, Appendable out) throws IOException {
        out.append("IF NOT EXISTS (SELECT * FROM sys.databases WHERE name = '");
        out.append(schema);
        out.append("') ");
        out.append("BEGIN CREATE DATABASE ");
        out.append(schema);
        out.append(" END ");
        return out;
    }

    @Override
    public Appendable printFullTableName(MetaTable table, boolean printSymbolSchema, Appendable out) throws IOException {
        String tableSchema = (String)MetaTable.SCHEMA.of((Ujo)table);
        String tableName = (String)MetaTable.NAME.of((Ujo)table);
        if (this.isUsable(tableSchema)) {
            out.append(printSymbolSchema && table.isDefaultSchema() ? "~" : tableSchema);
            out.append('.');
        }
        out.append("dbo.");
        out.append(tableName);
        return out;
    }

    @Override
    public Appendable printSequenceTable(MetaDatabase db, Appendable out) throws IOException {
        String schema = (String)MetaDatabase.SCHEMA.of((Ujo)db);
        Integer cache = (Integer)MetaParams.SEQUENCE_CACHE.of((Ujo)db.getParams());
        out.append("CREATE TABLE ");
        if (this.isUsable(schema)) {
            out.append(schema);
            out.append('.');
        }
        out.append("dbo.");
        MetaColumn pkType = new MetaColumn();
        MetaColumn.DB_TYPE.setValue((Ujo)pkType, (Object)DbType.BIGINT);
        out.append(this.getSeqTableModel().getTableName() + "\n\t( " + this.getSeqTableModel().getId() + " VARCHAR(96) NOT NULL PRIMARY KEY" + "\n\t, " + this.getSeqTableModel().getSequence() + " " + this.getColumnType(pkType) + " DEFAULT " + cache + " NOT NULL" + "\n\t, " + this.getSeqTableModel().getCache() + " INT DEFAULT " + cache + " NOT NULL" + "\n\t, " + this.getSeqTableModel().getMaxValue() + " " + this.getColumnType(pkType) + " DEFAULT 0 NOT NULL" + "\n\t)");
        return out;
    }

    @Override
    protected Appendable printSequenceTableName(UjoSequencer sequence, Appendable out) throws IOException {
        String schema = sequence.getDatabaseSchema();
        if (this.isUsable(schema)) {
            out.append(schema);
            out.append('.');
        }
        out.append("dbo.");
        out.append(this.getSeqTableModel().getTableName());
        return out;
    }

    @Override
    public Appendable printAlterTable(MetaColumn column, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(column.getTable(), out);
        out.append(" ADD ");
        if (column.isForeignKey()) {
            this.printFKColumnsDeclaration(column, out);
        } else {
            this.printColumnDeclaration(column, null, out);
        }
        if (column.hasDefaultValue()) {
            this.printDefaultValue(column, out);
        }
        return out;
    }

    @Override
    public Appendable printDefaultValue(MetaColumn column, Appendable out) throws IOException {
        Object value = column.getJdbcFriendlyDefaultValue();
        boolean isDefault = value != null;
        String quotMark = "";
        if (value instanceof String) {
            isDefault = ((String)value).length() > 0;
            quotMark = "'";
        } else if (value instanceof Date) {
            isDefault = true;
            quotMark = "'";
        }
        if (isDefault) {
            out.append(" DEFAULT ");
            out.append(quotMark);
            if (value instanceof Boolean) {
                out.append((Boolean)value != false ? (char)'1' : '0');
            } else {
                out.append(value.toString());
            }
            out.append(quotMark);
        }
        return out;
    }

    @Override
    public Appendable printInsert(List<? extends OrmUjo> bo, int idxFrom, int idxTo, Appendable out) throws IOException {
        return this.printInsertBySelect(bo, idxFrom, idxTo, "", out);
    }
}

