/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import org.ujorm.Ujo;
import org.ujorm.orm.CriterionDecoder;
import org.ujorm.orm.DbType;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;

public class MySqlDialect
extends SqlDialect {
    public String getJdbcUrl() {
        return "jdbc:mysql://127.0.0.1:3306/db1";
    }

    public String getJdbcDriver() {
        return "com.mysql.jdbc.Driver";
    }

    public Appendable printDelete(MetaTable table, CriterionDecoder decoder, Appendable out) throws IOException {
        MetaTable[] tables = decoder.getTablesSorted(table);
        if (tables.length > 1) {
            out.append("DELETE FROM ");
            for (int i = 0; i < tables.length; ++i) {
                if (i > 0) {
                    out.append(", ");
                }
                this.printTableAliasDefinition(tables[i], out);
            }
            out.append(" WHERE ");
            out.append(decoder.getWhere());
        } else {
            String fullTableName = this.printFullTableName(table, new StringBuilder(64)).toString();
            String where = decoder.getWhere().replace(table.getAlias() + '.', fullTableName + '.');
            out.append("DELETE FROM ");
            out.append(fullTableName);
            out.append(" WHERE ");
            out.append(where);
        }
        return out;
    }

    public Appendable printSequenceTable(MetaDatabase db, Appendable out) throws IOException {
        return super.printSequenceTable(db, out).append(this.getEngine());
    }

    public Appendable printTable(MetaTable table, Appendable out) throws IOException {
        return super.printTable(table, out).append(this.getEngine());
    }

    protected String getEngine() {
        return " ENGINE = InnoDB";
    }

    protected String getColumnType(MetaColumn column) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))) {
            case TIMESTAMP: {
                return "DATETIME";
            }
            case CLOB: {
                return "LONGTEXT";
            }
            case BLOB: {
                return "LONGBLOB";
            }
        }
        return super.getColumnType(column);
    }

    public Appendable printComment(MetaTable table, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(table, out);
        out.append(" COMMENT = '");
        this.escape((CharSequence)MetaTable.COMMENT.of((Ujo)table), out);
        out.append("'");
        return out;
    }

    public Appendable printComment(MetaColumn column, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(column.getTable(), out);
        out.append(" MODIFY COLUMN ");
        if (column.isPrimaryKey()) {
            String pk = " PRIMARY KEY";
            String statement = this.printColumnDeclaration(column, null, new StringBuilder()).toString();
            out.append(statement.replaceAll(pk, " "));
        } else if (column.isForeignKey()) {
            this.printFKColumnsDeclaration(column, out);
        } else {
            this.printColumnDeclaration(column, null, out);
        }
        out.append(" COMMENT '");
        this.escape((CharSequence)MetaColumn.COMMENT.of((Ujo)column), out);
        out.append("'");
        return out;
    }
}

