/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.orm.DbType;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.dialect.PostgreSqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends PostgreSqlDialect {
    @Override
    public String getJdbcUrl() {
        return "jdbc:oracle:thin:@myhost:1521:orcl";
    }

    @Override
    public String getJdbcDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public Appendable printCreateSchema(String schema, Appendable out) throws IOException {
        return out;
    }

    @Override
    protected Appendable printSelectTable(Query query, boolean count, Appendable out) throws IOException {
        if (!count && (query.isOffset() || query.isLimit())) {
            out.append("SELECT * FROM (SELECT ujorm__.*, ROWNUM AS ujorm_rownum FROM (\n");
            super.printSelectTable(query, count, out);
            out.append("\n) ujorm__) WHERE ujorm_rownum > " + query.getOffset());
            if (query.isLimit()) {
                long to = query.getOffset() + query.getLimit();
                out.append(" AND ujorm_rownum <= " + to);
            }
        } else {
            super.printSelectTable(query, count, out);
        }
        return out;
    }

    @Override
    public void printOffset(Query query, Appendable out) throws IOException {
    }

    @Override
    protected String getColumnType(MetaColumn column) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))) {
            case BIGINT: {
                return "NUMBER";
            }
        }
        return ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))).name();
    }

    @Override
    public Appendable printAlterTable(MetaColumn column, Appendable out) throws IOException {
        out.append("ALTER TABLE ");
        this.printFullTableName(column.getTable(), out);
        out.append(" ADD (");
        if (column.isForeignKey()) {
            this.printFKColumnsDeclaration(column, out);
        } else {
            this.printColumnDeclaration_2(column, null, out);
        }
        out.append(" )");
        return out;
    }

    public Appendable printColumnDeclaration_2(MetaColumn column, String aName, Appendable out) throws IOException {
        String name = aName != null ? aName : (String)MetaColumn.NAME.of((Ujo)column);
        out.append(name);
        out.append(' ');
        out.append(this.getColumnType(column));
        if (!MetaColumn.MAX_LENGTH.isDefault((Ujo)column)) {
            out.append("(" + MetaColumn.MAX_LENGTH.of((Ujo)column));
            if (!MetaColumn.PRECISION.isDefault((Ujo)column)) {
                out.append("," + MetaColumn.PRECISION.of((Ujo)column));
            }
            out.append(")");
        }
        if (column.hasDefaultValue()) {
            this.printDefaultValue(column, out);
        }
        if (((Boolean)MetaColumn.MANDATORY.of((Ujo)column)).booleanValue() && aName == null) {
            out.append(" NOT NULL");
        }
        if (((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)column)).booleanValue() && aName == null) {
            out.append(" PRIMARY KEY");
        }
        return out;
    }

    @Override
    public Appendable printIndexCondition(MetaIndex index, Appendable out) throws IOException {
        return out;
    }

    @Override
    public Appendable printInsert(List<? extends OrmUjo> bo, int idxFrom, int idxTo, Appendable out) throws IOException {
        return this.printInsertBySelect(bo, idxFrom, idxTo, "FROM DUAL", out);
    }
}

