/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.dialect;

import java.io.IOException;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.orm.DbType;
import org.ujorm.orm.Query;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;

public class PostgreSqlDialect
extends SqlDialect {
    public String getJdbcUrl() {
        return "";
    }

    public String getJdbcDriver() {
        return "org.postgresql.Driver";
    }

    public Appendable printCreateSchema(String schema, Appendable out) throws IOException {
        out.append("CREATE SCHEMA ");
        out.append(schema);
        return out;
    }

    protected String getColumnType(MetaColumn column) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))) {
            case BLOB: 
            case CLOB: 
            case BINARY: {
                return "BYTEA";
            }
        }
        return super.getColumnType(column);
    }

    public Appendable printIndex(MetaIndex index, Appendable out) throws IOException {
        super.printIndex(index, out);
        if (((Boolean)MetaIndex.UNIQUE.of((Ujo)index)).booleanValue()) {
            this.printIndexCondition(index, out);
        }
        return out;
    }

    public Appendable printIndexCondition(MetaIndex index, Appendable out) throws IOException {
        String prefix = " WHERE ";
        for (MetaColumn column : (List)MetaIndex.COLUMNS.of((Ujo)index)) {
            if (column.hasDefaultValue()) continue;
            out.append(prefix);
            out.append((CharSequence)MetaColumn.NAME.of((Ujo)column));
            out.append(" IS NOT NULL");
            prefix = " AND ";
        }
        return out;
    }

    public void printOffset(Query query, Appendable out) throws IOException {
        if (query.isOffset()) {
            out.append(" OFFSET " + query.getOffset());
        }
    }
}

