/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoManager;
import org.ujorm.extensions.Property;
import org.ujorm.implementation.orm.RelationToOne;
import org.ujorm.orm.DbType;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.annot.Column;
import org.ujorm.orm.annot.Comment;
import org.ujorm.orm.ao.UjoStatement;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaColumn
extends MetaRelation2Many {
    private static final Class CLASS = MetaColumn.class;
    public static final Property<MetaColumn, Boolean> PRIMARY_KEY = MetaColumn.newProperty((String)"primaryKey", (Object)false);
    public static final Property<MetaColumn, DbType> DB_TYPE = MetaColumn.newProperty((String)"dbType", (Object)((Object)DbType.Automatic));
    public static final Property<MetaColumn, Boolean> MANDATORY = MetaColumn.newProperty((String)"mandatory", (Object)false);
    public static final Property<MetaColumn, Integer> MAX_LENGTH = MetaColumn.newProperty((String)"maxLength", (Object)-1);
    public static final Property<MetaColumn, Integer> PRECISION = MetaColumn.newProperty((String)"precision", (Object)-1);
    public static final Property<MetaColumn, String> DEFAULT_VALUE = MetaColumn.newProperty((String)"default", (Object)"");
    public static final Property<MetaColumn, String> INDEX = MetaColumn.newProperty((String)"index", (Object)"");
    public static final Property<MetaColumn, String> UNIQUE_INDEX = MetaColumn.newProperty((String)"uniqueIndex", (Object)"");
    public static final Property<MetaColumn, String> COMMENT = MetaColumn.newProperty((String)"comment", (Object)"");
    private List<MetaColumn> relatedModel;
    private String[] foreignNames = null;
    private static final String[] EMPTY_NAMES;
    private char typeCode;
    private boolean foreignKey;

    public MetaColumn() {
    }

    public MetaColumn(MetaTable table, UjoProperty tableProperty, MetaColumn param) {
        super(table, tableProperty, param);
        Comment comment;
        Column column;
        this.foreignKey = this.getProperty().isTypeOf(OrmUjo.class);
        Field field = UjoManager.getInstance().getPropertyField(table.getType(), tableProperty);
        Column column2 = column = field != null ? field.getAnnotation(Column.class) : null;
        if (param != null) {
            this.changeDefault(this, PRIMARY_KEY, PRIMARY_KEY.of((Ujo)param));
            this.changeDefault(this, MANDATORY, MANDATORY.of((Ujo)param));
            this.changeDefault(this, MAX_LENGTH, MAX_LENGTH.of((Ujo)param));
            this.changeDefault(this, PRECISION, PRECISION.of((Ujo)param));
            this.changeDefault(this, DB_TYPE, DB_TYPE.of((Ujo)param));
            this.changeDefault(this, INDEX, INDEX.of((Ujo)param));
            this.changeDefault(this, UNIQUE_INDEX, UNIQUE_INDEX.of((Ujo)param));
            this.changeDefault(this, COMMENT, COMMENT.of((Ujo)param));
        }
        if (column != null) {
            this.changeDefault(this, PRIMARY_KEY, column.pk());
            this.changeDefault(this, MANDATORY, column.mandatory());
            this.changeDefault(this, MAX_LENGTH, column.length());
            this.changeDefault(this, PRECISION, column.precision());
            this.changeDefault(this, DB_TYPE, column.type());
            this.changeDefault(this, INDEX, column.index());
            this.changeDefault(this, UNIQUE_INDEX, column.uniqueIndex());
        }
        if (DB_TYPE.isDefault((Ujo)this)) {
            ((MetaDatabase)MetaTable.DATABASE.of((Ujo)table)).changeDbType(this);
        }
        if (MAX_LENGTH.isDefault((Ujo)this)) {
            ((MetaDatabase)MetaTable.DATABASE.of((Ujo)table)).changeDbLength(this);
        }
        if (field != null && (comment = field.getAnnotation(Comment.class)) != null) {
            this.changeDefault(this, COMMENT, comment.value());
        }
    }

    @Override
    public boolean isColumn() {
        return true;
    }

    @Override
    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public boolean isPrimaryKey() {
        boolean result = (Boolean)PRIMARY_KEY.of((Ujo)this);
        return result;
    }

    public boolean isCommented() {
        return !COMMENT.isDefault((Ujo)this);
    }

    public String getComment() {
        return (String)COMMENT.of((Ujo)this);
    }

    public int getMaxLength() {
        return (Integer)MAX_LENGTH.of((Ujo)this);
    }

    public int getPrecision() {
        return (Integer)PRECISION.of((Ujo)this);
    }

    public boolean isMandatory() {
        return (Boolean)MANDATORY.of((Ujo)this);
    }

    public MetaTable getForeignTable() {
        return this.getForeignColumns().get(0).getTable();
    }

    public List<MetaColumn> getForeignColumns() {
        if (this.relatedModel == null) {
            this.assignForeignColumns();
        }
        return this.relatedModel;
    }

    private void assignForeignColumns() {
        ArrayList<MetaColumn> result;
        Class type = this.getProperty().getType();
        if (TABLE_PROPERTY.of((Ujo)this) instanceof RelationToOne) {
            RelationToOne rto = (RelationToOne)((Object)TABLE_PROPERTY.of((Ujo)this));
            MetaColumn mc = (MetaColumn)this.getHandler().findColumnModel(rto.getRelatedKey());
            result = new ArrayList<MetaColumn>(1);
            result.add(mc);
        } else {
            MetaTable table = this.getHandler().findTableModel(type);
            if (table != null) {
                MetaPKey pk = (MetaPKey)((Object)MetaTable.PK.of((Ujo)table));
                result = MetaPKey.COLUMNS.getList((Ujo)pk);
            } else {
                result = Collections.emptyList();
            }
        }
        this.relatedModel = result;
    }

    private String[] getForeignColumnNames() {
        if (this.foreignNames == null) {
            if (this.isForeignKey()) {
                List<MetaColumn> dbColumns = this.getForeignColumns();
                StringTokenizer tokenizer = new StringTokenizer(dbColumns.size() == 1 ? (String)NAME.of((Ujo)this) : "", ", ");
                ArrayList<String> fNames = new ArrayList<String>(dbColumns.size());
                for (MetaColumn dbColumn : dbColumns) {
                    String name = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "fk_" + (String)NAME.of((Ujo)this) + "_" + (String)NAME.of((Ujo)dbColumn);
                    fNames.add(name);
                }
                this.foreignNames = fNames.toArray(new String[fNames.size()]);
            } else {
                this.foreignNames = EMPTY_NAMES;
            }
        }
        return this.foreignNames;
    }

    public String getForeignColumnName(int index) {
        String result = this.getForeignColumnNames()[index];
        return result;
    }

    public Object getValue(OrmUjo bo) {
        UjoProperty property = this.getProperty();
        Object result = property.of((Ujo)bo);
        return result;
    }

    public void setValue(Ujo bo, Object value) {
        UjoProperty property = this.getProperty();
        if (this.isForeignKey() && value != null && !(value instanceof OrmUjo)) {
            value = new ForeignKey(value);
        }
        property.setValue(bo, value);
    }

    public Class getType() {
        UjoProperty property = this.getProperty();
        return property.getType();
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    public String getFullName() {
        try {
            StringBuilder out = new StringBuilder(32);
            MetaTable table = (MetaTable)((Object)TABLE.of((Ujo)this));
            table.getDatabase().getDialect().printFullTableName(table, out);
            out.append('.');
            out.append((String)NAME.of((Ujo)this));
            return out.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getAliasName() {
        try {
            String result = ((MetaTable)((Object)TABLE.of((Ujo)this))).getDatabase().getDialect().printColumnAlias(this, new StringBuilder(32)).toString();
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void printForeignColumnFullName(int index, Appendable out) throws IOException {
        MetaTable table = (MetaTable)((Object)TABLE.of((Ujo)this));
        out.append(table.getAlias());
        out.append('.');
        out.append(this.getForeignColumnNames()[index]);
    }

    public char getTypeCode() {
        return this.typeCode;
    }

    public boolean hasDefaultValue() {
        Object value = this.getProperty().getDefault();
        boolean result = value instanceof String ? ((String)value).length() > 0 : value != null;
        return result;
    }

    public Object getJdbcFriendlyDefaultValue() {
        Object result = new UjoStatement().getDefaultValue(this);
        return result;
    }

    public Class getDialectClass() {
        Class result = ((MetaTable)((Object)TABLE.of((Ujo)this))).getDatabase().get(MetaDatabase.DIALECT);
        return result;
    }

    public String getDialectName() {
        return this.getDialectClass().getSimpleName();
    }

    public void initTypeCode(MetaParams params) {
        List<MetaColumn> cols;
        this.checkReadOnly(true);
        this.typeCode = params.getTypeService().getTypeCode(this);
        if (this.isForeignKey() && (cols = this.getForeignColumns()).size() > 0) {
            DB_TYPE.setValue((Ujo)this, DB_TYPE.of((Ujo)cols.get(0)));
        }
    }

    public boolean isVoid() {
        return this.getProperty().isTypeOf(Void.class);
    }

    static {
        MetaColumn.init((Class)CLASS);
        EMPTY_NAMES = new String[0];
    }
}

