/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.ujorm.Ujo;
import org.ujorm.UjoAction;
import org.ujorm.UjoProperty;
import org.ujorm.core.annot.Transient;
import org.ujorm.core.annot.XmlAttribute;
import org.ujorm.extensions.ListProperty;
import org.ujorm.extensions.Property;
import org.ujorm.extensions.ValueExportable;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.DbType;
import org.ujorm.orm.JdbcStatement;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.SqlDialect;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.annot.Db;
import org.ujorm.orm.ao.CheckReport;
import org.ujorm.orm.ao.CommentPolicy;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaProcedure;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaDatabase
extends AbstractMetaModel
implements Comparable<MetaDatabase> {
    private static final Class CLASS = MetaDatabase.class;
    private static final Logger LOGGER = Logger.getLogger(MetaDatabase.class.getName());
    private static final boolean ADD_DB_MODEL = true;
    @XmlAttribute
    public static final Property<MetaDatabase, String> ID = MetaDatabase.newProperty((String)"id", (Object)"");
    public static final Property<MetaDatabase, String> SCHEMA = MetaDatabase.newProperty((String)"schema", (Object)"");
    public static final Property<MetaDatabase, Boolean> READ_ONLY = MetaDatabase.newProperty((String)"readOnly", (Object)false);
    public static final Property<MetaDatabase, Class> DIALECT = MetaDatabase.newProperty((String)"dialect", Class.class);
    public static final Property<MetaDatabase, String> JDBC_URL = MetaDatabase.newProperty((String)"jdbcUrl", (Object)"");
    public static final Property<MetaDatabase, String> JDBC_DRIVER = MetaDatabase.newProperty((String)"jdbcDriver", (Object)"");
    public static final Property<MetaDatabase, String> USER = MetaDatabase.newProperty((String)"user", (Object)"");
    public static final Property<MetaDatabase, String> PASSWORD = MetaDatabase.newProperty((String)"password", (Object)"");
    public static final ListProperty<MetaDatabase, String> JNDI = MetaDatabase.newListProperty((String)"jndi", String.class);
    public static final Property<MetaDatabase, Class> SEQUENCER = MetaDatabase.newProperty((String)"sequencer", Class.class).writeDefault(UjoSequencer.class);
    public static final Property<MetaDatabase, Orm2ddlPolicy> ORM2DLL_POLICY = MetaDatabase.newProperty((String)"orm2ddlPolicy", (Object)((Object)Orm2ddlPolicy.INHERITED));
    public static final ListProperty<MetaDatabase, MetaTable> TABLES = MetaDatabase.newListProperty((String)"table", MetaTable.class);
    public static final ListProperty<MetaDatabase, MetaProcedure> PROCEDURES = MetaDatabase.newListProperty((String)"procedure", MetaProcedure.class);
    @Transient
    public static final Property<MetaDatabase, Integer> ORDER = MetaDatabase.newProperty((String)"order", (Object)0);
    @Transient
    public static final Property<MetaDatabase, OrmUjo> ROOT = MetaDatabase.newProperty((String)"root", OrmUjo.class);
    private OrmHandler ormHandler;
    private SqlDialect dialect;

    public MetaDatabase() {
    }

    public MetaDatabase(OrmHandler ormHandler, OrmUjo database, MetaDatabase param, Integer order) {
        Db annotDB;
        this.ormHandler = ormHandler;
        ROOT.setValue((Ujo)this, (Object)database);
        ORDER.setValue((Ujo)this, (Object)order);
        if (param != null) {
            this.changeDefault(this, SCHEMA, SCHEMA.of((Ujo)param));
            this.changeDefault(this, READ_ONLY, READ_ONLY.of((Ujo)param));
            this.changeDefault(this, ORM2DLL_POLICY, ORM2DLL_POLICY.of((Ujo)param));
            this.changeDefault(this, DIALECT, DIALECT.of((Ujo)param));
            this.changeDefault(this, JDBC_URL, JDBC_URL.of((Ujo)param));
            this.changeDefault(this, JDBC_DRIVER, JDBC_DRIVER.of((Ujo)param));
            this.changeDefault(this, USER, USER.of((Ujo)param));
            this.changeDefault(this, PASSWORD, PASSWORD.of((Ujo)param));
            this.changeDefault(this, JNDI, JNDI.of((Ujo)param));
            this.changeDefault(this, SEQUENCER, SEQUENCER.of((Ujo)param));
        }
        if ((annotDB = database.getClass().getAnnotation(Db.class)) != null) {
            this.changeDefault(this, SCHEMA, annotDB.schema());
            this.changeDefault(this, READ_ONLY, annotDB.readOnly());
            this.changeDefault(this, ORM2DLL_POLICY, annotDB.Orm2ddlPolicy());
            this.changeDefault(this, DIALECT, annotDB.dialect());
            this.changeDefault(this, JDBC_URL, annotDB.jdbcUrl());
            this.changeDefault(this, JDBC_DRIVER, annotDB.jdbcDriver());
            this.changeDefault(this, USER, annotDB.user());
            this.changeDefault(this, PASSWORD, annotDB.password());
            this.changeDefault(this, JNDI, Arrays.asList(annotDB.jndi()));
            this.changeDefault(this, SEQUENCER, annotDB.sequencer());
        }
        this.changeDefault(this, ID, database.getClass().getSimpleName());
        this.changeDefault(this, JDBC_URL, this.getDialect().getJdbcUrl());
        this.changeDefault(this, JDBC_DRIVER, this.getDialect().getJdbcDriver());
        this.changeDefault(this, ORM2DLL_POLICY, MetaParams.ORM2DLL_POLICY.of((Ujo)this.getParams()));
        this.changeDefault(this, ORM2DLL_POLICY, MetaParams.ORM2DLL_POLICY.getDefault());
        for (UjoProperty tableProperty : database.readProperties()) {
            MetaTable par;
            if (tableProperty instanceof RelationToMany) {
                RelationToMany tProperty = (RelationToMany)tableProperty;
                par = param != null ? param.findTable(tProperty.getName()) : null;
                MetaTable table = new MetaTable(this, tProperty, par);
                TABLES.addItem((Ujo)this, (Object)table);
                ormHandler.addTableModel(table);
                continue;
            }
            if (!tableProperty.isTypeOf(DbProcedure.class)) continue;
            UjoProperty tProcedure = tableProperty;
            par = param != null ? param.findProcedure(tProcedure.getName()) : null;
            MetaProcedure procedure = new MetaProcedure(this, tProcedure, (MetaProcedure)((Object)par));
            PROCEDURES.addItem((Ujo)this, (Object)procedure);
            ormHandler.addProcedureModel(procedure);
        }
        RelationToMany relation = new RelationToMany((String)SCHEMA.of((Ujo)this), database.getClass());
        MetaTable table = new MetaTable(this, relation, null);
        table.setNotPersistent();
        TABLES.addItem((Ujo)this, (Object)table);
        ormHandler.addTableModel(table);
    }

    public SqlDialect getDialect() {
        if (this.dialect == null) {
            try {
                this.dialect = (SqlDialect)((Class)DIALECT.of((Ujo)this)).newInstance();
                this.dialect.setHandler(this.ormHandler);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't create an instance of " + this.dialect, e);
            }
        }
        return this.dialect;
    }

    public void changeDbType(MetaColumn column) {
        UjoProperty property = column.getProperty();
        Class type = property.getType();
        if (ValueExportable.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.VARCHAR);
        } else if (String.class == type) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.VARCHAR);
        } else if (Integer.class == type || Color.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.INT);
        } else if (Short.class == type) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.SMALLINT);
        } else if (Long.class == type || BigInteger.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.BIGINT);
        } else if (Double.class == type || BigDecimal.class == type) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.DECIMAL);
        } else if (Date.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.DATE);
        } else if (java.util.Date.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.TIMESTAMP);
        } else if (Character.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.CHAR);
        } else if (Boolean.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.BOOLEAN);
        } else if (Enum.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.SMALLINT);
        } else if (Blob.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.BLOB);
        } else if (Clob.class.isAssignableFrom(type)) {
            MetaColumn.DB_TYPE.setValue((Ujo)column, (Object)DbType.CLOB);
        } else if (OrmUjo.class.isAssignableFrom(type)) {
            // empty if block
        }
    }

    public void changeDbLength(MetaColumn column) {
        switch ((DbType)((Object)MetaColumn.DB_TYPE.of((Ujo)column))) {
            case DECIMAL: {
                this.changeDefault(column, MetaColumn.MAX_LENGTH, 8);
                this.changeDefault(column, MetaColumn.PRECISION, 2);
                break;
            }
            case VARCHAR: 
            case VARCHAR_IGNORECASE: {
                boolean isEnum = column.getType().isEnum();
                this.changeDefault(column, MetaColumn.MAX_LENGTH, isEnum ? 2 : 128);
                break;
            }
        }
    }

    private void createTableComments(List<MetaTable> cTables, Statement stat, StringBuilder out) {
        try {
            for (MetaTable table : cTables) {
                switch ((Orm2ddlPolicy)((Object)MetaTable.ORM2DLL_POLICY.of((Ujo)table))) {
                    case CREATE_DDL: 
                    case CREATE_OR_UPDATE_DDL: {
                        if (!table.isTable()) break;
                        if (table.isCommented()) {
                            out.setLength(0);
                            Appendable sql = this.getDialect().printComment(table, (Appendable)out);
                            if (sql.toString().length() > 0) {
                                this.executeUpdate(sql, stat, table);
                            }
                        }
                        for (MetaColumn column : (List)MetaTable.COLUMNS.of((Ujo)table)) {
                            if (!column.isCommented()) continue;
                            out.setLength(0);
                            Appendable sql = this.getDialect().printComment(column, (Appendable)out);
                            if (sql.toString().length() <= 0) continue;
                            this.executeUpdate(sql, stat, table);
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error on table comment: {0}", out);
        }
    }

    private String dbIdentifier(String name, DatabaseMetaData dmd) throws SQLException {
        if (dmd.storesUpperCaseIdentifiers()) {
            return name.toUpperCase();
        }
        if (dmd.storesLowerCaseIdentifiers()) {
            return name.toLowerCase();
        }
        return name;
    }

    private int getTableTotalCount() {
        int tableCount = 0;
        for (MetaTable metaTable : TABLES.getList((Ujo)this)) {
            if (!metaTable.isTable()) continue;
            ++tableCount;
        }
        return tableCount;
    }

    private boolean isModelChanged(Connection conn, List<MetaTable> newTables, List<MetaColumn> newColumns, List<MetaIndex> newIndexes) throws SQLException {
        newTables.clear();
        newColumns.clear();
        newIndexes.clear();
        DatabaseMetaData dmd = conn.getMetaData();
        String column = null;
        for (MetaTable table : (List)TABLES.of((Ujo)this)) {
            boolean exists;
            boolean tableExists;
            if (!table.isTable()) continue;
            HashSet<String> items = new HashSet<String>(32);
            ResultSet rs = dmd.getColumns(this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)table), dmd), null, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)table), dmd), column);
            while (rs.next()) {
                items.add(rs.getString("COLUMN_NAME").toUpperCase());
            }
            rs.close();
            boolean bl = tableExists = items.size() > 0;
            if (tableExists) {
                for (MetaColumn mc : (List)MetaTable.COLUMNS.of((Ujo)table)) {
                    exists = items.contains(((String)MetaColumn.NAME.of((Ujo)mc)).toUpperCase());
                    if (exists) continue;
                    LOGGER.log(Level.INFO, "New DB column: " + mc.getFullName());
                    newColumns.add(mc);
                }
            } else {
                LOGGER.log(Level.INFO, "New DB table: " + (String)MetaTable.NAME.of((Ujo)table));
                newTables.add(table);
            }
            items.clear();
            if (tableExists) {
                rs = dmd.getIndexInfo(this.dbIdentifier((String)MetaTable.SCHEMA.of((Ujo)table), dmd), null, this.dbIdentifier((String)MetaTable.NAME.of((Ujo)table), dmd), false, false);
                while (rs.next()) {
                    String name = rs.getString("INDEX_NAME");
                    if (name == null) continue;
                    items.add(name.toUpperCase());
                }
                rs.close();
            }
            for (MetaIndex index : table.getIndexCollection()) {
                exists = items.contains(((String)MetaIndex.NAME.of((Ujo)index)).toUpperCase());
                if (exists) continue;
                LOGGER.log(Level.INFO, "New DB index: " + (Object)((Object)index));
                newIndexes.add(index);
            }
        }
        boolean result = !newTables.isEmpty() || !newColumns.isEmpty() || !newIndexes.isEmpty();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Session session) {
        Connection conn = session.getConnection(this);
        Statement stat = null;
        StringBuilder out = new StringBuilder(256);
        Appendable sql = out;
        ArrayList<MetaTable> tables = new ArrayList<MetaTable>();
        ArrayList<MetaColumn> newColumns = new ArrayList<MetaColumn>();
        ArrayList<MetaColumn> foreignColumns = new ArrayList<MetaColumn>();
        ArrayList<MetaIndex> indexes = new ArrayList<MetaIndex>();
        boolean createSequenceTable = false;
        int tableTotalCount = this.getTableTotalCount();
        boolean anyChange = false;
        try {
            List<MetaTable> cTables;
            stat = conn.createStatement();
            if (this.isSequenceTableRequired()) {
                PreparedStatement ps = null;
                ResultSet rs = null;
                Throwable exception = null;
                String logMsg = "";
                try {
                    sql = this.getDialect().printSequenceCurrentValue(this.findFirstSequencer(), out);
                    ps = conn.prepareStatement(sql.toString());
                    ps.setString(1, "-");
                    rs = ps.executeQuery();
                }
                catch (Throwable e) {
                    exception = e;
                }
                if (exception != null) {
                    switch ((Orm2ddlPolicy)((Object)ORM2DLL_POLICY.of((Ujo)this))) {
                        case VALIDATE: 
                        case WARNING: {
                            throw new IllegalStateException(logMsg, exception);
                        }
                        case CREATE_DDL: 
                        case CREATE_OR_UPDATE_DDL: 
                        case INHERITED: {
                            createSequenceTable = true;
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    logMsg = "Table '" + this.getDialect().getSeqTableModel().getTableName() + "' {0} available on the database '{1}'.";
                    logMsg = MessageFormat.format(logMsg, exception != null ? "is not" : "is", this.getId());
                    LOGGER.log(Level.INFO, logMsg);
                }
                try {
                    if (exception != null) {
                        conn.rollback();
                    }
                }
                finally {
                    MetaDatabase.close(null, ps, rs, false);
                }
            }
            boolean ddlOnly = false;
            switch ((Orm2ddlPolicy)((Object)ORM2DLL_POLICY.of((Ujo)this))) {
                case CREATE_DDL: {
                    ddlOnly = true;
                }
                case CREATE_OR_UPDATE_DDL: 
                case VALIDATE: 
                case WARNING: 
                case INHERITED: {
                    boolean change = this.isModelChanged(conn, tables, newColumns, indexes);
                    if (!change || !ddlOnly || tables.size() >= tableTotalCount) break;
                    return;
                }
                default: {
                    return;
                }
            }
            switch ((CheckReport)((Object)MetaParams.CHECK_KEYWORDS.of((Ujo)this.getParams()))) {
                case WARNING: 
                case EXCEPTION: {
                    Set<String> keywords = this.getDialect().getKeywordSet(conn);
                    for (MetaTable table : tables) {
                        if (!table.isTable()) continue;
                        this.checkKeyWord((String)MetaTable.NAME.of((Ujo)table), table, keywords);
                        for (MetaColumn column : (List)MetaTable.COLUMNS.of((Ujo)table)) {
                            this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)column), table, keywords);
                        }
                    }
                    for (MetaColumn column : newColumns) {
                        this.checkKeyWord((String)MetaColumn.NAME.of((Ujo)column), column.getTable(), keywords);
                    }
                    for (MetaIndex index : indexes) {
                        this.checkKeyWord((String)MetaIndex.NAME.of((Ujo)index), (MetaTable)((Object)MetaIndex.TABLE.of((Ujo)index)), keywords);
                    }
                    break;
                }
            }
            if (tableTotalCount == tables.size()) {
                for (String schema : this.getSchemas(tables)) {
                    out.setLength(0);
                    sql = this.getDialect().printCreateSchema(schema, out);
                    if (!this.isUsable(sql)) continue;
                    try {
                        stat.executeUpdate(sql.toString());
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.INFO, "{0}: {1}; {2}", new Object[]{e.getClass().getName(), sql.toString(), e.getMessage()});
                        conn.rollback();
                    }
                }
            }
            int tableCount = 0;
            for (MetaTable table : tables) {
                if (!table.isTable()) continue;
                ++tableCount;
                out.setLength(0);
                sql = this.getDialect().printTable(table, out);
                this.executeUpdate(sql, stat, table);
                foreignColumns.addAll(table.getForeignColumns());
                anyChange = true;
            }
            for (MetaColumn column : newColumns) {
                out.setLength(0);
                sql = this.getDialect().printAlterTable(column, out);
                this.executeUpdate(sql, stat, column.getTable());
                anyChange = true;
                if (!column.isForeignKey()) continue;
                foreignColumns.add(column);
            }
            for (MetaIndex index : indexes) {
                out.setLength(0);
                sql = this.getDialect().printIndex(index, out);
                this.executeUpdate(sql, stat, (MetaTable)((Object)MetaIndex.TABLE.of((Ujo)index)));
                anyChange = true;
            }
            for (MetaColumn column : foreignColumns) {
                if (!column.isForeignKey()) continue;
                out.setLength(0);
                MetaTable table = (MetaTable)((Object)MetaColumn.TABLE.of((Ujo)column));
                sql = this.getDialect().printForeignKey(column, table, out);
                this.executeUpdate(sql, stat, column.getTable());
                anyChange = true;
            }
            if (createSequenceTable) {
                out.setLength(0);
                sql = this.getDialect().printSequenceTable(this, out);
                MetaTable table = new MetaTable();
                MetaTable.ORM2DLL_POLICY.setValue((Ujo)table, MetaParams.ORM2DLL_POLICY.getDefault());
                this.executeUpdate(sql, stat, table);
            }
            switch ((CommentPolicy)((Object)MetaParams.COMMENT_POLICY.of((Ujo)this.ormHandler.getParameters()))) {
                case FOR_NEW_OBJECT: {
                    cTables = tables;
                    break;
                }
                case ALWAYS: {
                    cTables = TABLES.getList((Ujo)this);
                    break;
                }
                case ON_ANY_CHANGE: {
                    cTables = anyChange ? TABLES.getList((Ujo)this) : Collections.emptyList();
                    break;
                }
                case NEVER: {
                    cTables = Collections.emptyList();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported parameter");
                }
            }
            if (!cTables.isEmpty()) {
                sql = out;
                this.createTableComments(cTables, stat, out);
            }
            conn.commit();
        }
        catch (Throwable e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "Can't rollback DB" + this.getId(), ex);
            }
            throw new IllegalArgumentException("ILLEGAL SQL: " + sql, e);
        }
    }

    private void executeUpdate(Appendable sql, Statement stat, MetaTable table) throws IllegalStateException, SQLException {
        boolean validateCase = false;
        switch (table.getOrm2ddlPolicy()) {
            case INHERITED: {
                throw new IllegalStateException("An internal error due the DDL policy: " + (Object)((Object)table.getOrm2ddlPolicy()));
            }
            case DO_NOTHING: {
                return;
            }
            case VALIDATE: {
                validateCase = true;
            }
            case WARNING: {
                String msg = "A database validation (caused by the parameter " + MetaTable.ORM2DLL_POLICY + ") have found an inconsistency. " + "There is required a database change: " + sql;
                if (validateCase) {
                    throw new IllegalStateException(msg);
                }
                LOGGER.log(Level.WARNING, msg);
            }
        }
        stat.executeUpdate(sql.toString());
        LOGGER.info(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection connection, JdbcStatement statement, ResultSet rs, boolean throwExcepton) throws IllegalStateException {
        try {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            String msg = "Can't close a SQL object";
            if (throwExcepton) {
                throw new IllegalStateException(msg, e);
            }
            LOGGER.log(Level.SEVERE, msg, e);
        }
    }

    protected void checkKeyWord(String word, MetaTable table, Set<String> keywords) throws Exception {
        if (keywords.contains(word.toUpperCase())) {
            String msg = "The database table or column called '" + word + "' is a SQL keyword. See the class: " + table.getType().getName() + ".\nNOTE: the keyword checking can be disabled by the Ujorm parameter: " + MetaParams.CHECK_KEYWORDS;
            switch ((CheckReport)((Object)MetaParams.CHECK_KEYWORDS.of((Ujo)this.getParams()))) {
                case EXCEPTION: {
                    throw new IllegalArgumentException(msg);
                }
                case WARNING: {
                    LOGGER.log(Level.WARNING, msg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Connection connection, Statement statement, ResultSet rs, boolean throwExcepton) throws IllegalStateException {
        try {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            String msg = "Can't close a SQL object";
            if (throwExcepton) {
                throw new IllegalStateException(msg, e);
            }
            LOGGER.log(Level.SEVERE, msg, e);
        }
    }

    public OrmHandler getOrmHandler() {
        return this.ormHandler;
    }

    public MetaParams getParams() {
        return this.ormHandler.getParameters();
    }

    public String getId() {
        return (String)ID.of((Ujo)this);
    }

    public Connection createConnection() throws Exception {
        Connection result = this.dialect.createConnection(this);
        result.setAutoCommit(false);
        return result;
    }

    public Connection createInternalConnection() throws Exception {
        Connection result;
        List jndi = (List)JNDI.of((Ujo)this);
        if (!jndi.isEmpty()) {
            LOGGER.log(Level.FINE, "JNDI: {0}", jndi);
            InitialContext initContext = this.dialect.createJndiInitialContext(this);
            int lastItem = jndi.size() - 1;
            for (int i = 0; i < lastItem; ++i) {
                if ((initContext = (InitialContext)initContext.lookup((String)jndi.get(i))) != null) continue;
                throw new IllegalStateException("JNDI problem: InitialContext was not found for the: " + (String)jndi.get(i));
            }
            DataSource dataSource = (DataSource)initContext.lookup((String)jndi.get(lastItem));
            if (dataSource == null) {
                throw new IllegalStateException("JNDI problem: database connection was not found for the: " + jndi);
            }
            result = dataSource.getConnection();
        } else {
            Class.forName((String)JDBC_DRIVER.of((Ujo)this));
            result = DriverManager.getConnection((String)JDBC_URL.of((Ujo)this), (String)USER.of((Ujo)this), (String)PASSWORD.of((Ujo)this));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetaDatabase) {
            MetaDatabase db = (MetaDatabase)obj;
            Integer i1 = (Integer)ORDER.of((Ujo)this);
            Integer i2 = (Integer)ORDER.of((Ujo)db);
            return i1.equals(i2);
        }
        return false;
    }

    public int hashCode() {
        Integer ir = (Integer)ORDER.of((Ujo)this);
        return ir.hashCode();
    }

    public Session getDefaultSession() {
        return this.ormHandler.getSession();
    }

    private Set<String> getSchemas(List<MetaTable> tables) {
        HashSet<String> result = new HashSet<String>();
        for (MetaTable table : tables) {
            String schema;
            if (!table.isTable() || !this.isUsable(schema = (String)MetaTable.SCHEMA.of((Ujo)table))) continue;
            result.add(schema);
        }
        return result;
    }

    MetaTable findTable(String id) {
        if (this.isUsable(id)) {
            for (MetaTable table : TABLES.getList((Ujo)this)) {
                if (!MetaTable.ID.equals((Ujo)table, (Object)id)) continue;
                return table;
            }
        }
        return null;
    }

    MetaProcedure findProcedure(String id) {
        if (this.isUsable(id)) {
            for (MetaProcedure procedure : PROCEDURES.getList((Ujo)this)) {
                if (!MetaProcedure.ID.equals((Ujo)procedure, (Object)id)) continue;
                return procedure;
            }
        }
        return null;
    }

    private UjoSequencer findFirstSequencer() {
        for (MetaTable table : (List)TABLES.of((Ujo)this)) {
            if (!table.isTable()) continue;
            return table.getSequencer();
        }
        return null;
    }

    public boolean isSequenceTableRequired() {
        for (MetaTable table : (List)TABLES.of((Ujo)this)) {
            if (!table.isTable() || !table.getSequencer().isSequenceTableRequired()) continue;
            return true;
        }
        return false;
    }

    protected UjoSequencer createSequencer(MetaTable table) {
        UjoSequencer result;
        Class seqClass = (Class)SEQUENCER.of((Ujo)this);
        if (seqClass == UjoSequencer.class) {
            result = new UjoSequencer(table);
        } else {
            try {
                Constructor constr = seqClass.getConstructor(MetaTable.class);
                result = (UjoSequencer)constr.newInstance(new Object[]{table});
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't create sequencer for " + seqClass, e);
            }
        }
        return result;
    }

    public List<MetaIndex> getIndexList() {
        ArrayList<MetaIndex> result = new ArrayList<MetaIndex>(32);
        for (MetaTable table : (List)TABLES.of((Ujo)this)) {
            result.addAll(table.getIndexCollection());
        }
        return result;
    }

    public String toString() {
        String msg = (String)ID.of((Ujo)this) + '[' + TABLES.getItemCount((Ujo)this) + ']';
        return msg;
    }

    @Override
    public int compareTo(MetaDatabase o) {
        Integer i1 = (Integer)ORDER.of((Ujo)this);
        Integer i2 = (Integer)ORDER.of((Ujo)o);
        return i1.compareTo(i2);
    }

    @Override
    public boolean readAuthorization(UjoAction action, UjoProperty property, Object value) {
        switch (action.getType()) {
            case 2: {
                return property != PASSWORD;
            }
        }
        return super.readAuthorization(action, property, value);
    }

    static {
        MetaDatabase.init((Class)CLASS);
    }
}

