/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.extensions.ListProperty;
import org.ujorm.extensions.Property;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaTable;

public final class MetaPKey
extends AbstractMetaModel {
    private static final Class CLASS = MetaPKey.class;
    public static final Property<MetaPKey, MetaTable> TABLE = MetaPKey.newProperty((String)"table", MetaTable.class);
    public static final ListProperty<MetaPKey, MetaColumn> COLUMNS = MetaPKey.newListProperty((String)"columns", MetaColumn.class);

    public MetaPKey(MetaTable table) {
        TABLE.setValue((Ujo)this, (Object)table);
        COLUMNS.setValue((Ujo)this, new ArrayList(0));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(10);
        for (MetaColumn column : COLUMNS.getList((Ujo)this)) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(column.toString());
        }
        return sb.toString();
    }

    public boolean assignPrimaryKey(OrmUjo bo, Session session) throws IllegalArgumentException {
        int count = COLUMNS.getItemCount((Ujo)this);
        if (count == 1) {
            MetaColumn column = (MetaColumn)((Object)COLUMNS.getItem((Ujo)this, 0));
            UjoProperty property = column.getProperty();
            if (property.of((Ujo)bo) != null) {
                return false;
            }
            long value = ((MetaTable)((Object)TABLE.of((Ujo)this))).getSequencer().nextValue(session);
            switch (column.getTypeCode()) {
                case '\u0006': {
                    bo.writeValue(property, value);
                    return true;
                }
                case '\u0005': {
                    bo.writeValue(property, (int)value);
                    return true;
                }
                case '\u0004': {
                    bo.writeValue(property, (short)value);
                    return true;
                }
                case '\u0002': {
                    bo.writeValue(property, (byte)value);
                    return true;
                }
                case '\n': {
                    bo.writeValue(property, BigInteger.valueOf(value));
                    return true;
                }
                case '\u000b': {
                    bo.writeValue(property, String.valueOf(value));
                    return true;
                }
            }
            return false;
        }
        String msg = "Table " + bo + " must have defined only one primary key type of Long, Integer, Short, Byte, BigInteger or String for an auto-increment support";
        throw new IllegalArgumentException(msg);
    }

    public MetaColumn getFirstColumn() {
        return this.getColumn(0);
    }

    public MetaColumn getColumn(int i) {
        return (MetaColumn)((Object)((List)COLUMNS.of((Ujo)this)).get(i));
    }

    static {
        MetaPKey.init((Class)CLASS);
    }
}

