/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.lang.reflect.Field;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoManager;
import org.ujorm.core.annot.Transient;
import org.ujorm.core.annot.XmlAttribute;
import org.ujorm.extensions.ListProperty;
import org.ujorm.extensions.Property;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.DbProcedure;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.annot.Parameter;
import org.ujorm.orm.annot.Procedure;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaProcedure
extends AbstractMetaModel {
    private static final Class CLASS = MetaProcedure.class;
    @XmlAttribute
    public static final Property<MetaProcedure, String> ID = MetaProcedure.newProperty((String)"id", (Object)"");
    public static final Property<MetaProcedure, String> NAME = MetaProcedure.newProperty((String)"name", (Object)"");
    public static final Property<MetaProcedure, String> SCHEMA = MetaProcedure.newProperty((String)"schema", (Object)"");
    public static final ListProperty<MetaProcedure, MetaColumn> PARAMETERS = MetaProcedure.newListProperty((String)"parameter", MetaColumn.class);
    @Transient
    public static final Property<MetaProcedure, UjoProperty> DB_PROPERTY = MetaProcedure.newProperty((String)"dbProperty", UjoProperty.class);
    @Transient
    public static final Property<MetaProcedure, MetaDatabase> DATABASE = MetaProcedure.newProperty((String)"database", MetaDatabase.class);
    @Transient
    private static final RelationToMany r2m = new RelationToMany("[PROCEDURE]", DbProcedure.class);
    private String procedureName = "";
    final boolean[] input = new boolean[this.readProperties().size()];
    final boolean[] output = new boolean[this.input.length];

    public MetaProcedure() {
    }

    public MetaProcedure(MetaDatabase database, UjoProperty dbProperty, MetaProcedure parProcedure) {
        this();
        ID.setValue((Ujo)this, (Object)dbProperty.getName());
        DATABASE.setValue((Ujo)this, (Object)database);
        DB_PROPERTY.setValue((Ujo)this, (Object)dbProperty);
        Field field = UjoManager.getInstance().getPropertyField((Ujo)MetaDatabase.ROOT.of((Ujo)database), dbProperty);
        Procedure proc1 = field.getAnnotation(Procedure.class);
        Procedure proc2 = dbProperty.getType().getAnnotation(Procedure.class);
        if (parProcedure != null) {
            this.changeDefault(this, NAME, NAME.of((Ujo)parProcedure));
            this.changeDefault(this, SCHEMA, SCHEMA.of((Ujo)parProcedure));
        }
        if (proc1 != null) {
            this.changeDefault(this, NAME, proc1.name());
        }
        if (proc1 != null) {
            this.changeDefault(this, NAME, proc1.value());
        }
        if (proc1 != null) {
            this.changeDefault(this, SCHEMA, proc1.schema());
        }
        if (proc2 != null) {
            this.changeDefault(this, NAME, proc2.name());
        }
        if (proc2 != null) {
            this.changeDefault(this, NAME, proc2.value());
        }
        if (proc2 != null) {
            this.changeDefault(this, SCHEMA, proc2.schema());
        }
        this.changeDefault(this, SCHEMA, MetaDatabase.SCHEMA.of((Ujo)database));
        this.changeDefault(this, NAME, dbProperty.getName());
        this.procedureName = "".endsWith((String)SCHEMA.of((Ujo)this)) ? (String)NAME.of((Ujo)this) : (String)SCHEMA.of((Ujo)this) + "." + (String)NAME.of((Ujo)this);
        OrmHandler dbHandler = database.getOrmHandler();
        UjoManager ujoManager = UjoManager.getInstance();
        MetaTable table = new MetaTable(database, r2m, null);
        for (UjoProperty p : ujoManager.readProperties(dbProperty.getType())) {
            MetaColumn c = new MetaColumn(table, p, null);
            PARAMETERS.addItem((Ujo)this, (Object)c);
            c.initTypeCode(database.getParams());
            boolean returnProperty = p.getIndex() == 0;
            Parameter par = returnProperty ? null : p.getClass().getAnnotation(Parameter.class);
            this.input[p.getIndex()] = par != null ? par.input() : !returnProperty;
            this.output[p.getIndex()] = par != null ? par.output() : returnProperty;
        }
    }

    public final Class<OrmUjo> getType() {
        return ((UjoProperty)DB_PROPERTY.of((Ujo)this)).getType();
    }

    public final MetaDatabase getDatabase() {
        return (MetaDatabase)DATABASE.of((Ujo)this);
    }

    public boolean isInput(MetaColumn column) {
        boolean result = this.input[column.getProperty().getIndex()];
        return result;
    }

    public boolean isOutput(MetaColumn column) {
        int index = column.getProperty().getIndex();
        boolean result = index == 0 || this.output[index];
        return result;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(10);
        sb.append(this.procedureName);
        sb.append("(");
        for (MetaColumn param : PARAMETERS.getList((Ujo)this)) {
            if (param.isVoid()) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append((CharSequence)param.getProperty());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    static {
        MetaProcedure.init((Class)CLASS);
    }
}

