/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ujorm.Ujo;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.extensions.ListProperty;
import org.ujorm.extensions.Property;
import org.ujorm.extensions.UjoTextable;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaParams;

public final class MetaRoot
extends AbstractMetaModel {
    private static final Class CLASS = MetaRoot.class;
    private static final Logger LOGGER = Logger.getLogger(MetaRoot.class.getName());
    public static final ListProperty<MetaRoot, MetaDatabase> DATABASES = MetaRoot.newListProperty((String)"database", MetaDatabase.class);
    public static final Property<MetaRoot, MetaParams> PARAMETERS = MetaRoot.newProperty((String)"parameters", MetaParams.class);

    public MetaRoot() {
        PARAMETERS.setValue((Ujo)this, (Object)new MetaParams());
    }

    public MetaDatabase getDatabase() {
        MetaDatabase result = DATABASES.getItemCount((Ujo)this) > 0 ? (MetaDatabase)DATABASES.getItem((Ujo)this, 0) : null;
        return result;
    }

    public MetaDatabase getDatabase(String name) {
        for (MetaDatabase database : DATABASES.getList((Ujo)this)) {
            if (name != null && !MetaDatabase.SCHEMA.equals((Ujo)database, (Object)name)) continue;
            return database;
        }
        return null;
    }

    public int getDatabaseCount() {
        return DATABASES.getItemCount((Ujo)this);
    }

    public final void add(MetaDatabase database) {
        DATABASES.addItem((Ujo)this, (Object)database);
    }

    public String toString() {
        CharArrayWriter out = new CharArrayWriter(128);
        try {
            this.print(out);
            out.append("\n---\n");
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Can't export model into XML", ex);
        }
        return out.toString();
    }

    private String getXmlHeader() {
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyy/MM/dd mm:HH", Locale.ENGLISH);
        String result = new StringBuilder(128).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n<!-- The Ujorm configuration file release ").append(UjoManager.projectVersion()).append(" was created ").append(dFormat.format(new Date())).append(" -->").toString();
        return result;
    }

    public void print(Writer writer) throws IOException {
        UjoManagerXML.getInstance().saveXML(writer, (UjoTextable)this, this.getXmlHeader(), ((Object)((Object)this)).getClass());
    }

    public void print(File file) throws IOException {
        UjoManagerXML.getInstance().saveXML(file, (UjoTextable)this, this.getXmlHeader(), ((Object)((Object)this)).getClass());
    }

    public MetaDatabase removeDb(String databaseId) {
        if (super.readOnly()) {
            throw new UnsupportedOperationException("The internal state is 'read only'");
        }
        if (this.isUsable(databaseId)) {
            for (MetaDatabase db : DATABASES.getList((Ujo)this)) {
                MetaDatabase.ID.getValue((Ujo)db);
                if (!MetaDatabase.ID.equals((Ujo)db, (Object)databaseId)) continue;
                DATABASES.getList((Ujo)this).remove(db);
                return db;
            }
        }
        return null;
    }

    static {
        MetaRoot.init((Class)CLASS);
    }
}

