/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.UjoPropertyList;
import org.ujorm.extensions.Property;
import org.ujorm.orm.AbstractMetaModel;

public final class MetaSelect
extends AbstractMetaModel {
    private static final Class CLASS = MetaSelect.class;
    private static final Logger LOGGER = Logger.getLogger(MetaSelect.class.getName());
    public static final Property<MetaSelect, String> SELECT = MetaSelect.newProperty((String)"SELECT ", (Object)"");
    public static final Property<MetaSelect, String> FROM = MetaSelect.newProperty((String)" FROM ", (Object)"");
    public static final Property<MetaSelect, String> WHERE = MetaSelect.newProperty((String)" WHERE ", (Object)"");
    public static final Property<MetaSelect, String> GROUP = MetaSelect.newProperty((String)" GROUP BY ", (Object)"");
    public static final Property<MetaSelect, String> ORDER = MetaSelect.newProperty((String)" ORDER BY ", (Object)"");
    public static final Property<MetaSelect, String> LIMIT = MetaSelect.newProperty((String)" LIMIT ", (Object)"");
    private static String END_CHAR;

    public MetaSelect(String select) {
        this.parse(select);
    }

    private void parse(String select) {
        String orig = select.trim();
        select = orig.toUpperCase();
        int i = select.length();
        if (select.endsWith(END_CHAR)) {
            select = select.substring(i -= END_CHAR.length());
        }
        UjoPropertyList props = this.readProperties();
        for (int j = props.size() - 1; j >= 0; --j) {
            UjoProperty p = props.get(j);
            i = select.lastIndexOf(p.getName());
            if (i < 0) continue;
            String value = orig.substring(i + p.getName().length(), select.length()).trim();
            this.writeValue(p, value);
            select = select.substring(0, i);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.toString());
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder(128);
        for (UjoProperty p : this.readProperties()) {
            String value = (String)p.of((Ujo)this);
            if (value.isEmpty()) continue;
            r.append((CharSequence)p);
            r.append(value);
        }
        return r.toString();
    }

    static {
        MetaSelect.init((Class)CLASS);
        END_CHAR = ";";
    }
}

