/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.metaModel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoManager;
import org.ujorm.core.annot.Transient;
import org.ujorm.core.annot.XmlAttribute;
import org.ujorm.extensions.ListProperty;
import org.ujorm.extensions.Property;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.AbstractMetaModel;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Session;
import org.ujorm.orm.UjoSequencer;
import org.ujorm.orm.annot.Comment;
import org.ujorm.orm.annot.Table;
import org.ujorm.orm.annot.View;
import org.ujorm.orm.ao.Orm2ddlPolicy;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaDatabase;
import org.ujorm.orm.metaModel.MetaIndex;
import org.ujorm.orm.metaModel.MetaPKey;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaRelation2Many;
import org.ujorm.orm.metaModel.MetaSelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaTable
extends AbstractMetaModel {
    private static final Class CLASS = MetaTable.class;
    @XmlAttribute
    public static final Property<MetaTable, String> ID = MetaTable.newProperty((String)"id", (Object)"");
    public static final Property<MetaTable, String> NAME = MetaTable.newProperty((String)"name", (Object)"");
    public static final Property<MetaTable, String> ALIAS = MetaTable.newProperty((String)"alias", (Object)"");
    public static final Property<MetaTable, String> SCHEMA = MetaTable.newProperty((String)"schema", (Object)"");
    public static final Property<MetaTable, Boolean> READ_ONLY = MetaTable.newProperty((String)"readOnly", (Object)false);
    public static final Property<MetaTable, Orm2ddlPolicy> ORM2DLL_POLICY = MetaTable.newProperty((String)"orm2ddlPolicy", (Object)((Object)Orm2ddlPolicy.INHERITED));
    public static final Property<MetaTable, String> SEQUENCE = MetaTable.newProperty((String)"sequence", (Object)"");
    public static final ListProperty<MetaTable, MetaColumn> COLUMNS = MetaTable.newListProperty((String)"column", MetaColumn.class);
    public static final ListProperty<MetaTable, MetaRelation2Many> RELATIONS = MetaTable.newListProperty((String)"relation2m", MetaRelation2Many.class);
    @XmlAttribute
    public static final Property<MetaTable, Boolean> VIEW = MetaTable.newProperty((String)"view", (Object)false);
    public static final Property<MetaTable, String> SELECT = MetaTable.newProperty((String)"select", (Object)"");
    public static final Property<MetaTable, String> COMMENT = MetaTable.newProperty((String)"comment", (Object)"");
    @Transient
    public static final Property<MetaTable, MetaSelect> SELECT_MODEL = MetaTable.newProperty((String)"selectModel", MetaSelect.class);
    @Transient
    public static final Property<MetaTable, MetaPKey> PK = MetaTable.newProperty((String)"pk", MetaPKey.class);
    @Transient
    public static final Property<MetaTable, RelationToMany> DB_PROPERTY = MetaTable.newProperty((String)"dbProperty", RelationToMany.class);
    @Transient
    public static final Property<MetaTable, MetaDatabase> DATABASE = MetaTable.newProperty((String)"database", MetaDatabase.class);
    private final UjoSequencer sequencer;
    private Boolean sequenceSchemaSymbol;

    public MetaTable() {
        this.sequencer = null;
    }

    public MetaTable(MetaDatabase database, RelationToMany dbProperty, MetaTable parTable) {
        this.sequencer = database.createSequencer(this);
        ID.setValue((Ujo)this, (Object)dbProperty.getName());
        DATABASE.setValue((Ujo)this, (Object)database);
        DB_PROPERTY.setValue((Ujo)this, (Object)dbProperty);
        Field field = UjoManager.getInstance().getPropertyField((Ujo)MetaDatabase.ROOT.of((Ujo)database), (UjoProperty)dbProperty);
        View view1 = field.getAnnotation(View.class);
        View view2 = dbProperty.getItemType().getAnnotation(View.class);
        VIEW.setValue((Ujo)this, (Object)(view1 != null || view2 != null ? 1 : 0));
        if (parTable != null) {
            this.changeDefault(this, NAME, NAME.of((Ujo)parTable));
            this.changeDefault(this, ALIAS, ALIAS.of((Ujo)parTable));
            this.changeDefault(this, SCHEMA, SCHEMA.of((Ujo)parTable));
            this.changeDefault(this, READ_ONLY, READ_ONLY.of((Ujo)parTable));
            this.changeDefault(this, ORM2DLL_POLICY, ORM2DLL_POLICY.of((Ujo)parTable));
            this.changeDefault(this, SEQUENCE, SEQUENCE.of((Ujo)parTable));
            this.changeDefault(this, SELECT, SELECT.of((Ujo)parTable));
            this.changeDefault(this, VIEW, VIEW.of((Ujo)parTable));
            this.changeDefault(this, COMMENT, COMMENT.of((Ujo)parTable));
        }
        if (((Boolean)VIEW.of((Ujo)this)).booleanValue()) {
            if (view1 != null) {
                this.changeDefault(this, NAME, view1.name());
            }
            if (view1 != null) {
                this.changeDefault(this, NAME, view1.value());
            }
            if (view1 != null) {
                this.changeDefault(this, ALIAS, view1.alias());
            }
            if (view1 != null) {
                this.changeDefault(this, SCHEMA, view1.schema());
            }
            if (view1 != null) {
                this.changeDefault(this, SELECT, view1.select());
            }
            if (view2 != null) {
                this.changeDefault(this, NAME, view2.name());
            }
            if (view2 != null) {
                this.changeDefault(this, NAME, view2.value());
            }
            if (view2 != null) {
                this.changeDefault(this, ALIAS, view2.alias());
            }
            if (view2 != null) {
                this.changeDefault(this, SCHEMA, view2.schema());
            }
            if (view2 != null) {
                this.changeDefault(this, SELECT, view2.select());
            }
            if (!SELECT.isDefault((Ujo)this)) {
                SELECT_MODEL.setValue((Ujo)this, (Object)new MetaSelect((String)SELECT.of((Ujo)this)));
            }
        } else {
            Table table1 = field.getAnnotation(Table.class);
            Table table2 = dbProperty.getItemType().getAnnotation(Table.class);
            if (table1 != null) {
                this.changeDefault(this, NAME, table1.name());
            }
            if (table1 != null) {
                this.changeDefault(this, NAME, table1.value());
            }
            if (table1 != null) {
                this.changeDefault(this, ALIAS, table1.alias());
            }
            if (table1 != null) {
                this.changeDefault(this, SCHEMA, table1.schema());
            }
            if (table1 != null) {
                this.changeDefault(this, READ_ONLY, table1.readOnly());
            }
            if (table1 != null) {
                this.changeDefault(this, ORM2DLL_POLICY, table1.orm2ddlPolicy());
            }
            if (table1 != null) {
                this.changeDefault(this, SEQUENCE, table1.sequence());
            }
            if (table2 != null) {
                this.changeDefault(this, NAME, table2.name());
            }
            if (table2 != null) {
                this.changeDefault(this, NAME, table2.value());
            }
            if (table2 != null) {
                this.changeDefault(this, ALIAS, table2.alias());
            }
            if (table2 != null) {
                this.changeDefault(this, SCHEMA, table2.schema());
            }
            if (table2 != null) {
                this.changeDefault(this, READ_ONLY, table2.readOnly());
            }
            if (table2 != null) {
                this.changeDefault(this, ORM2DLL_POLICY, table2.orm2ddlPolicy());
            }
            if (table2 != null) {
                this.changeDefault(this, SEQUENCE, table2.sequence());
            }
        }
        this.changeDefault(this, SCHEMA, MetaDatabase.SCHEMA.of((Ujo)database));
        this.changeDefault(this, READ_ONLY, MetaDatabase.READ_ONLY.of((Ujo)database));
        this.changeDefault(this, ORM2DLL_POLICY, MetaDatabase.ORM2DLL_POLICY.of((Ujo)database));
        this.changeDefault(this, NAME, dbProperty.getName());
        String aliasPrefix = (String)MetaParams.TABLE_ALIAS_PREFIX.of((Ujo)database.getParams());
        String aliasSuffix = (String)MetaParams.TABLE_ALIAS_SUFFIX.of((Ujo)database.getParams());
        this.changeDefault(this, ALIAS, aliasPrefix + (String)NAME.of((Ujo)this) + aliasSuffix);
        Comment comment1 = field.getAnnotation(Comment.class);
        Comment comment2 = dbProperty.getItemType().getAnnotation(Comment.class);
        if (comment1 != null) {
            this.changeDefault(this, COMMENT, comment1.value());
        }
        if (comment2 != null) {
            this.changeDefault(this, COMMENT, comment2.value());
        }
        MetaPKey dpk = new MetaPKey(this);
        PK.setValue((Ujo)this, (Object)dpk);
        OrmHandler dbHandler = database.getOrmHandler();
        UjoManager ujoManager = UjoManager.getInstance();
        for (UjoProperty property : ujoManager.readProperties(dbProperty.getItemType())) {
            MetaRelation2Many column;
            MetaRelation2Many param;
            if (ujoManager.isTransientProperty(property)) continue;
            if (property instanceof RelationToMany) {
                param = parTable != null ? parTable.findRelation(property.getName()) : null;
                column = new MetaRelation2Many(this, property, param);
                RELATIONS.addItem((Ujo)this, (Object)column);
                dbHandler.addColumnModel(column);
                continue;
            }
            param = parTable != null ? parTable.findColumn(property.getName()) : null;
            column = new MetaColumn(this, property, (MetaColumn)param);
            COLUMNS.addItem((Ujo)this, (Object)column);
            dbHandler.addColumnModel(column);
            if (!((Boolean)MetaColumn.PRIMARY_KEY.of((Ujo)column)).booleanValue()) continue;
            MetaPKey.COLUMNS.addItem((Ujo)dpk, (Object)column);
        }
    }

    public void assignPrimaryKey(OrmUjo bo, Session session) {
        Class<OrmUjo> type = this.getType();
        if (type.isInstance(bo)) {
            try {
                MetaPKey pk = (MetaPKey)((Object)PK.of((Ujo)this));
                pk.assignPrimaryKey(bo, session);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("DB SEQUENCE is not supported for " + type, e);
            }
        } else {
            throw new IllegalArgumentException("Argument is not type of " + type);
        }
    }

    public OrmUjo createBO() throws InstantiationException, IllegalAccessException {
        OrmUjo result = this.getType().newInstance();
        return result;
    }

    public final Class<OrmUjo> getType() {
        return ((RelationToMany)((Object)DB_PROPERTY.of((Ujo)this))).getItemType();
    }

    public MetaColumn getFirstPK() {
        return ((MetaPKey)((Object)PK.of((Ujo)this))).getFirstColumn();
    }

    public boolean isPersistent() {
        return DATABASE.of((Ujo)this) != null;
    }

    public boolean isDefaultSchema() {
        if (this.sequenceSchemaSymbol == null) {
            this.sequenceSchemaSymbol = this.getDatabase().getParams().get(MetaParams.SEQUENCE_SCHEMA_SYMBOL);
        }
        if (this.sequenceSchemaSymbol.booleanValue()) {
            String tableSchema = (String)SCHEMA.of((Ujo)this);
            String defaultSchema = (String)MetaDatabase.SCHEMA.of((Ujo)this.getDatabase());
            return tableSchema.equals(defaultSchema);
        }
        return false;
    }

    public boolean isView() {
        return (Boolean)VIEW.of((Ujo)this);
    }

    public boolean isTable() {
        return this.isPersistent() && !this.isView();
    }

    public boolean isCommented() {
        return !COMMENT.isDefault((Ujo)this);
    }

    public String getComment() {
        return (String)COMMENT.of((Ujo)this);
    }

    public boolean isSelectModel() {
        return SELECT_MODEL.of((Ujo)this) != null;
    }

    public void setNotPersistent() {
        DATABASE.setValue((Ujo)this, null);
    }

    public String getAlias() {
        return (String)ALIAS.of((Ujo)this);
    }

    public final MetaDatabase getDatabase() {
        return (MetaDatabase)DATABASE.of((Ujo)this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    MetaColumn findColumn(String id) {
        if (this.isUsable(id)) {
            for (MetaColumn column : (List)COLUMNS.of((Ujo)this)) {
                if (!MetaColumn.ID.equals((Ujo)column, (Object)id)) continue;
                return column;
            }
        }
        return null;
    }

    MetaRelation2Many findRelation(String id) {
        if (this.isUsable(id)) {
            for (MetaRelation2Many relation : (List)RELATIONS.of((Ujo)this)) {
                if (!MetaRelation2Many.ID.equals((Ujo)relation, (Object)id)) continue;
                return relation;
            }
        }
        return null;
    }

    public List<MetaColumn> getForeignColumns() {
        ArrayList<MetaColumn> result = new ArrayList<MetaColumn>();
        for (MetaColumn column : COLUMNS.getList((Ujo)this)) {
            if (!column.isForeignKey()) continue;
            result.add(column);
        }
        return result;
    }

    public UjoSequencer getSequencer() {
        return this.sequencer;
    }

    public Collection<MetaIndex> getIndexCollection() {
        HashMap<String, MetaIndex> mapIndex = new HashMap<String, MetaIndex>();
        block0: for (MetaColumn column : COLUMNS.getList((Ujo)this)) {
            String[] idxs = new String[]{(String)MetaColumn.INDEX.of((Ujo)column), (String)MetaColumn.UNIQUE_INDEX.of((Ujo)column)};
            for (int i = 0; i < 2; ++i) {
                if (idxs[i].length() <= 0) continue;
                String upperIdx = idxs[i].toUpperCase();
                MetaIndex mIndex = (MetaIndex)((Object)mapIndex.get(upperIdx));
                if (mIndex == null) {
                    mIndex = new MetaIndex(idxs[i], this);
                    mapIndex.put(upperIdx, mIndex);
                }
                if (i == 0) {
                    MetaIndex.UNIQUE.setValue((Ujo)mIndex, (Object)false);
                } else if (upperIdx.equalsIgnoreCase(idxs[0])) continue block0;
                MetaIndex.COLUMNS.addItem((Ujo)mIndex, (Object)column);
            }
        }
        return mapIndex.values();
    }

    public OrmUjo getParent(OrmUjo bo) {
        MetaColumn metaColumn = this.getFirstPK();
        if (metaColumn.isForeignKey()) {
            return (OrmUjo)metaColumn.getValue(bo);
        }
        return null;
    }

    public boolean isReadOnly() {
        return (Boolean)READ_ONLY.of((Ujo)this);
    }

    public void assertChangeAllowed() {
        if (this.isReadOnly()) {
            String msg = "The table '" + (String)NAME.of((Ujo)this) + "' have got the READ-ONLY mode. Check the Ujorm meta-model configuration.";
            throw new IllegalStateException(msg);
        }
    }

    public Orm2ddlPolicy getOrm2ddlPolicy() {
        return (Orm2ddlPolicy)((Object)ORM2DLL_POLICY.of((Ujo)this));
    }

    static {
        MetaTable.init((Class)CLASS);
    }
}

