/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.utility;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.ujorm.CompositeProperty;
import org.ujorm.Ujo;
import org.ujorm.UjoProperty;
import org.ujorm.core.UjoIterator;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.ExtendedOrmUjo;
import org.ujorm.orm.ForeignKey;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.orm.metaModel.MetaParams;
import org.ujorm.orm.metaModel.MetaTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrmTools {
    public static final SerialBlob createBlob(byte[] bytes) {
        try {
            return bytes != null ? new SerialBlob(bytes) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static SerialBlob createBlob(InputStream inputStream) {
        try {
            int len;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
            while ((len = inputStream.read(buffer)) >= 0) {
                baos.write(buffer, 0, len);
            }
            SerialBlob serialBlob = new SerialBlob(baos.toByteArray());
            return serialBlob;
        }
        catch (Exception e) {
            throw new IllegalStateException("Reding error", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Reding error", e);
            }
        }
    }

    public static byte[] getBlobBytes(Blob blob) throws IllegalStateException, IndexOutOfBoundsException {
        try {
            if (blob == null) {
                return null;
            }
            if (blob.length() <= Integer.MAX_VALUE) {
                return blob.getBytes(1L, (int)blob.length());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Reding error", e);
        }
        throw new IndexOutOfBoundsException("Length of the result is great than Integer.MAX_VALUE");
    }

    public static InputStream getBlobStream(Blob blob) throws IllegalStateException {
        try {
            return blob.getBinaryStream();
        }
        catch (Exception e) {
            throw new IllegalStateException("Reding error", e);
        }
    }

    public static final SerialClob createClob(char[] text) {
        try {
            return text != null ? new SerialClob(text) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static final SerialClob createClob(String text) {
        return text != null ? OrmTools.createClob(text.toCharArray()) : null;
    }

    public static final SerialClob createClob(Reader reader) {
        try {
            int len;
            char[] buffer = new char[1024];
            CharArrayWriter baos = new CharArrayWriter(buffer.length);
            while ((len = reader.read(buffer)) >= 0) {
                baos.write(buffer, 0, len);
            }
            SerialClob serialClob = new SerialClob(baos.toCharArray());
            return serialClob;
        }
        catch (Exception e) {
            throw new IllegalStateException("Reader error", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Reader error", e);
            }
        }
    }

    public static String getClobString(Clob clob) throws IllegalStateException, IndexOutOfBoundsException {
        try {
            if (clob == null) {
                return null;
            }
            if (clob.length() <= Integer.MAX_VALUE) {
                return clob.getSubString(1L, (int)clob.length());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Reding error", e);
        }
        throw new IndexOutOfBoundsException("Length of the result is great than Integer.MAX_VALUE");
    }

    public static char[] getClob(Clob clob) throws IllegalStateException, IndexOutOfBoundsException {
        return clob != null ? OrmTools.getClobString(clob).toCharArray() : null;
    }

    public static void loadLazyValues(OrmUjo ujo) {
        OrmTools.loadLazyValues(ujo, 1);
    }

    public static void loadLazyValues(OrmUjo ujo, int depth) {
        if (--depth < 0) {
            return;
        }
        for (UjoProperty p : ujo.readProperties()) {
            Object value;
            if (!p.isTypeOf(OrmUjo.class) || (value = p.getValue((Ujo)ujo)) == null || depth <= 0) continue;
            OrmTools.loadLazyValues((OrmUjo)value, depth);
        }
    }

    public static <UJO extends OrmUjo> List<UJO> loadLazyValues(Iterable<UJO> ujos, int depth) {
        List<OrmUjo> result = ujos instanceof List ? null : new ArrayList(64);
        for (OrmUjo ujo : ujos) {
            OrmTools.loadLazyValues(ujo, depth);
            if (result == null) continue;
            result.add(ujo);
        }
        if (result == null) {
            result = (List)ujos;
        }
        return result;
    }

    public boolean reload(OrmUjo ujo, Session session) {
        return session.reload(ujo);
    }

    public static <UJO extends ExtendedOrmUjo> List<UJO> loadLazyValuesAsBatch(Iterable<UJO> ujos, UjoProperty<UJO, ? extends OrmUjo> property) {
        ArrayList<ExtendedOrmUjo> result = new ArrayList<ExtendedOrmUjo>(ujos instanceof List ? ((List)ujos).size() : 128);
        HashMap<Object, OrmUjo> map = new HashMap<Object, OrmUjo>(64);
        while (!property.isDirect()) {
            property = ((CompositeProperty)property).getFirstProperty();
        }
        for (ExtendedOrmUjo u : ujos) {
            result.add(u);
            ForeignKey fk = u.readFK(property);
            if (fk == null) continue;
            map.put(fk.getValue(), null);
        }
        if (result.isEmpty()) {
            return result;
        }
        Session session = ((ExtendedOrmUjo)result.get(0)).readSession();
        MetaColumn column = (MetaColumn)session.getHandler().findColumnModel(property);
        MetaColumn pkColumn = column.getForeignColumns().get(0);
        Query<OrmUjo> query = session.createQuery(pkColumn.getTable().getType());
        int limit = session.getParameters().get(MetaParams.MAX_ITEM_COUNT_4_IN);
        int count = map.size();
        ArrayList idList = new ArrayList(Math.min(limit, count));
        Iterator keys = map.keySet().iterator();
        for (int i = 1; i <= count; ++i) {
            idList.add(keys.next());
            if (i % limit != 0 && i != count) continue;
            query.setCriterion((Criterion<OrmUjo>)Criterion.whereIn((UjoProperty)pkColumn.getProperty(), idList));
            for (OrmUjo u : query) {
                map.put(pkColumn.getValue(u), u);
            }
            idList.clear();
        }
        for (ExtendedOrmUjo u : result) {
            ForeignKey fk = u.readFK(property);
            if (fk == null) continue;
            u.writeSession(null);
            u.writeValue(property, map.get(fk.getValue()));
            u.writeSession(session);
        }
        return result;
    }

    public static <UJO extends ExtendedOrmUjo> List<UJO> loadLazyValuesAsBatch(Query<UJO> query) {
        List result = ((UjoIterator)query.iterator()).toList();
        List columns = MetaTable.COLUMNS.getList((Ujo)query.getTableModel());
        for (MetaColumn col : columns) {
            if (!col.isForeignKey()) continue;
            OrmTools.loadLazyValuesAsBatch(result, col.getProperty());
        }
        return result;
    }
}

