/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.support;

import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.Session;
import org.ujorm.orm.support.UjoSessionFactory;

@Deprecated
public class AroundServiceTransaction {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(AroundServiceTransaction.class);
    private final UjoSessionFactory ujoSessionFactory;
    private final ThreadLocal<AtomicInteger> deepHolder = new ThreadLocal();

    public AroundServiceTransaction(UjoSessionFactory ujoSessionFactory) {
        this.ujoSessionFactory = ujoSessionFactory;
    }

    protected Session getSession() {
        return this.ujoSessionFactory.getDefaultSession();
    }

    public Object aroundFilter(ProceedingJoinPoint call) throws Throwable {
        try {
            if (this.incCalling()) {
                this.beginTransaction();
            }
            Object object = this.doCall(call);
            return object;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            this.markForRollback();
            throw e;
        }
        finally {
            if (this.decCalling()) {
                this.finishTransaction();
            }
        }
    }

    protected void beginTransaction() {
        LOGGER.log(UjoLogger.TRACE, "Auto transaction registred/started");
        this.ujoSessionFactory.setAutoTransaction(true);
    }

    protected void markForRollback() {
        this.getSession().markForRolback();
    }

    protected void finishTransaction() {
        try {
            LOGGER.log(UjoLogger.TRACE, "Auto transaction ending (commit/rollback)");
            Session session = this.getSession();
            if (session.isRollbackOnly()) {
                LOGGER.log(UjoLogger.DEBUG, "Transaction rolling back because it has been marked as rollback-only");
                session.rollback();
            } else {
                session.commit();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            LOGGER.log(UjoLogger.ERROR, "Transaction close error", e);
        }
    }

    private Object doCall(ProceedingJoinPoint call) throws Throwable {
        if (call.getArgs() != null) {
            return call.proceed(call.getArgs());
        }
        return call.proceed();
    }

    private boolean incCalling() {
        if (this.deepHolder.get() == null) {
            this.deepHolder.set(new AtomicInteger(1));
            return true;
        }
        AtomicInteger deep = this.deepHolder.get();
        deep.incrementAndGet();
        return false;
    }

    private boolean decCalling() {
        AtomicInteger deep = this.deepHolder.get();
        if (deep.decrementAndGet() == 0) {
            this.deepHolder.set(null);
            return true;
        }
        return false;
    }
}

