/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.Ujo;
import org.ujorm.UjoDecorator;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyRing;
import org.ujorm.extensions.NativeUjoDecorator;
import org.ujorm.implementation.orm.OrmTable;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.annot.Db;
import org.ujorm.tools.Assert;

public class PackageDbConfig<U extends OrmUjo>
extends NativeUjoDecorator<U> {
    @Nonnull
    protected final KeyList<U> keyList;

    public <U extends OrmUjo> PackageDbConfig(@Nonnull Class<U> dbClass) throws IllegalArgumentException {
        super(dbClass);
        ArrayList<RelationToMany> result = new ArrayList<RelationToMany>();
        List<Class> tables = this.findTables();
        Collections.sort(tables, (c1, c2) -> c1.getSimpleName().compareTo(c2.getSimpleName()));
        int max = tables.size();
        for (int i = 0; i < max; ++i) {
            Class type = tables.get(i);
            result.add(new RelationToMany(type.getSimpleName(), dbClass, type, i, true));
        }
        Assert.hasLength(result, (Object[])new String[]{"At least one table is needed"});
        this.keyList = KeyRing.of(dbClass, result);
    }

    @Nonnull
    public KeyList<U> getKeys() {
        return this.keyList;
    }

    private Set<Package> getPackages() {
        KeyList tableList = ((OrmUjo)this.domain).readKeys();
        HashSet<Package> result = new HashSet<Package>(1 + tableList.size());
        if (tableList.isEmpty()) {
            result.add(((OrmUjo)this.domain).getClass().getPackage());
        } else {
            for (Key key : tableList) {
                if (!(key instanceof RelationToMany)) continue;
                result.add(((RelationToMany)key).getItemType().getPackage());
            }
        }
        return result;
    }

    @Nonnull
    private List<Class> findTables() {
        try {
            ArrayList<Class> result = new ArrayList<Class>();
            for (Package p : this.getPackages()) {
                Resource[] resources;
                String basePackage = "/" + p.getName().replace('.', '/');
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
                String locationPattern = "classpath*:" + this.resolveBasePackage(basePackage) + "/*.class";
                for (Resource resource : resources = resolver.getResources(locationPattern)) {
                    MetadataReader reader;
                    Class<?> clazz;
                    if (!resource.isReadable() || !this.isCandidate(clazz = Class.forName((reader = metadataReaderFactory.getMetadataReader(resource)).getClassMetadata().getClassName()))) continue;
                    result.add(clazz);
                }
            }
            return result;
        }
        catch (IOException | ReflectiveOperationException | RuntimeException e) {
            throw new IllegalUjormException((Throwable)e);
        }
    }

    private String resolveBasePackage(@Nonnull String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    protected boolean isCandidate(@Nonnull Class<?> clazz) throws ReflectiveOperationException {
        if (!OrmTable.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.getAnnotation(Db.class) != null) {
            return false;
        }
        return !((OrmUjo)this.domain).getClass().equals(clazz);
    }

    public static <U extends Ujo> UjoDecorator<U> of(@Nonnull Class<U> dbClass) {
        return new PackageDbConfig<U>(dbClass);
    }
}

