/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.support;

import org.aspectj.lang.ProceedingJoinPoint;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.Session;
import org.ujorm.orm.support.UjoSessionFactory;
import org.ujorm.orm.support.UjoSessionFactoryAOP;
import org.ujorm.orm.support.UjoSessionFactoryFilter;
import org.ujorm.orm.support.UjoSessionFactoryThreadImpl;

public class UjoSessionFactoryImpl
implements UjoSessionFactory,
UjoSessionFactoryAOP,
UjoSessionFactoryFilter {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjoSessionFactoryImpl.class);
    private final ThreadLocal<UjoSessionFactoryThreadImpl> holder = new ThreadLocal();
    private OrmHandler handler;

    @Override
    public Session getDefaultSession() {
        return this.getThreadImpl().getDefaultSession();
    }

    @Override
    public void setAutoTransaction(boolean b) {
        this.getThreadImpl().setAutoTransaction(b);
    }

    @Override
    public Object aroundSession(ProceedingJoinPoint call) throws Throwable {
        Object result = this.getThreadImpl().aroundSession(call);
        if (this.getThreadImpl().isSessionClosed()) {
            this.removeThreadImpl();
        }
        return result;
    }

    @Override
    public void openSession() {
        this.getThreadImpl().openSession();
    }

    @Override
    public void closeSession() {
        this.getThreadImpl().closeSession();
        this.removeThreadImpl();
    }

    private UjoSessionFactoryThreadImpl getThreadImpl() {
        if (this.holder.get() == null) {
            if (this.handler == null) {
                throw new NullPointerException("OrmHandler is null! Please set it using setHandler(OrmHandler handler) method");
            }
            this.holder.set(new UjoSessionFactoryThreadImpl(this.handler));
        }
        return this.holder.get();
    }

    private void removeThreadImpl() {
        this.holder.remove();
    }

    public void setHandler(OrmHandler handler) {
        this.handler = handler;
    }
}

