/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.spring;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.Key;
import org.ujorm.core.enums.OptionEnum;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.spring.UjormTransactionManager;

public abstract class AbstractDao<T extends OrmUjo> {
    private final UjormTransactionManager transactionManager;

    public AbstractDao(@Nonnull UjormTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Nonnull
    protected Session getSessionDao() {
        return this.transactionManager.getLocalSession();
    }

    @Nonnull
    protected final <U extends T> Query<U> createQueryDao(@Nonnull Criterion<U> criteron) {
        return this.getSessionDao().createQuery(criteron);
    }

    protected final <U extends T> void insertOrUpdateDao(@Nonnull U bo) {
        this.getSessionDao().insertOrUpdate(bo);
    }

    protected final <U extends T> void insertDao(@Nonnull U bo) {
        this.getSessionDao().insert(bo);
    }

    protected final <U extends T> void insertDao(@Nonnull List<U> bos) {
        this.getSessionDao().insert(bos);
    }

    protected final <U extends T> int updateDao(@Nonnull U bo) {
        return this.getSessionDao().update(bo);
    }

    protected final <U extends T> int updateSafelyDao(@Nonnull U bo, @Nullable U original, OptionEnum ... required) {
        return this.getSessionDao().updateSafely(bo, original, required);
    }

    protected <U extends OrmUjo> int updateSafelyDao(@Nonnull Consumer<U> batch, @Nonnull U bo, OptionEnum ... required) {
        return this.getSessionDao().updateSafely(batch, bo, required);
    }

    protected final <U extends T> int deleteDao(@Nonnull U bo) {
        return this.getSessionDao().delete(bo);
    }

    protected final <U extends T> int deleteDao(@Nonnull List<U> bos) {
        return this.getSessionDao().delete(bos);
    }

    protected final <U extends T> boolean existsDao(@Nonnull Criterion<U> criteron) {
        return this.getSessionDao().exists(criteron);
    }

    protected final <U extends T> boolean existsDao(@Nonnull Class<U> entity) {
        return this.getSessionDao().exists(entity);
    }

    protected final <U extends T> MetaColumn getColumnDao(@Nonnull Key<U, ?> compositeKey) {
        return (MetaColumn)this.getSessionDao().getHandler().findColumnModel(compositeKey);
    }
}

