/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.spring;

import javax.annotation.Nonnull;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmHandlerProvider;
import org.ujorm.orm.Session;
import org.ujorm.tools.Assert;

public class UjormTransactionManager
extends AbstractPlatformTransactionManager {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjormTransactionManager.class);
    private OrmHandler handler;
    private final ThreadLocal<Session> session = new ThreadLocal();
    @Nonnull
    private final Object dummy = new Object();

    public void setOrmHandlerProvider(@Nonnull OrmHandlerProvider ormHandlerProvider) {
        this.handler = ormHandlerProvider.getOrmHandler();
    }

    @Nonnull
    protected Object doGetTransaction() throws TransactionException {
        LOGGER.log(UjoLogger.TRACE, "GetTransaction is running");
        return this.dummy;
    }

    protected void doBegin(Object tr, TransactionDefinition td) throws TransactionException {
        LOGGER.log(UjoLogger.TRACE, "Auto transaction registred/started");
        Session localSession = this.session.get();
        if (localSession == null) {
            localSession = this.handler.createSession();
            this.session.set(localSession);
        }
        localSession.beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEnd(boolean commit, @Nonnull Session localSession) throws TransactionException {
        if (localSession.isClosed()) {
            String msg = "Transaction is closed, can't be " + (commit ? "commited" : "rollbacked");
            throw new TransactionException(msg){
                private static final long serialVersionUID = 1L;
            };
        }
        try {
            if (LOGGER.isLoggable(UjoLogger.TRACE)) {
                LOGGER.log(UjoLogger.TRACE, "Transaction is finished on the " + (commit ? "Commit" : "Rollback"));
            }
            if (commit) {
                localSession.commitTransaction();
            } else {
                try {
                    localSession.rollbackTransaction();
                }
                catch (Exception e) {
                    LOGGER.log(UjoLogger.ERROR, "Rollback failed", (Throwable)e);
                }
            }
        }
        finally {
            if (localSession.getTransaction() == null) {
                this.session.remove();
                localSession.close();
            }
        }
    }

    protected void doCommit(@Nonnull DefaultTransactionStatus dts) throws TransactionException {
        boolean rollbackOnly;
        Session localSession = this.getLocalSession();
        boolean bl = rollbackOnly = dts.isGlobalRollbackOnly() || localSession.isRollbackOnly();
        if (rollbackOnly) {
            LOGGER.log(UjoLogger.WARN, "Rolling back transaction becaouse has been mark as roll back only");
        }
        this.doEnd(!rollbackOnly, localSession);
    }

    protected void doRollback(DefaultTransactionStatus dts) throws TransactionException {
        this.doEnd(false, this.getLocalSession());
    }

    @Nonnull
    public Session getLocalSession() throws IllegalStateException {
        Session result = this.session.get();
        Assert.validState((result != null ? 1 : 0) != 0, (Object[])new String[]{"ORM session does not exists, check pointcut mapping"});
        return result;
    }
}

