/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.Ujo;
import org.ujorm.UjoDecorator;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.KeyRing;
import org.ujorm.extensions.NativeUjoDecorator;
import org.ujorm.implementation.orm.OrmTable;
import org.ujorm.implementation.orm.RelationToMany;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.annot.Db;
import org.ujorm.tools.Assert;

public class PackageDbConfig<U extends OrmUjo>
extends NativeUjoDecorator<U> {
    @Nonnull
    protected final KeyList<U> keyList;

    public <U extends OrmUjo> PackageDbConfig(@Nonnull Class<U> clazz3) throws IllegalArgumentException {
        super(clazz3);
        ArrayList<RelationToMany> arrayList = new ArrayList<RelationToMany>();
        List<Class> list = this.findTables();
        Collections.sort(list, (clazz, clazz2) -> clazz.getSimpleName().compareTo(clazz2.getSimpleName()));
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Class clazz4 = list.get(i);
            arrayList.add(new RelationToMany(clazz4.getSimpleName(), clazz3, clazz4, i, true));
        }
        Assert.hasLength(arrayList, (Object[])new String[]{"At least one table is needed"});
        this.keyList = KeyRing.of(clazz3, arrayList);
    }

    @Nonnull
    public KeyList<U> getKeys() {
        return this.keyList;
    }

    private Set<Package> getPackages() {
        KeyList keyList = ((OrmUjo)this.domain).readKeys();
        HashSet<Package> hashSet = new HashSet<Package>(1 + keyList.size());
        if (keyList.isEmpty()) {
            hashSet.add(((OrmUjo)this.domain).getClass().getPackage());
        } else {
            for (Key key : keyList) {
                if (!(key instanceof RelationToMany)) continue;
                hashSet.add(((RelationToMany)key).getItemType().getPackage());
            }
        }
        return hashSet;
    }

    @Nonnull
    private List<Class> findTables() {
        try {
            ArrayList<Class> arrayList = new ArrayList<Class>();
            for (Package package_ : this.getPackages()) {
                Resource[] resourceArray;
                String string = "/" + package_.getName().replace('.', '/');
                PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
                CachingMetadataReaderFactory cachingMetadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)pathMatchingResourcePatternResolver);
                String string2 = "classpath*:" + this.resolveBasePackage(string) + "/*.class";
                for (Resource resource : resourceArray = pathMatchingResourcePatternResolver.getResources(string2)) {
                    MetadataReader metadataReader;
                    Class<?> clazz;
                    if (!resource.isReadable() || !this.isCandidate(clazz = Class.forName((metadataReader = cachingMetadataReaderFactory.getMetadataReader(resource)).getClassMetadata().getClassName()))) continue;
                    arrayList.add(clazz);
                }
            }
            return arrayList;
        }
        catch (IOException | ReflectiveOperationException | RuntimeException exception) {
            throw new IllegalUjormException((Throwable)exception);
        }
    }

    private String resolveBasePackage(@Nonnull String string) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)string));
    }

    protected boolean isCandidate(@Nonnull Class<?> clazz) throws ReflectiveOperationException {
        if (!OrmTable.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.getAnnotation(Db.class) != null) {
            return false;
        }
        return !((OrmUjo)this.domain).getClass().equals(clazz);
    }

    public static <U extends Ujo> UjoDecorator<U> of(@Nonnull Class<U> clazz) {
        return new PackageDbConfig<U>(clazz);
    }
}

