/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.orm.support;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.aspectj.lang.ProceedingJoinPoint;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.Session;
import org.ujorm.orm.support.UjoSessionFactory;
import org.ujorm.orm.support.UjoSessionFactoryAOP;
import org.ujorm.orm.support.UjoSessionFactoryFilter;

public class UjoSessionFactoryThreadImpl
implements UjoSessionFactory,
UjoSessionFactoryAOP,
UjoSessionFactoryFilter {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjoSessionFactoryThreadImpl.class);
    private final OrmHandler handler;
    private AtomicInteger deep;
    private Session session;
    private boolean autoTransactionHolder = false;

    public UjoSessionFactoryThreadImpl(OrmHandler ormHandler) {
        this.handler = ormHandler;
    }

    @Override
    public Object aroundSession(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            this.doIncCalling();
            Object object = this.doCall(proceedingJoinPoint);
            return object;
        }
        finally {
            this.doDecCalling();
        }
    }

    private void doIncCalling() {
        if (this.incCalling()) {
            this.session = this.handler.createSession();
            LOGGER.log(UjoLogger.TRACE, "opening Ujorm session");
        }
    }

    private void doDecCalling() {
        if (this.decCalling()) {
            LOGGER.log(UjoLogger.TRACE, "closing Ujorm session");
            this.getSession().close();
        }
    }

    private Object doCall(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        if (proceedingJoinPoint.getArgs() != null) {
            return proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());
        }
        return proceedingJoinPoint.proceed();
    }

    private boolean incCalling() {
        if (this.deep == null) {
            this.deep = new AtomicInteger(1);
            return true;
        }
        this.deep.incrementAndGet();
        return false;
    }

    private boolean decCalling() {
        if (this.deep.decrementAndGet() == 0) {
            this.deep = null;
            return true;
        }
        return false;
    }

    @Nonnull
    private Session getSession() throws IllegalUjormException {
        if (this.session == null) {
            throw new IllegalUjormException("ORM session doesnt exist, check pointcut mapping");
        }
        return this.session;
    }

    @Override
    public Session getDefaultSession() {
        if (!this.getAutoTransaction()) {
            LOGGER.log(UjoLogger.WARN, "geting session without autotransaction handling !!");
        }
        return this.getSession();
    }

    @Override
    public void setAutoTransaction(boolean bl) {
        this.autoTransactionHolder = bl;
    }

    public boolean getAutoTransaction() {
        return this.autoTransactionHolder;
    }

    @Override
    public void openSession() {
        this.doIncCalling();
    }

    @Override
    public void closeSession() {
        this.doDecCalling();
    }

    boolean isSessionClosed() {
        if (this.session == null) {
            return true;
        }
        return this.session.isClosed();
    }
}

