/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.spring;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.Key;
import org.ujorm.core.enums.OptionEnum;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.spring.UjormTransactionManager;

public abstract class AbstractDao<T extends OrmUjo> {
    private final UjormTransactionManager transactionManager;

    public AbstractDao(@Nonnull UjormTransactionManager ujormTransactionManager) {
        this.transactionManager = ujormTransactionManager;
    }

    @Nonnull
    protected Session getSessionDao() {
        return this.transactionManager.getLocalSession();
    }

    @Nonnull
    protected final <U extends T> Query<U> createQueryDao(@Nonnull Criterion<U> criterion) {
        return this.getSessionDao().createQuery(criterion);
    }

    protected final <U extends T> void insertOrUpdateDao(@Nonnull U u) {
        this.getSessionDao().insertOrUpdate(u);
    }

    protected final <U extends T> void insertDao(@Nonnull U u) {
        this.getSessionDao().insert(u);
    }

    protected final <U extends T> void insertDao(@Nonnull List<U> list) {
        this.getSessionDao().insert(list);
    }

    protected final <U extends T> int updateDao(@Nonnull U u) {
        return this.getSessionDao().update(u);
    }

    protected final <U extends T> int updateSafelyDao(@Nonnull U u, @Nullable U u2, OptionEnum ... optionEnumArray) {
        return this.getSessionDao().updateSafely(u, u2, optionEnumArray);
    }

    protected <U extends OrmUjo> int updateSafelyDao(@Nonnull Consumer<U> consumer, @Nonnull U u, OptionEnum ... optionEnumArray) {
        return this.getSessionDao().updateSafely(consumer, u, optionEnumArray);
    }

    protected final <U extends T> int deleteDao(@Nonnull U u) {
        return this.getSessionDao().delete(u);
    }

    protected final <U extends T> int deleteDao(@Nonnull List<U> list) {
        return this.getSessionDao().delete(list);
    }

    protected final <U extends T> boolean existsDao(@Nonnull Criterion<U> criterion) {
        return this.getSessionDao().exists(criterion);
    }

    protected final <U extends T> boolean existsDao(@Nonnull Class<U> clazz) {
        return this.getSessionDao().exists(clazz);
    }

    protected final <U extends T> MetaColumn getColumnDao(@Nonnull Key<U, ?> key) {
        return (MetaColumn)this.getSessionDao().getHandler().findColumnModel(key);
    }
}

