/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.spring;

import javax.annotation.Nonnull;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.ujorm.logger.UjoLogger;
import org.ujorm.logger.UjoLoggerFactory;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmHandlerProvider;
import org.ujorm.orm.Session;
import org.ujorm.tools.Assert;

public class UjormTransactionManager
extends AbstractPlatformTransactionManager {
    private static final UjoLogger LOGGER = UjoLoggerFactory.getLogger(UjormTransactionManager.class);
    private OrmHandler handler;
    private final ThreadLocal<Session> session = new ThreadLocal();
    @Nonnull
    private final Object dummy = new Object();

    public void setOrmHandlerProvider(@Nonnull OrmHandlerProvider ormHandlerProvider) {
        this.handler = ormHandlerProvider.getOrmHandler();
    }

    @Nonnull
    protected Object doGetTransaction() throws TransactionException {
        LOGGER.log(UjoLogger.TRACE, "GetTransaction is running");
        return this.dummy;
    }

    protected void doBegin(Object object, TransactionDefinition transactionDefinition) throws TransactionException {
        LOGGER.log(UjoLogger.TRACE, "Auto transaction registred/started");
        Session session = this.session.get();
        if (session == null) {
            session = this.handler.createSession();
            this.session.set(session);
        }
        session.beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEnd(boolean bl, @Nonnull Session session) throws TransactionException {
        if (session.isClosed()) {
            String string = "Transaction is closed, can't be " + (bl ? "commited" : "rollbacked");
            throw new TransactionException(string){
                private static final long serialVersionUID = 1L;
            };
        }
        try {
            if (LOGGER.isLoggable(UjoLogger.TRACE)) {
                LOGGER.log(UjoLogger.TRACE, "Transaction is finished on the " + (bl ? "Commit" : "Rollback"));
            }
            if (bl) {
                session.commitTransaction();
            } else {
                try {
                    session.rollbackTransaction();
                }
                catch (Exception exception) {
                    LOGGER.log(UjoLogger.ERROR, "Rollback failed", (Throwable)exception);
                }
            }
        }
        finally {
            if (session.getTransaction() == null) {
                this.session.remove();
                session.close();
            }
        }
    }

    protected void doCommit(@Nonnull DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        boolean bl;
        Session session = this.getLocalSession();
        boolean bl2 = bl = defaultTransactionStatus.isGlobalRollbackOnly() || session.isRollbackOnly();
        if (bl) {
            LOGGER.log(UjoLogger.WARN, "Rolling back transaction becaouse has been mark as roll back only");
        }
        this.doEnd(!bl, session);
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        this.doEnd(false, this.getLocalSession());
    }

    @Nonnull
    public Session getLocalSession() throws IllegalStateException {
        Session session = this.session.get();
        Assert.state((session != null ? 1 : 0) != 0, (Object[])new String[]{"ORM session does not exists, check pointcut mapping"});
        return session;
    }
}

