/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;

public final class MessageArg<T>
implements Serializable {
    @Nonnull
    private final String name;
    @Nullable
    private final String format;

    public MessageArg(@Nonnull String name) {
        this(name, null);
    }

    public MessageArg(@Nonnull String name, @Nullable String format) {
        Assert.notNull(name, "Name is required", name);
        Assert.isTrue(name.indexOf(125) < 0, "Forbidden character {} in argument {}", Character.valueOf('}'), name);
        Assert.isTrue(format == null || format.indexOf(125) < 0, "Forbidden character {} in argument {}", Character.valueOf('}'), format);
        this.name = name;
        this.format = format;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(32);
        result.append("${").append(this.name);
        if (Check.hasLength(this.format)) {
            result.append(',').append(this.format);
        }
        result.append('}');
        return result.toString();
    }

    public T getValue(Map<String, Object> map) {
        return (T)map.get(this.name);
    }
}

