/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.set;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.set.MapKeyProxy;

public class CustomMap<K, V>
implements Map<K, V>,
Serializable {
    @Nonnull
    private final HashMap<MapKeyProxy<K>, V> impl;
    @Nonnull
    private final Function<K, MapKeyProxy<K>> keyFactory;

    public CustomMap() {
        this(key -> new DefaultMapKey<Object>(key));
    }

    public CustomMap(@Nonnull Function<K, MapKeyProxy<K>> keyFactory) {
        this(new HashMap(), keyFactory);
    }

    public CustomMap(@Nonnull HashMap<MapKeyProxy<K>, V> impl, @Nonnull Function<K, MapKeyProxy<K>> keyFactory) {
        this.impl = impl;
        this.keyFactory = keyFactory;
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.impl.containsKey(this.keyFactory.apply(key));
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.impl.containsValue(value);
    }

    @Override
    public V get(@Nonnull Object key) {
        return this.impl.get(this.keyFactory.apply(key));
    }

    @Override
    public V put(@Nullable K key, @Nullable V value) {
        return this.impl.put(this.keyFactory.apply(key), value);
    }

    @Override
    public V remove(@Nullable Object key) {
        return this.impl.remove(this.keyFactory.apply(key));
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        for (K k : m.keySet()) {
            this.impl.put(this.keyFactory.apply(k), m.get(k));
        }
    }

    @Override
    public void clear() {
        this.impl.clear();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> result = new HashSet<K>(this.impl.size());
        for (MapKeyProxy<K> mapKey : this.impl.keySet()) {
            result.add(mapKey.getOriginal());
        }
        return result;
    }

    public Set<MapKeyProxy<K>> keySetProxy() {
        return this.impl.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.impl.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    protected static class DefaultMapKey<K>
    implements MapKeyProxy<K> {
        @Nullable
        protected final K originalKey;

        public DefaultMapKey(@Nullable K originalKey) {
            this.originalKey = originalKey;
        }

        @Override
        public int hashCode() {
            return this.originalKey != null ? this.originalKey.hashCode() : 0;
        }

        @Override
        public boolean equals(@Nullable Object proxyValue) {
            return proxyValue instanceof MapKeyProxy && Objects.equals(this.originalKey, ((MapKeyProxy)proxyValue).getOriginal());
        }

        @Override
        public K getOriginal() {
            return this.originalKey;
        }

        public String toString() {
            return String.valueOf(this.originalKey);
        }
    }
}

