/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.dom;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.AbstractElement;
import org.ujorm.tools.xml.dom.XmlWriter;

public class XmlElement
extends AbstractElement<XmlElement>
implements Serializable {
    @Nullable
    protected Map<String, Object> attributes;
    @Nullable
    protected List<Object> children;

    public XmlElement(@Nonnull CharSequence name) {
        super(name);
    }

    public XmlElement(@Nonnull CharSequence name, @Nonnull XmlElement parent) {
        this(name);
        parent.addChild(this);
    }

    @Nonnull
    protected Map<String, Object> getAttribs() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        return this.attributes;
    }

    @Nonnull
    protected void addChild(@Nullable Object child) {
        if (this.children == null) {
            this.children = new ArrayList<Object>();
        }
        this.children.add(child);
    }

    @Nonnull
    public final <T extends XmlElement> T addElement(@Nonnull T element) {
        this.addChild(Assert.notNull(element, "The argument {} is required", "element"));
        return element;
    }

    @Override
    @Nonnull
    public <T extends XmlElement> T addElement(@Nonnull String name) {
        return (T)new XmlElement(name, this);
    }

    @Nonnull
    @Deprecated
    public final <T extends XmlElement> T addAttrib(@Nonnull String name, @Nullable Object value) {
        return (T)this.setAttrib(name, value);
    }

    @Override
    @Nonnull
    public final <T extends XmlElement> T setAttrib(@Nonnull String name, @Nullable Object value) {
        Assert.hasLength(name, "The argument {} is required", "name");
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(name, value);
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends XmlElement> T addText(@Nullable Object value) {
        this.addChild(value);
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends XmlElement> T addRawText(@Nullable Object value) {
        if (value != null) {
            this.addChild(new RawEnvelope(value));
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends XmlElement> T addComment(@Nullable CharSequence comment) {
        if (Check.hasLength(comment)) {
            Assert.isTrue(!comment.toString().contains("-->"), "The text contains a forbidden string: -->");
            StringBuilder msg = new StringBuilder("<!--".length() + "-->".length() + comment.length() + 2);
            this.addRawText(msg.append("<!--").append(' ').append(comment).append(' ').append("-->"));
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends XmlElement> T addCDATA(@Nullable CharSequence charData) {
        if (Check.hasLength(charData)) {
            int j;
            this.addRawText("<![CDATA[");
            String text = charData.toString();
            int i = 0;
            while ((j = text.indexOf("]]>", i)) >= 0) {
                this.addRawText(text.subSequence(i, j += "]]>".length()));
                i = j;
                this.addText("]]>");
                this.addRawText("<![CDATA[");
            }
            this.addRawText(i == 0 ? text : text.substring(i));
            this.addRawText("]]>");
        }
        return (T)this;
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes != null ? Collections.unmodifiableMap(this.attributes) : Collections.emptyMap();
    }

    @Nonnull
    public List<Object> getChildren() {
        return this.children != null ? Collections.unmodifiableList(this.children) : Collections.emptyList();
    }

    @Override
    public final void close() throws IOException {
    }

    @Nonnull
    public String toString() {
        try {
            return this.toWriter(0, new XmlWriter(new CharArrayWriter(512).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n'))).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public XmlWriter toWriter(int level, @Nonnull XmlWriter out) throws IOException {
        return out.write(level, this);
    }

    protected static final class RawEnvelope {
        @Nonnull
        private final Object body;

        public RawEnvelope(@Nonnull Object body) {
            this.body = body;
        }

        @Nonnull
        public Object get() {
            return this.body;
        }
    }
}

