/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectUtils {
    private ObjectUtils() {
    }

    public static final <V, R> Optional<R> iof(@Nullable Object value, @NotNull Class<V> requiredClass, @NotNull Function<V, R> function) {
        return requiredClass.isInstance(value) ? Optional.ofNullable(function.apply(value)) : Optional.empty();
    }

    public static final <V> boolean check(@Nullable Object value, @NotNull Class<V> requiredClass, @NotNull Function<V, Boolean> function) {
        return value != null && value.getClass() == requiredClass && function.apply(value) != false;
    }

    @NotNull
    public static PrintWriter toPrintWriter(final @NotNull Appendable appendable) {
        Writer myWriter = new Writer(){

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                int max = off + len;
                for (int i = 0; i < max; ++i) {
                    appendable.append(cbuf[i]);
                }
            }
        };
        return new PrintWriter(myWriter, false);
    }
}

