/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.common.ObjectUtils;
import org.ujorm.tools.msg.MessageArg;

@Unmodifiable
public class MessageService {
    protected final String begTag;
    protected final char endTag;
    @NotNull
    protected final Locale defaultLocale;

    public MessageService() {
        this("${", '}', Locale.ENGLISH);
    }

    public MessageService(@NotNull String begTag, @NotNull char endTag, @NotNull Locale defaultLocale) {
        this.begTag = Assert.hasLength(begTag, "begTag");
        this.endTag = endTag;
        this.defaultLocale = Assert.notNull(defaultLocale, "defaultLocale");
    }

    public <T> Map<String, Object> map(T ... args) {
        int max = args.length;
        HashMap<String, Object> result = new HashMap<String, Object>(max >> 1);
        for (int i = 1; i < max; i += 2) {
            result.put(this.convertKey(args[i - 1]), args[i]);
        }
        return result;
    }

    public <T> String template(T ... args) {
        StringBuilder result = new StringBuilder(256);
        for (T arg : args) {
            result.append(arg);
        }
        return result.toString();
    }

    public final String format(@Nullable String msg, @Nullable Map<String, Object> args) {
        return this.format(msg, args, null);
    }

    public final String format(@Nullable String msg, @Nullable Locale locale, @NotNull CharSequence key, @Nullable Object value, Object ... keyValuePairs) {
        Map<String, Object> map = this.map(keyValuePairs);
        map.put(this.convertKey(key), value);
        return this.format(msg, map, locale);
    }

    public final String format(@Nullable String msg, @Nullable Map<String, Object> args, @Nullable Locale locale) {
        try {
            return this.format(null, msg, args, locale);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final String format(@Nullable Appendable writer, @Nullable String msg, @Nullable Map<String, Object> args, @Nullable Locale locale) throws IOException {
        int i;
        if (msg == null || args == null) {
            return String.valueOf(msg);
        }
        int max = msg.length();
        Appendable result = writer != null ? writer : new StringBuilder(Math.max(32, max + (max >> 1)));
        int last = 0;
        while ((i = msg.indexOf(this.begTag, last)) >= 0) {
            Object val;
            String expr;
            int end = msg.indexOf(this.endTag, i);
            int formatIndex = (expr = msg.substring(i + this.begTag.length(), end)).indexOf(44);
            String key = expr.substring(0, formatIndex >= 0 ? formatIndex : expr.length());
            Object value = args.get(key);
            Object object = val = value instanceof Supplier ? ((Supplier)value).get() : value;
            if (val != null) {
                result.append(msg, last, i);
                if (formatIndex > 0) {
                    new Formatter(result, locale != null ? locale : this.defaultLocale).format(expr.substring(1 + formatIndex), val, val, val, val, val, val);
                } else {
                    this.writeValue(val, result, locale);
                }
            } else {
                result.append(msg, last, end + 1);
            }
            last = end + 1;
        }
        result.append(msg, last, max);
        return writer != null ? "" : result.toString();
    }

    @Nullable
    protected String convertKey(@NotNull Object key) {
        return key instanceof MessageArg ? ((MessageArg)key).getName() : key.toString();
    }

    protected void writeValue(@NotNull Object value, @NotNull Appendable writer, @Nullable Locale locale) throws IOException {
        if (value instanceof Throwable) {
            ((Throwable)value).printStackTrace(ObjectUtils.toPrintWriter(writer));
        } else {
            writer.append(value.toString());
        }
    }

    public static final String formatMsg(@Nullable String template, @Nullable Map<String, Object> args) {
        return new MessageService().format(template, args);
    }

    public static final String formatMsg(@Nullable String template, @NotNull CharSequence key, @Nullable Object value, Object ... keyValuePairs) {
        return new MessageService().format(template, null, key, value, keyValuePairs);
    }
}

