/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.config.Formatter;
import org.ujorm.tools.xml.config.XmlConfig;

public class DefaultXmlConfig
implements XmlConfig {
    public static final String DEFAULT_INTENDATION = "    ";
    public static final String DEFAULT_NEW_LINE = "\n";
    public static final int DEFAULT_FIRST_LEVEL = -2147483647;
    public static final String REQUIRED_MSG = "The argument {} is required";
    public static final String EMPTY = "";
    @Nullable
    protected CharSequence doctype;
    @NotNull
    private Charset charset = StandardCharsets.UTF_8;
    private int firstLevel = -2147483647;
    @NotNull
    private CharSequence indentation = "";
    @NotNull
    private CharSequence defaultValue = "";
    @NotNull
    private CharSequence newLine = "\n";
    private boolean cacheAllowed;
    @NotNull
    private Formatter formatter = (value, element, attribute) -> value != null ? value.toString() : EMPTY;

    public DefaultXmlConfig() {
    }

    public DefaultXmlConfig(@NotNull XmlConfig config) {
        this.doctype = config.getDoctype();
        this.charset = config.getCharset();
        this.firstLevel = config.getFirstLevel();
        this.indentation = config.getIndentation();
        this.defaultValue = config.getDefaultValue();
        this.newLine = config.getNewLine();
        this.cacheAllowed = config.isCacheAllowed();
        this.formatter = config.getFormatter();
    }

    @Override
    @NotNull
    public CharSequence getDoctype() {
        return this.nonnull(this.doctype, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    @NotNull
    protected final <T> T nonnull(@Nullable T value, @NotNull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public DefaultXmlConfig setDoctype(@Nullable CharSequence doctype) {
        this.doctype = doctype;
        return this;
    }

    @Override
    @NotNull
    public Charset getCharset() {
        return this.charset;
    }

    public DefaultXmlConfig setCharset(@NotNull Charset charset) {
        this.charset = Assert.notNull(charset, REQUIRED_MSG, "charset");
        return this;
    }

    public final <T extends DefaultXmlConfig> T setNiceFormat() {
        this.setNiceFormat(DEFAULT_INTENDATION);
        return (T)this;
    }

    public final <T extends DefaultXmlConfig> T setNiceFormat(@Nullable CharSequence indentation) {
        this.firstLevel = 0;
        this.indentation = Check.hasLength(indentation) ? indentation : DEFAULT_INTENDATION;
        this.newLine = DEFAULT_NEW_LINE;
        return (T)this;
    }

    public final DefaultXmlConfig setCompressedFormat() {
        this.firstLevel = -2147483647;
        this.indentation = EMPTY;
        this.newLine = EMPTY;
        return this;
    }

    @Override
    public int getFirstLevel() {
        return this.firstLevel;
    }

    public DefaultXmlConfig setFirstLevel(int firstLevel) {
        this.firstLevel = firstLevel;
        return this;
    }

    @Override
    @NotNull
    public CharSequence getIndentation() {
        return this.nonnull(this.indentation, EMPTY);
    }

    public DefaultXmlConfig setIndentationSpace(@NotNull CharSequence indentation) {
        this.indentation = Assert.notNull(indentation, REQUIRED_MSG, "indentation");
        return this;
    }

    @Override
    public CharSequence getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @NotNull
    public Formatter getFormatter() {
        return this.formatter;
    }

    public DefaultXmlConfig setDefaultValue(@NotNull String defaultValue) {
        this.defaultValue = Assert.notNull(defaultValue, "defaultValue");
        return this;
    }

    @Override
    public boolean isCacheAllowed() {
        return this.cacheAllowed;
    }

    public DefaultXmlConfig setCacheAllowed(boolean cacheAllowed) {
        this.cacheAllowed = cacheAllowed;
        return this;
    }

    @Override
    public CharSequence getNewLine() {
        return this.newLine;
    }

    public DefaultXmlConfig setNewLine(@NotNull CharSequence newLine) {
        this.newLine = Assert.notNull(newLine, "newLine");
        return this;
    }

    public DefaultXmlConfig setFormatter(@NotNull Formatter formatter) {
        this.formatter = Assert.notNull(formatter, "formatter");
        return this;
    }
}

