/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.xsd;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujorm.Key;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.core.IllegalUjormException;
import org.ujorm.core.UjoManager;
import org.ujorm.core.UjoManagerXML;
import org.ujorm.core.XmlHeader;
import org.ujorm.extensions.StringWrapper;
import org.ujorm.extensions.UjoTextable;
import org.ujorm.xsd.domains.ComplexType;
import org.ujorm.xsd.domains.Element;
import org.ujorm.xsd.domains.RootSchema;
import org.ujorm.xsd.domains.SimpleType;

public class XsdBuilder {
    private static final String XSD = "xs:";
    private static final UjoManager manager = UjoManager.getInstance();
    private final Class<? extends Ujo> rootClass;
    private final RootSchema rootSchema = new RootSchema();
    private final Map<Class, String> typeMap = new HashMap<Class, String>();
    private final List<Class> typeList = new ArrayList<Class>();
    private final List<Class> enumList = new ArrayList<Class>();

    public XsdBuilder(Class<? extends Ujo> ujoClass) {
        this.rootClass = ujoClass;
        this.loadBaseTypes();
        this.loadUjoType(this.rootClass);
        this.buildMetaModel();
    }

    private void loadBaseTypes() {
        this.typeMap.put(String.class, (String)Element.TYPE.getDefault());
        this.typeMap.put(Integer.class, "xs:int");
        this.typeMap.put(BigInteger.class, "xs:integer");
        this.typeMap.put(Long.class, "xs:long");
        this.typeMap.put(Short.class, "xs:short");
        this.typeMap.put(BigDecimal.class, "xs:decimal");
        this.typeMap.put(Float.class, "xs:float");
        this.typeMap.put(Double.class, "xs:double");
        this.typeMap.put(Boolean.class, "xs:boolean");
        this.typeMap.put(Byte.class, "xs:byte");
        this.typeMap.put(java.util.Date.class, "xs:dateTime");
        this.typeMap.put(Date.class, "xs:date");
    }

    private void loadUjoType(Class<?> ujoClass) {
        this.typeMap.put(ujoClass, ujoClass.getSimpleName());
        this.typeList.add(ujoClass);
        for (Key key : this.createUjo(ujoClass).readKeys()) {
            this.assignKeyType(key);
        }
    }

    private void assignKeyType(Key<?, ?> key) {
        Class keyType;
        if (manager.isTransient(key)) {
            return;
        }
        Class clazz = keyType = key instanceof ListKey ? ((ListKey)key).getItemType() : key.getType();
        if (!this.typeMap.containsKey(keyType)) {
            if (Ujo.class.isAssignableFrom(keyType)) {
                this.loadUjoType(keyType);
            } else if (keyType.isEnum()) {
                this.typeMap.put(keyType, keyType.getSimpleName());
                this.enumList.add(keyType);
            } else {
                this.typeMap.put(keyType, (String)Element.TYPE.getDefault());
            }
        }
    }

    private void buildMetaModel() {
        Collections.reverse(this.enumList);
        Collections.reverse(this.typeList);
        for (Class type : this.enumList) {
            SimpleType simpleType = new SimpleType();
            RootSchema.SIMPLE_STYPE.addItem((Ujo)this.rootSchema, (Object)simpleType);
            simpleType.setName(this.typeMap.get(type));
            for (Object enumItem : type.getEnumConstants()) {
                String enumValue = enumItem instanceof StringWrapper ? ((StringWrapper)enumItem).exportToString() : ((Enum)enumItem).name();
                simpleType.addEnumerationValue(enumValue);
            }
        }
        for (Class type : this.typeList) {
            ComplexType complexType = new ComplexType();
            RootSchema.COMPLEX_TYPE.addItem((Ujo)this.rootSchema, (Object)complexType);
            complexType.setName(this.typeMap.get(type));
            for (Key key : this.createUjo(type).readKeys()) {
                Class keyType;
                if (manager.isTransient(key)) continue;
                boolean list = key instanceof ListKey;
                Class clazz = keyType = list ? ((ListKey)key).getItemType() : key.getType();
                if (manager.isXmlAttribute(key)) {
                    complexType.addAttribute(key.getName(), this.typeMap.get(keyType));
                    continue;
                }
                complexType.addElement(key.getName(), this.typeMap.get(keyType), list);
            }
        }
        Element mainElement = new Element();
        mainElement.set("body", this.typeMap.get(this.rootClass));
        mainElement.hideMinOccurs(true);
        RootSchema.ELEMENT.setValue((Ujo)this.rootSchema, (Object)mainElement);
    }

    public String print() {
        CharArrayWriter writer = new CharArrayWriter(256);
        try {
            String xmlHeader = null;
            this.print(xmlHeader, writer);
        }
        catch (IOException ex) {
            String msg = "Can't export model into XML";
            throw new IllegalUjormException(msg, (Throwable)ex);
        }
        return writer.toString();
    }

    public void print(String xmlHeader, Writer writer) throws IOException {
        XmlHeader header = new XmlHeader("xs:schema");
        header.setHeader(xmlHeader);
        UjoManagerXML.getInstance().saveXML(writer, header, (UjoTextable)this.rootSchema, (Object)this.rootSchema);
    }

    private Ujo createUjo(Class<?> ujoClass) {
        try {
            return (Ujo)ujoClass.newInstance();
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new IllegalUjormException("Can't create instance for " + ujoClass, (Throwable)e);
        }
    }
}

