/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.javageneration.util;

import org.eclipse.uml2.uml.DataType;
import org.umlg.java.metamodel.OJPathName;

public enum DataTypeEnum {
    DateTime("org.joda.time.DateTime", "DataTypeEnum.DateTime"),
    Date("org.joda.time.LocalDate", "DataTypeEnum.Date"),
    Time("org.joda.time.LocalTime", "DataTypeEnum.Time"),
    InternationalPhoneNumber("java.lang.String", "DataTypeEnum.InternationalPhoneNumber"),
    LocalPhoneNumber("java.lang.String", "DataTypeEnum.LocalPhoneNumber"),
    Email("java.lang.String", "DataTypeEnum.Email"),
    Video("byte[]", "DataTypeEnum.Video"),
    Audio("byte[]", "DataTypeEnum.Audio"),
    Image("byte[]", "DataTypeEnum.Image"),
    Host("java.lang.String", "DataTypeEnum.Host"),
    QuartzCron("java.lang.String", "DataTypeEnum.QuartzCron"),
    UnixCron("java.lang.String", "DataTypeEnum.UnixCron"),
    Password("org.umlg.runtime.types.Password", "DataTypeEnum.Password"),
    UnsecurePassword("java.lang.String", "DataTypeEnum.UnsecurePassword"),
    ByteArray("byte[]", "DataTypeEnum.ByteArray");

    private OJPathName pathName;
    private String initExpression;

    private DataTypeEnum(String s, String initExpression) {
        this.pathName = new OJPathName(s);
        this.initExpression = initExpression;
    }

    public String getInitExpression() {
        return this.initExpression;
    }

    public static OJPathName getPathNameFromDataType(DataType dataType) {
        return DataTypeEnum.fromDataType(dataType).getPathName();
    }

    public static DataTypeEnum fromDataType(DataType dataType) {
        if (dataType.getName().equals(DateTime.name())) {
            return DateTime;
        }
        if (dataType.getName().equals(Date.name())) {
            return Date;
        }
        if (dataType.getName().equals(Time.name())) {
            return Time;
        }
        if (dataType.getName().equals(InternationalPhoneNumber.name())) {
            return InternationalPhoneNumber;
        }
        if (dataType.getName().equals(LocalPhoneNumber.name())) {
            return LocalPhoneNumber;
        }
        if (dataType.getName().equals(Email.name())) {
            return Email;
        }
        if (dataType.getName().equals(Video.name())) {
            return Video;
        }
        if (dataType.getName().equals(Audio.name())) {
            return Audio;
        }
        if (dataType.getName().equals(Image.name())) {
            return Image;
        }
        if (dataType.getName().equals(Host.name())) {
            return Host;
        }
        if (dataType.getName().equals(QuartzCron.name())) {
            return QuartzCron;
        }
        if (dataType.getName().equals(UnixCron.name())) {
            return UnixCron;
        }
        if (dataType.getName().equals(Password.name())) {
            return Password;
        }
        if (dataType.getName().equals(UnsecurePassword.name())) {
            return UnsecurePassword;
        }
        if (dataType.getName().equals(ByteArray.name())) {
            return ByteArray;
        }
        return null;
    }

    public OJPathName getPathName() {
        return this.pathName;
    }

    public boolean isDateTime() {
        return this == DateTime;
    }

    public boolean isDate() {
        return this == Date;
    }

    public boolean isTime() {
        return this == Time;
    }

    public boolean isInternationalPhoneNumber() {
        return this == InternationalPhoneNumber;
    }

    public boolean isLocalPhoneNumber() {
        return this == LocalPhoneNumber;
    }

    public boolean isEmail() {
        return this == Email;
    }

    public boolean isVideo() {
        return this == Video;
    }

    public boolean isAudio() {
        return this == Audio;
    }

    public boolean isImage() {
        return this == Image;
    }

    public boolean isHost() {
        return this == Host;
    }

    public boolean isQuartzCron() {
        return this == QuartzCron;
    }

    public boolean isUnixCron() {
        return this == UnixCron;
    }

    public boolean isPassword() {
        return this == Password;
    }

    public boolean isUnsecurePassword() {
        return this == UnsecurePassword;
    }

    public boolean isByteArray() {
        return this == ByteArray;
    }
}

