/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.javageneration.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.umlg.framework.ModelLoader;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.javageneration.util.DataTypeEnum;
import org.umlg.javageneration.util.MultiplicityWrapper;
import org.umlg.javageneration.util.Namer;
import org.umlg.javageneration.util.UmlgClassOperations;
import org.umlg.javageneration.util.UmlgCollectionKindEnum;
import org.umlg.javageneration.util.UmlgDataTypeOperation;
import org.umlg.javageneration.util.UmlgGenerationUtil;
import org.umlg.javageneration.util.UmlgPropertyOperations;
import org.umlg.javageneration.util.UmlgValidationEnum;
import org.umlg.javageneration.validation.Email;
import org.umlg.javageneration.validation.Host;
import org.umlg.javageneration.validation.MaxDouble;
import org.umlg.javageneration.validation.MaxFloat;
import org.umlg.javageneration.validation.MaxInteger;
import org.umlg.javageneration.validation.MaxLength;
import org.umlg.javageneration.validation.MaxLong;
import org.umlg.javageneration.validation.MaxReal;
import org.umlg.javageneration.validation.MaxUnlimitedNatural;
import org.umlg.javageneration.validation.MinDouble;
import org.umlg.javageneration.validation.MinFloat;
import org.umlg.javageneration.validation.MinInteger;
import org.umlg.javageneration.validation.MinLength;
import org.umlg.javageneration.validation.MinLong;
import org.umlg.javageneration.validation.MinReal;
import org.umlg.javageneration.validation.MinUnlimitedNatural;
import org.umlg.javageneration.validation.PasswordValidation;
import org.umlg.javageneration.validation.QuartzCron;
import org.umlg.javageneration.validation.RangeDouble;
import org.umlg.javageneration.validation.RangeFloat;
import org.umlg.javageneration.validation.RangeInteger;
import org.umlg.javageneration.validation.RangeLength;
import org.umlg.javageneration.validation.RangeLong;
import org.umlg.javageneration.validation.RangeReal;
import org.umlg.javageneration.validation.RangeUnlimitedNatural;
import org.umlg.javageneration.validation.UnixCron;
import org.umlg.javageneration.validation.Validation;

public class PropertyWrapper
extends MultiplicityWrapper
implements Property {
    private Property property;
    private boolean recursive;
    private boolean indexed;
    private boolean refined;

    public static PropertyWrapper from(Property sourceProperty) {
        return new PropertyWrapper(sourceProperty);
    }

    public PropertyWrapper(Property property) {
        super((MultiplicityElement)property);
        this.property = property;
    }

    public boolean isInverseUnique() {
        if (this.getOtherEnd() != null) {
            return new PropertyWrapper(this.getOtherEnd()).isUnique();
        }
        return false;
    }

    public boolean isDataType() {
        return this.getType() instanceof DataType;
    }

    public boolean needsLookup() {
        return !this.isComposite() && !(this.getType() instanceof Enumeration) && !this.isDerived() && !this.isQualifier() && this.getOtherEnd() != null && !(this.getOtherEnd().getType() instanceof Enumeration) && !this.getOtherEnd().isComposite() && !this.isRefined();
    }

    public boolean hasLookup() {
        return !this.isComposite() && !(this.getType() instanceof Enumeration) && !this.isDerived() && !this.isQualifier() && this.getOtherEnd() != null && !(this.getOtherEnd().getType() instanceof Enumeration) && !this.getOtherEnd().isComposite();
    }

    public boolean isInverseComposite() {
        if (this.getOtherEnd() != null) {
            return new PropertyWrapper(this.getOtherEnd()).isComposite();
        }
        return false;
    }

    public boolean hasQualifiers() {
        return !this.property.getQualifiers().isEmpty();
    }

    public boolean isQualified() {
        return this.hasQualifiers();
    }

    public boolean isInverseQualified() {
        if (this.getOtherEnd() != null) {
            return new PropertyWrapper(this.getOtherEnd()).isQualified();
        }
        return false;
    }

    public boolean isQualifier() {
        Element owner = this.property.getOwner();
        return owner instanceof Property && ((Property)owner).getQualifiers().contains((Object)this.property);
    }

    public boolean hasOtherEnd() {
        return this.getOtherEnd() != null;
    }

    public String getOclValue() {
        if (!this.property.isDerived()) {
            throw new IllegalStateException("getOclValue can only be called on a derived property");
        }
        return this.property.getDefaultValue().stringValue();
    }

    public boolean hasOclDefaultValue() {
        ValueSpecification v = this.getDefaultValue();
        if (v instanceof OpaqueExpression) {
            OpaqueExpression expr = (OpaqueExpression)v;
            return expr.getLanguages().contains((Object)"ocl") || expr.getLanguages().contains((Object)"OCL");
        }
        return false;
    }

    public boolean hasJavaDefaultValue() {
        ValueSpecification v = this.getDefaultValue();
        if (v instanceof OpaqueExpression) {
            OpaqueExpression expr = (OpaqueExpression)v;
            return expr.getLanguages().contains((Object)"java") || expr.getLanguages().contains((Object)"JAVA");
        }
        return false;
    }

    public String getOclDerivedValue() {
        if (!this.hasOclDefaultValue()) {
            throw new IllegalStateException(String.format("Property %s does not have a default value", this.getName()));
        }
        StringBuilder sb = new StringBuilder();
        if (this.isQualified()) {
            Property owner = (Property)this.getOwner();
            Property derived = null;
            for (Element e : owner.getType().getOwnedElements()) {
                if (!(e instanceof Property) || !((NamedElement)e).getName().equals(this.getName())) continue;
                derived = (Property)e;
            }
            sb.append(PropertyWrapper.getOclDerivedValue(derived));
        } else {
            sb.append(PropertyWrapper.getOclDerivedValue(this.property));
        }
        return sb.toString();
    }

    private static String getOclDerivedValue(Property p) {
        PropertyWrapper pWrap = new PropertyWrapper(p);
        StringBuilder sb = new StringBuilder();
        sb.append("package ");
        sb.append(Namer.nameIncludingModel(pWrap.getOwningType().getNearestPackage()).replace(".", "::"));
        sb.append("\n    context ");
        if (pWrap.getOwner() instanceof Association) {
            sb.append(((Association)pWrap.getOwner()).getName());
        } else {
            sb.append(pWrap.getOwningType().getName());
        }
        sb.append("::");
        sb.append(pWrap.getName());
        sb.append(" : ");
        if (pWrap.isMany()) {
            sb.append(UmlgGenerationUtil.getCollectionInterface(pWrap));
            sb.append("(");
            sb.append(pWrap.getType().getQualifiedName());
            sb.append(")");
        } else {
            sb.append(pWrap.getType().getQualifiedName());
        }
        sb.append("\n");
        sb.append("    derive: ");
        sb.append(pWrap.getDefaultValue().stringValue());
        sb.append("\n");
        sb.append("endpackage");
        return sb.toString();
    }

    public String getJavaDefaultValue() {
        return this.getDefaultValue().toString();
    }

    public String getOclDefaultValue() {
        if (!this.hasOclDefaultValue()) {
            throw new IllegalStateException(String.format("Property %s does not have a default value", this.getName()));
        }
        StringBuilder sb = new StringBuilder();
        if (this.isQualified()) {
            Property owner = (Property)this.getOwner();
            Property derived = null;
            for (Element e : owner.getType().getOwnedElements()) {
                if (!(e instanceof Property) || !((NamedElement)e).getName().equals(this.getName())) continue;
                derived = (Property)e;
            }
            sb.append(this.getOclDefaultValue(derived));
        } else {
            sb.append(this.getOclDefaultValue(this.property));
        }
        return sb.toString();
    }

    private String getOclDefaultValue(Property p) {
        PropertyWrapper pWrap = new PropertyWrapper(p);
        StringBuilder sb = new StringBuilder();
        sb.append("package ");
        sb.append(Namer.nameIncludingModel(pWrap.getOwningType().getNearestPackage()).replace(".", "::"));
        sb.append("\ncontext ");
        sb.append(pWrap.getOwningType().getName());
        sb.append("::");
        sb.append(this.getName());
        sb.append("\n");
        sb.append("init: ");
        sb.append(pWrap.getDefaultValue().stringValue());
        sb.append("\n");
        sb.append("endpackage");
        return sb.toString();
    }

    public PropertyWrapper getQualifierCorrespondingQualifierStereotypedProperty() {
        PropertyWrapper result = null;
        if (!this.isQualifier()) {
            throw new IllegalStateException("getQualifierCorrespondingQualifierStereotypedProperty can only be called on a qualifier");
        }
        Property owner = (Property)this.getOwner();
        Stereotype qualifierVisitor = ModelLoader.INSTANCE.findStereotype("QualifierListener");
        for (Element element : UmlgClassOperations.getAllProperties((Classifier)((Class)owner.getType()))) {
            Property p;
            if (!(element instanceof Property) || !(p = (Property)element).isStereotypeApplied(qualifierVisitor)) continue;
            List qualifierTemps = (List)p.getValue(qualifierVisitor, "qualifier");
            if (qualifierTemps.isEmpty()) {
                throw new IllegalStateException(String.format("Property %s QualifierVisitor stereotype does not have its qualifier property set!", p.getQualifiedName()));
            }
            if (!qualifierTemps.contains(this.property)) continue;
            result = new PropertyWrapper(p);
            break;
        }
        return result;
    }

    public void validateQualifierCorrespondingQualifierStereotypedProperty() {
        if (!this.isQualifier()) {
            throw new IllegalStateException("getQualifierCorrespondingQualifierStereotypedProperty can only be called on a qualifier");
        }
        Property correspondingProperty = null;
        Property owner = (Property)this.getOwner();
        Stereotype qualifierVisitor = ModelLoader.INSTANCE.findStereotype("QualifierListener");
        for (Element e : owner.getType().getOwnedElements()) {
            Property p;
            if (!(e instanceof Property) || !(p = (Property)e).isStereotypeApplied(qualifierVisitor)) continue;
            List qualifierTemps = (List)p.getValue(qualifierVisitor, "qualifier");
            if (correspondingProperty != null && qualifierTemps.contains(this.property)) {
                throw new IllegalStateException(String.format("Qualifier %s has more than one corresponding QualifierVisitor stereotype. %s and %s ", this.getQualifiedName(), correspondingProperty.getQualifiedName(), p.getQualifiedName()));
            }
            if (!qualifierTemps.contains(this.property)) continue;
            correspondingProperty = p;
        }
    }

    public OJPathName getQualifierContextPathName() {
        if (this.isQualifier()) {
            throw new IllegalStateException("getQualifierContextPathName can not only be called on a qualifier");
        }
        if (!this.hasQualifiers()) {
            throw new IllegalStateException("getQualifierContextPathName can not only be called on a qualified property");
        }
        return UmlgClassOperations.getPathName(this.getType());
    }

    public Type getQualifierContext() {
        if (!this.isQualifier()) {
            throw new IllegalStateException("getQualifierContext can only be called on a qualifier");
        }
        Property owner = (Property)this.getOwner();
        return owner.getType();
    }

    public boolean hasQualifierCorrespondingQualifierVisitorStereotypedProperty() {
        if (!this.isQualifier()) {
            throw new IllegalStateException("getCorrespondingDerivedProperty can only be called on a qualifier");
        }
        return this.getQualifierCorrespondingQualifierStereotypedProperty() != null;
    }

    public String getQualifiedGetterName() {
        return "getQualifierFor" + StringUtils.capitalize((String)this.getName());
    }

    public String getQualifiedNameFor(List<PropertyWrapper> qualifers) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PropertyWrapper q : qualifers) {
            if (!first) {
                sb.append("and");
            }
            sb.append(StringUtils.capitalize((String)q.getName()));
            first = false;
        }
        return this.getter() + "For" + sb.toString();
    }

    public String getQualifiedNameForPartial(List<PropertyWrapper> qualifers) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PropertyWrapper q : qualifers) {
            if (!first) {
                sb.append("and");
            }
            sb.append(StringUtils.capitalize((String)q.getName()));
            first = false;
        }
        return this.getter() + "ForPartial" + sb.toString();
    }

    public Property getProperty() {
        return this.property;
    }

    public String getTumlRuntimePropertyEnum() {
        return UmlgClassOperations.propertyEnumName(this.getOwningType()) + "." + this.fieldname();
    }

    public String getQualifierJippoDefaultValue() {
        if (this.isString()) {
            return "\"\"";
        }
        if (this.isBoolean()) {
            return "false";
        }
        if (this.isInteger()) {
            return "-1";
        }
        if (this.isDate()) {
            return "LocalDate.now()";
        }
        if (this.isEnumeration()) {
            Enumeration enumeration = (Enumeration)this.getType();
            String name = Namer.qualifiedName((NamedElement)enumeration);
            return name + "." + ((EnumerationLiteral)enumeration.getOwnedLiterals().get(0)).getName();
        }
        throw new IllegalStateException(String.format("Qualified property %s is a %s, this is not supported for default values", this.getQualifiedName(), this.getType().getQualifiedName()));
    }

    public String getDefaultValueAsJava() {
        ValueSpecification v = this.getDefaultValue();
        if (v instanceof OpaqueExpression) {
            if (this.hasOclDefaultValue()) {
                return this.getOclDefaultValue();
            }
            return this.getDefaultValue().stringValue();
        }
        if (v instanceof LiteralString) {
            if (!UmlgPropertyOperations.isString((Type)this.getType())) {
                throw new IllegalStateException(String.format("Property %s has a LiteralString default value but is of type %s. This is illegal!", this.getQualifiedName(), this.getType().getQualifiedName()));
            }
            LiteralString expr = (LiteralString)v;
            String result = expr.getValue();
            if (result != null) {
                return "\"" + result.replaceAll("^\"|\"$", "") + "\"";
            }
            return "\"\"";
        }
        if (v instanceof LiteralReal) {
            LiteralReal literalReal = (LiteralReal)v;
            return String.valueOf(literalReal.getValue() + "D");
        }
        if (v instanceof LiteralInteger) {
            LiteralInteger literalInteger = (LiteralInteger)v;
            return String.valueOf(literalInteger.getValue());
        }
        if (v instanceof LiteralUnlimitedNatural) {
            LiteralUnlimitedNatural literalUnlimitedNatural = (LiteralUnlimitedNatural)v;
            return String.valueOf(literalUnlimitedNatural.getValue());
        }
        if (v instanceof LiteralBoolean) {
            LiteralBoolean literalBoolean = (LiteralBoolean)v;
            return String.valueOf(literalBoolean.isValue());
        }
        if (v instanceof LiteralNull) {
            return "null";
        }
        throw new RuntimeException(String.format("ValueSpecification %s not supported", v.getClass().getSimpleName()));
    }

    public boolean isForQualifier() {
        return !this.property.getOwner().getAppliedStereotypes().isEmpty();
    }

    public String toJson() {
        if (this.isMany()) {
            return "\\\"" + this.getName() + "\\\": \\\"\" + " + this.getter() + "() + \"\\\"";
        }
        return "\\\"" + this.getName() + "\\\": \\\"\" + " + this.getter() + "() + \"\\\"";
    }

    public boolean isComponent() {
        return !this.property.isDerived() && this.property.getType() instanceof Classifier && this.property.isComposite() && this.property.getLower() >= 1;
    }

    public boolean isInverseOrdered() {
        return this.getOtherEnd() != null && this.getOtherEnd().isOrdered();
    }

    public Type getOwningType() {
        return UmlgPropertyOperations.getOwningType(this.property);
    }

    public boolean isControllingSide() {
        return UmlgPropertyOperations.isControllingSide(this.property);
    }

    public String fieldname() {
        return this.property.getName();
    }

    public String getter() {
        if (!(this.isDerived() || this.isPrimitive() || this.isDataType() || this.isNavigable())) {
            return UmlgPropertyOperations.internalGetter(this.property);
        }
        return UmlgPropertyOperations.getter(this.property);
    }

    public String finder() {
        if (!this.isIndexed()) {
            throw new IllegalStateException("Only indexed fields can have finder methods!");
        }
        return UmlgPropertyOperations.finder(this.property);
    }

    public String setter() {
        return UmlgPropertyOperations.setter(this.property);
    }

    public String validator() {
        return UmlgPropertyOperations.validator(this.property);
    }

    public String checkConstraint(Constraint constraint) {
        return UmlgPropertyOperations.checkConstraint(this.property, constraint);
    }

    public boolean isPrimitive() {
        return UmlgPropertyOperations.isPrimitive(this.property);
    }

    public boolean isEnumeration() {
        return UmlgPropertyOperations.isEnumeration(this.property);
    }

    public boolean isACUnique() {
        return this.isACManyToOne() || this.isACOneToOne();
    }

    public boolean isACMany() {
        return false;
    }

    public boolean isACOneToMany() {
        return false;
    }

    public boolean isACManyToMany() {
        return false;
    }

    public boolean isACManyToOne() {
        return UmlgPropertyOperations.isManyToOne(this.property);
    }

    public boolean isACOneToOne() {
        return this.isOneToMany() && this.isUnique() || this.isOneToOne();
    }

    public boolean isOneToMany() {
        return UmlgPropertyOperations.isOneToMany(this.property);
    }

    public boolean isManyToOne() {
        return UmlgPropertyOperations.isManyToOne(this.property);
    }

    public boolean isManyToMany() {
        return UmlgPropertyOperations.isManyToMany(this.property);
    }

    public boolean isOneToOne() {
        return UmlgPropertyOperations.isOneToOne(this.property);
    }

    public String adder() {
        return UmlgPropertyOperations.adder(this.property);
    }

    public String adderIgnoreInverse() {
        return UmlgPropertyOperations.adder(this.property) + "IgnoreInverse";
    }

    public String remover() {
        return UmlgPropertyOperations.remover(this.property);
    }

    public String clearer() {
        return UmlgPropertyOperations.clearer(this.property);
    }

    public String internalRemover() {
        return UmlgPropertyOperations.internalRemover(this.property);
    }

    public String internalAdder() {
        return UmlgPropertyOperations.internalAdder(this.property);
    }

    public OJPathName javaBaseTypePath() {
        return UmlgPropertyOperations.getTypePath(this.property);
    }

    public OJPathName javaAuditBaseTypePath() {
        if (!this.isPrimitive() && !this.isEnumeration()) {
            return UmlgPropertyOperations.getTypePath(this.property).appendToTail("Audit");
        }
        return UmlgPropertyOperations.getTypePath(this.property);
    }

    public OJPathName javaImplTypePath() {
        return UmlgPropertyOperations.getDefaultTinkerCollection(this.property);
    }

    public OJPathName javaTumlTypePath() {
        return this.javaTumlTypePath(false);
    }

    public OJPathName javaTumlTypePath(boolean ignoreAssociationClass) {
        OJPathName fieldType;
        if (this.isOrdered() && this.isUnique()) {
            fieldType = this.hasQualifiers() && !this.isDerived() ? UmlgCollectionKindEnum.QUALIFIED_ORDERED_SET.getInterfacePathName() : (ignoreAssociationClass || !this.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.ORDERED_SET.getInterfacePathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_ORDERED_SET.getInterfacePathName());
        } else if (this.isOrdered() && !this.isUnique()) {
            fieldType = this.hasQualifiers() && !this.isDerived() ? UmlgCollectionKindEnum.QUALIFIED_SEQUENCE.getInterfacePathName() : (ignoreAssociationClass || !this.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.SEQUENCE.getInterfacePathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_SEQUENCE.getInterfacePathName());
        } else if (!this.isOrdered() && !this.isUnique()) {
            fieldType = this.hasQualifiers() && !this.isDerived() ? UmlgCollectionKindEnum.QUALIFIED_BAG.getInterfacePathName() : (ignoreAssociationClass || !this.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.BAG.getInterfacePathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_BAG.getInterfacePathName());
        } else if (!this.isOrdered() && this.isUnique()) {
            fieldType = this.hasQualifiers() && !this.isDerived() ? UmlgCollectionKindEnum.QUALIFIED_SET.getInterfacePathName() : (ignoreAssociationClass || !this.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.SET.getInterfacePathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_SET.getInterfacePathName());
        } else {
            throw new RuntimeException("wtf");
        }
        fieldType.addToGenerics(this.javaBaseTypePath());
        if (!ignoreAssociationClass && this.isMemberOfAssociationClass()) {
            fieldType.addToGenerics(this.getAssociationClassPathName());
        }
        return fieldType;
    }

    public OJPathName javaTypePath() {
        OJPathName fieldType;
        if (!this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SET.getInterfacePathName();
        } else if (this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SEQUENCE.getInterfacePathName();
        } else if (!this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.BAG.getInterfacePathName();
        } else if (this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.ORDERED_SET.getInterfacePathName();
        } else {
            throw new RuntimeException("wtf");
        }
        fieldType.addToGenerics(this.javaBaseTypePath());
        return fieldType;
    }

    public OJPathName javaTypePathWithAssociationClass() {
        OJPathName fieldType;
        if (!this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SET.getInterfacePathName();
        } else if (this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SEQUENCE.getInterfacePathName();
        } else if (!this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.BAG.getInterfacePathName();
        } else if (this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.ORDERED_SET.getInterfacePathName();
        } else {
            throw new RuntimeException("wtf");
        }
        fieldType.addToGenerics(this.getAssociationClassPair());
        return fieldType;
    }

    public OJPathName getAssociationClassPair() {
        OJPathName pair = UmlgGenerationUtil.Pair.getCopy();
        pair.addToGenerics(this.javaBaseTypePath()).addToGenerics(UmlgClassOperations.getPathName((Type)this.getAssociationClass()));
        return pair;
    }

    public String getAssociationClassFakePropertyName() {
        if (!this.isMemberOfAssociationClass()) {
            throw new IllegalStateException("Can not call getAssociationClassFakePropertyName on a property that does not belong to an AssociationClass!");
        }
        if (this.isRecursive()) {
            return UmlgClassOperations.getPathName((Type)this.getAssociationClass()).getLast() + "_" + this.fieldname();
        }
        return UmlgClassOperations.getPathName((Type)this.getAssociationClass()).getLast();
    }

    public String associationClassGetter() {
        if (!this.isMemberOfAssociationClass()) {
            throw new IllegalStateException("Can not call associationClassGetter on a property that is not a member end of an association class. Property = " + this.getQualifiedName());
        }
        return "get" + this.getAssociationClassFakePropertyName();
    }

    public String associationClassGetterForProperty() {
        if (!this.isMemberOfAssociationClass()) {
            throw new IllegalStateException("Can not call associationClassGetterForProperty on a property that is not a member end of an association class. Property = " + this.getQualifiedName());
        }
        return "get" + this.getAssociationClassFakePropertyName() + "_" + this.getName();
    }

    public String associationClassMoverForProperty() {
        if (!this.isMemberOfAssociationClass()) {
            throw new IllegalStateException("Can not call associationClassMoverForProperty on a property that is not a member end of an association class. Property = " + this.getQualifiedName());
        }
        return "move" + StringUtils.capitalize((String)this.getName());
    }

    public OJPathName javaTumlMemoryTypePath() {
        OJPathName memoryCollectionPathName = this.isQualified() ? UmlgCollectionKindEnum.from(this).getQualifiedMemoryCollection() : UmlgCollectionKindEnum.from(this).getMemoryCollection();
        memoryCollectionPathName.addToGenerics(this.javaBaseTypePath());
        return memoryCollectionPathName;
    }

    public OJPathName javaAuditTypePath() {
        OJPathName fieldType;
        if (!this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SET.getInterfacePathName();
        } else if (this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SEQUENCE.getInterfacePathName();
        } else if (!this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.BAG.getInterfacePathName();
        } else if (this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.ORDERED_SET.getInterfacePathName();
        } else {
            throw new RuntimeException("wtf");
        }
        fieldType.addToGenerics(this.javaAuditBaseTypePath());
        return fieldType;
    }

    public String emptyCollection() {
        if (!this.isOrdered() && this.isUnique()) {
            return "UmlgCollections.emptySet()";
        }
        if (this.isOrdered() && !this.isUnique()) {
            return "UmlgCollections.emptySequence()";
        }
        if (!this.isOrdered() && !this.isUnique()) {
            return "UmlgCollections.emptyBag()";
        }
        if (this.isOrdered() && this.isUnique()) {
            return "UmlgCollections.emptyOrderedSet()";
        }
        throw new RuntimeException("wtf");
    }

    public OJPathName javaClosableIteratorTypePath() {
        OJPathName fieldType;
        if (!this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SET.getClosableIteratorPathName();
        } else if (this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.SEQUENCE.getClosableIteratorPathName();
        } else if (!this.isOrdered() && !this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.BAG.getClosableIteratorPathName();
        } else if (this.isOrdered() && this.isUnique()) {
            fieldType = UmlgCollectionKindEnum.ORDERED_SET.getClosableIteratorPathName();
        } else {
            throw new RuntimeException("wtf");
        }
        fieldType.addToGenerics(this.javaBaseTypePath());
        return fieldType;
    }

    public String javaDefaultInitialisation(Classifier propertyConcreteOwner) {
        return this.javaDefaultInitialisation(propertyConcreteOwner, false);
    }

    public String javaDefaultInitialisation(Classifier propertyConcreteOwner, boolean ignoreAssociationClass) {
        return UmlgPropertyOperations.getDefaultTinkerCollectionInitalisation(this.property, propertyConcreteOwner, ignoreAssociationClass).getExpression();
    }

    public String javaDefaultInitialisationForAssociationClass(Classifier propertyConcreteOwner) {
        return UmlgPropertyOperations.getDefaultTinkerCollectionInitalisationForAssociationClass(this.property, propertyConcreteOwner).getExpression();
    }

    @Override
    public boolean isOne() {
        return UmlgPropertyOperations.isOne(this.property);
    }

    public boolean isUnqualifiedOne() {
        return UmlgPropertyOperations.isUnqualifiedOne(this.property);
    }

    @Override
    public boolean isMany() {
        return UmlgPropertyOperations.isMany(this.property);
    }

    public boolean isUnqualifiedMany() {
        return UmlgPropertyOperations.isUnqualifiedMany(this.property);
    }

    public List<PropertyWrapper> getQualifiersAsPropertyWrappers() {
        ArrayList<PropertyWrapper> result = new ArrayList<PropertyWrapper>();
        for (Property q : this.property.getQualifiers()) {
            result.add(new PropertyWrapper(q));
        }
        return result;
    }

    public boolean isReadOnly() {
        return this.property.isReadOnly() || this.isDerived();
    }

    public void setIsReadOnly(boolean value) {
        throw new RuntimeException("Not supported");
    }

    public boolean isStatic() {
        return this.property.isStatic();
    }

    public void setIsStatic(boolean value) {
        throw new RuntimeException("Not supported");
    }

    public EList<Classifier> getFeaturingClassifiers() {
        return this.property.getFeaturingClassifiers();
    }

    public Classifier getFeaturingClassifier(String name) {
        return this.property.getFeaturingClassifier(name);
    }

    public Classifier getFeaturingClassifier(String name, boolean ignoreCase, EClass eClass) {
        return this.getFeaturingClassifier(name, ignoreCase, eClass);
    }

    public boolean isLeaf() {
        return this.property.isLeaf();
    }

    public void setIsLeaf(boolean value) {
        throw new RuntimeException("Not supported");
    }

    public EList<RedefinableElement> getRedefinedElements() {
        return this.property.getRedefinedElements();
    }

    public RedefinableElement getRedefinedElement(String name) {
        return this.property.getRedefinedElement(name);
    }

    public RedefinableElement getRedefinedElement(String name, boolean ignoreCase, EClass eClass) {
        return this.getRedefinedElement(name, ignoreCase, eClass);
    }

    public EList<Classifier> getRedefinitionContexts() {
        return this.property.getRedefinitionContexts();
    }

    public Classifier getRedefinitionContext(String name) {
        return this.getRedefinitionContext(name);
    }

    public Classifier getRedefinitionContext(String name, boolean ignoreCase, EClass eClass) {
        return this.property.getRedefinitionContext(name, ignoreCase, eClass);
    }

    public boolean validateRedefinitionContextValid(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.property.validateRedefinitionContextValid(diagnostics, context);
    }

    public boolean validateRedefinitionConsistent(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.property.validateRedefinitionConsistent(diagnostics, context);
    }

    public boolean isRedefinitionContextValid(RedefinableElement redefined) {
        return this.property.isRedefinitionContextValid(redefined);
    }

    public boolean isConsistentWith(RedefinableElement redefinee) {
        return this.property.isConsistentWith(redefinee);
    }

    public String getName() {
        return this.property.getName();
    }

    public void setName(String value) {
        throw new RuntimeException("Not supported");
    }

    public void unsetName() {
        throw new RuntimeException("Not supported");
    }

    public boolean isSetName() {
        return this.property.isSetName();
    }

    public VisibilityKind getVisibility() {
        return this.property.getVisibility();
    }

    public void setVisibility(VisibilityKind value) {
        throw new RuntimeException("Not supported");
    }

    public void unsetVisibility() {
        throw new RuntimeException("Not supported");
    }

    public boolean isSetVisibility() {
        return this.property.isSetVisibility();
    }

    public String getQualifiedName() {
        if (this.isQualifier()) {
            return ((NamedElement)this.property.getOwner()).getQualifiedName() + "::" + this.property.getQualifiedName();
        }
        return this.property.getQualifiedName();
    }

    public String getPersistentName() {
        if (this.isQualifier()) {
            return ((Property)this.getOwner()).getName() + "_" + this.getName();
        }
        return this.getName();
    }

    public String getInverseName() {
        if (this.getOtherEnd() != null) {
            return this.getOtherEnd().getName();
        }
        return "inverseOf::" + this.property.getName();
    }

    public String getInverseQualifiedName() {
        if (this.getOtherEnd() != null) {
            return this.getOtherEnd().getQualifiedName();
        }
        return "inverseOf::" + this.property.getQualifiedName();
    }

    public EList<Dependency> getClientDependencies() {
        return this.property.getClientDependencies();
    }

    public Dependency getClientDependency(String name) {
        return this.property.getClientDependency(name);
    }

    public Dependency getClientDependency(String name, boolean ignoreCase, EClass eClass) {
        return this.property.getClientDependency(name, ignoreCase, eClass);
    }

    public Namespace getNamespace() {
        return this.property.getNamespace();
    }

    public StringExpression getNameExpression() {
        return this.property.getNameExpression();
    }

    public void setNameExpression(StringExpression value) {
        throw new RuntimeException("Not supported");
    }

    public StringExpression createNameExpression(String name, Type type) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateHasNoQualifiedName(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.property.validateHasNoQualifiedName(diagnostics, context);
    }

    public boolean validateHasQualifiedName(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateVisibilityNeedsOwnership(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public Dependency createDependency(NamedElement supplier) {
        throw new RuntimeException("Not supported");
    }

    public String getLabel() {
        return this.property.getLabel();
    }

    public String getLabel(boolean localize) {
        return this.getLabel(localize);
    }

    public Usage createUsage(NamedElement supplier) {
        throw new RuntimeException("Not supported");
    }

    public EList<Namespace> allNamespaces() {
        return this.property.allNamespaces();
    }

    public boolean isDistinguishableFrom(NamedElement n, Namespace ns) {
        return this.property.isDistinguishableFrom(n, ns);
    }

    public String separator() {
        return this.property.separator();
    }

    public EList<Package> allOwningPackages() {
        return this.property.allOwningPackages();
    }

    public Type getType() {
        return this.property.getType();
    }

    public void setType(Type value) {
        throw new RuntimeException("Not supported");
    }

    public EList<ConnectorEnd> getEnds() {
        return null;
    }

    public TemplateParameter getTemplateParameter() {
        return null;
    }

    public void setTemplateParameter(TemplateParameter value) {
    }

    public TemplateParameter getOwningTemplateParameter() {
        return null;
    }

    public void setOwningTemplateParameter(TemplateParameter value) {
    }

    public boolean isCompatibleWith(ParameterableElement p) {
        return false;
    }

    public boolean isTemplateParameter() {
        return false;
    }

    public EList<Deployment> getDeployments() {
        return null;
    }

    public Deployment createDeployment(String name) {
        return null;
    }

    public Deployment getDeployment(String name) {
        return null;
    }

    public Deployment getDeployment(String name, boolean ignoreCase, boolean createOnDemand) {
        return null;
    }

    public EList<PackageableElement> getDeployedElements() {
        return null;
    }

    public PackageableElement getDeployedElement(String name) {
        return null;
    }

    public PackageableElement getDeployedElement(String name, boolean ignoreCase, EClass eClass) {
        return null;
    }

    public DataType getDatatype() {
        return null;
    }

    public void setDatatype(DataType value) {
    }

    public boolean isDerived() {
        return this.property.isDerived();
    }

    public void setIsDerived(boolean value) {
        throw new RuntimeException("Not supported");
    }

    public boolean isDerivedUnion() {
        return this.property.isDerivedUnion();
    }

    public void setIsDerivedUnion(boolean value) {
        throw new RuntimeException("Not supported");
    }

    public String getDefault() {
        return this.property.getDefault();
    }

    public void setDefault(String value) {
        throw new RuntimeException("Not supported");
    }

    public AggregationKind getAggregation() {
        return this.property.getAggregation();
    }

    public void setAggregation(AggregationKind value) {
        throw new RuntimeException("Not supported");
    }

    public boolean isComposite() {
        return this.property.isComposite();
    }

    public void setIsComposite(boolean value) {
        throw new RuntimeException("Not supported");
    }

    public Class getClass_() {
        return this.property.getClass_();
    }

    public EList<Property> getRedefinedProperties() {
        return this.property.getRedefinedProperties();
    }

    public Property getRedefinedProperty(String name, Type type) {
        return this.property.getRedefinedProperty(name, type);
    }

    public Property getRedefinedProperty(String name, Type type, boolean ignoreCase, EClass eClass) {
        return this.property.getRedefinedProperty(name, type, ignoreCase, eClass);
    }

    public Association getOwningAssociation() {
        return this.property.getOwningAssociation();
    }

    public void setOwningAssociation(Association value) {
        throw new RuntimeException("Not supported");
    }

    public Association getAssociation() {
        return this.property.getAssociation();
    }

    public void setAssociation(Association value) {
        throw new RuntimeException("Not supported");
    }

    public ValueSpecification getDefaultValue() {
        return this.property.getDefaultValue();
    }

    public void setDefaultValue(ValueSpecification value) {
        throw new RuntimeException("Not supported");
    }

    public ValueSpecification createDefaultValue(String name, Type type, EClass eClass) {
        throw new RuntimeException("Not supported");
    }

    public Property getOpposite() {
        return this.property.getOpposite();
    }

    public void setOpposite(Property value) {
        throw new RuntimeException("Not supported");
    }

    public EList<Property> getSubsettedProperties() {
        return this.property.getSubsettedProperties();
    }

    public Property getSubsettedProperty(String name, Type type) {
        return this.property.getSubsettedProperty(name, type);
    }

    public Property getSubsettedProperty(String name, Type type, boolean ignoreCase, EClass eClass) {
        return this.property.getSubsettedProperty(name, type, ignoreCase, eClass);
    }

    public EList<Property> getQualifiers() {
        return this.property.getQualifiers();
    }

    public Property createQualifier(String name, Type type, EClass eClass) {
        throw new RuntimeException("Not supported");
    }

    public Property createQualifier(String name, Type type) {
        throw new RuntimeException("Not supported");
    }

    public Property getQualifier(String name, Type type) {
        return this.property.getQualifier(name, type);
    }

    public Property getQualifier(String name, Type type, boolean ignoreCase, EClass eClass, boolean createOnDemand) {
        return this.property.getQualifier(name, type, ignoreCase, eClass, createOnDemand);
    }

    public Property getAssociationEnd() {
        return this.property.getAssociationEnd();
    }

    public void setAssociationEnd(Property value) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateMultiplicityOfComposite(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateSubsettingContextConforms(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateRedefinedPropertyInherited(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateSubsettingRules(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateDerivedUnionIsDerived(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateDerivedUnionIsReadOnly(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateSubsettedPropertyNames(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateTypeOfOppositeEnd(DiagnosticChain diagnosticChain, Map<Object, Object> objectObjectMap) {
        return false;
    }

    public boolean validateQualifiedIsAssociationEnd(DiagnosticChain diagnosticChain, Map<Object, Object> objectObjectMap) {
        return false;
    }

    public boolean validateDeploymentTarget(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public boolean validateBindingToAttribute(DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new RuntimeException("Not supported");
    }

    public void setIsNavigable(boolean isNavigable) {
        throw new RuntimeException("Not supported");
    }

    public Property getOtherEnd() {
        return this.property.getOtherEnd();
    }

    public void setBooleanDefaultValue(boolean value) {
        throw new RuntimeException("Not supported");
    }

    public void setIntegerDefaultValue(int value) {
        throw new RuntimeException("Not supported");
    }

    public void setStringDefaultValue(String value) {
        throw new RuntimeException("Not supported");
    }

    public void setUnlimitedNaturalDefaultValue(int value) {
        throw new RuntimeException("Not supported");
    }

    public boolean isAttribute() {
        return this.property.isAttribute();
    }

    public void setNullDefaultValue() {
        throw new RuntimeException("Not supported");
    }

    public EList<Type> subsettingContext() {
        return null;
    }

    public boolean isNavigable() {
        return this.property.isNavigable();
    }

    public boolean isString() {
        return this.getType() instanceof PrimitiveType && this.getType().getName().equals("String");
    }

    public boolean isNumber() {
        return this.getType() instanceof PrimitiveType && (this.getType().getName().equals("Integer") || this.getType().getName().equals("int") || this.getType().getName().equals("byte") || this.getType().getName().equals("Byte") || this.getType().getName().equals("long") || this.getType().getName().equals("float") || this.getType().getName().equals("double") || this.getType().getName().equals("UnlimitedNatural") || this.getType().getName().equals("Real"));
    }

    public boolean isBoolean() {
        return this.getType() instanceof PrimitiveType && (this.getType().getName().equals("Boolean") || this.getType().getName().equals("boolean"));
    }

    public boolean isInteger() {
        return this.getType() instanceof PrimitiveType && (this.getType().getName().equals("Integer") || this.getType().getName().equals("int") || this.getType().getName().equals("UnlimitedNatural"));
    }

    public boolean isLong() {
        return this.getType() instanceof PrimitiveType && this.getType().getName().equals("long");
    }

    public boolean isUnlimitedNatural() {
        return this.getType() instanceof PrimitiveType && this.getType().getName().equals("UnlimitedNatural");
    }

    public boolean isDouble() {
        return this.getType() instanceof PrimitiveType && (this.getType().getName().equals("Real") || this.getType().getName().equals("double"));
    }

    public boolean isFloat() {
        return this.getType() instanceof PrimitiveType && this.getType().getName().equals("float");
    }

    public boolean isByte() {
        return this.getType() instanceof PrimitiveType && this.getType().getName().equals("byte");
    }

    public boolean isShort() {
        return this.getType() instanceof PrimitiveType && this.getType().getName().equals("short");
    }

    public String toString() {
        return this.property.toString();
    }

    public String lookup() {
        if (this.getOtherEnd() != null) {
            return "lookupFor_" + this.getOtherEnd().getName() + "_" + this.getName();
        }
        return "lookupFor__" + this.getName();
    }

    public String lookupGetter() {
        return "getLookupFor_" + this.getOtherEnd().getName() + "_" + this.getName();
    }

    public String lookupOnCompositeParent() {
        if (this.getOtherEnd() != null) {
            return "lookupOnCompositeParentFor_" + this.getOtherEnd().getName() + "_" + this.property.getName();
        }
        return "lookupOnCompositeParentFor__" + this.property.getName();
    }

    public String lookupOnCompositeParentGetter() {
        return "getLookupOnCompositeParentFor_" + this.getOtherEnd().getName() + "_" + this.property.getName();
    }

    public String lookupCompositeParent() {
        return "lookupFor_" + new PropertyWrapper(this.getOtherEnd()).getName() + "_" + this.getName() + "_CompositeParent";
    }

    public boolean isDate() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isDate((DataType)this.getType());
    }

    public boolean isEmail() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isEmail((DataType)this.getType());
    }

    public boolean isHost() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isHost((DataType)this.getType());
    }

    public boolean isQuartzCron() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isQuartzCron((DataType)this.getType());
    }

    public boolean isUnixCron() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isUnixCron((DataType)this.getType());
    }

    public boolean isPassword() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isPassword((DataType)this.getType());
    }

    public boolean isInternationalPhoneNumber() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isInternationalPhoneNumber((DataType)this.getType());
    }

    public boolean isLocalPhoneNumber() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isLocalPhoneNumber((DataType)this.getType());
    }

    public boolean isVideo() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isVideo((DataType)this.getType());
    }

    public boolean isAudio() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isAudio((DataType)this.getType());
    }

    public boolean isImage() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isImage((DataType)this.getType());
    }

    public boolean isDateTime() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isDateTime((DataType)this.getType());
    }

    public boolean isTime() {
        return this.getType() instanceof DataType && UmlgDataTypeOperation.isTime((DataType)this.getType());
    }

    public DataTypeEnum getDataTypeEnum() {
        if (this.getType() instanceof DataType && !(this.getType() instanceof PrimitiveType) && !(this.getType() instanceof Enumeration)) {
            return UmlgDataTypeOperation.getDataTypeEnum((DataType)this.getType());
        }
        return null;
    }

    public boolean hasMaxLength() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxLength.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isString()) {
                throw new IllegalStateException("The MaxLength stereotype may only be applied to properties of type String! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasValidation(UmlgValidationEnum umlgValidationEnum) {
        switch (umlgValidationEnum) {
            case MaxLength: {
                return this.hasMaxLength();
            }
            case MinLength: {
                return this.hasMinLength();
            }
            case RangeLength: {
                return this.hasRangeLength();
            }
            case MinInteger: {
                return this.hasMinInteger();
            }
            case MaxInteger: {
                return this.hasMaxInteger();
            }
            case RangeInteger: {
                return this.hasRangeInteger();
            }
            case MinUnlimitedNatural: {
                return this.hasMinUnlimitedNatural();
            }
            case MaxUnlimitedNatural: {
                return this.hasMaxUnlimitedNatural();
            }
            case RangeUnlimitedNatural: {
                return this.hasRangeUnlimitedNatural();
            }
            case MinLong: {
                return this.hasMinLong();
            }
            case MaxLong: {
                return this.hasMaxLong();
            }
            case RangeLong: {
                return this.hasRangeLong();
            }
            case MinFloat: {
                return this.hasMinFloat();
            }
            case MaxFloat: {
                return this.hasMaxFloat();
            }
            case RangeFloat: {
                return this.hasRangeFloat();
            }
            case MinDouble: {
                return this.hasMinDouble();
            }
            case MaxDouble: {
                return this.hasMaxDouble();
            }
            case RangeDouble: {
                return this.hasRangeDouble();
            }
            case MinReal: {
                return this.hasMinReal();
            }
            case MaxReal: {
                return this.hasMaxReal();
            }
            case RangeReal: {
                return this.hasRangeReal();
            }
            case Email: {
                return this.isEmail();
            }
            case QuartzCron: {
                return this.isQuartzCron();
            }
            case UnixCron: {
                return this.isUnixCron();
            }
            case Host: {
                return this.isHost();
            }
            case Password: {
                return this.isPassword();
            }
        }
        return false;
    }

    public List<Validation> getValidations() {
        Validation v;
        ArrayList<Validation> result = new ArrayList<Validation>();
        List stereoTypes = ModelLoader.INSTANCE.getValidationStereotypes();
        for (Stereotype stereotype : stereoTypes) {
            if (!this.property.isStereotypeApplied(stereotype)) continue;
            result.add(UmlgValidationEnum.fromStereotype(stereotype, this.property));
        }
        if (this.getType() instanceof DataType && (v = UmlgValidationEnum.fromDataType((DataType)this.getType())) != null) {
            result.add(v);
        }
        return result;
    }

    public Validation getValidation(UmlgValidationEnum umlgValidationEnum) {
        switch (umlgValidationEnum) {
            case MaxLength: {
                return this.getMaxLength();
            }
            case MinLength: {
                return this.getMinLength();
            }
            case RangeLength: {
                return this.getRangeLength();
            }
            case MinInteger: {
                return this.getMinInteger();
            }
            case MaxInteger: {
                return this.getMaxInteger();
            }
            case RangeInteger: {
                return this.getRangeInteger();
            }
            case MinUnlimitedNatural: {
                return this.getMinUnlimitedNatural();
            }
            case MaxUnlimitedNatural: {
                return this.getMaxUnlimitedNatural();
            }
            case RangeUnlimitedNatural: {
                return this.getRangeUnlimitedNatural();
            }
            case MinLong: {
                return this.getMinLong();
            }
            case MaxLong: {
                return this.getMaxLong();
            }
            case RangeLong: {
                return this.getRangeLong();
            }
            case MinFloat: {
                return this.getMinFloat();
            }
            case MaxFloat: {
                return this.getMaxFloat();
            }
            case RangeFloat: {
                return this.getRangeFloat();
            }
            case MinDouble: {
                return this.getMinDouble();
            }
            case MaxDouble: {
                return this.getMaxDouble();
            }
            case RangeDouble: {
                return this.getRangeDouble();
            }
            case MinReal: {
                return this.getMinReal();
            }
            case MaxReal: {
                return this.getMaxReal();
            }
            case RangeReal: {
                return this.getRangeReal();
            }
            case Email: {
                return this.getEmail();
            }
            case Host: {
                return this.getHost();
            }
            case QuartzCron: {
                return this.getQuartzCron();
            }
            case UnixCron: {
                return this.getUnixCron();
            }
            case Password: {
                return this.getPassword();
            }
        }
        return null;
    }

    @Override
    public Object getValue(Stereotype stereotype, String propertyName) {
        return this.property.getValue(stereotype, propertyName);
    }

    public MaxLength getMaxLength() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxLength.name());
        return new MaxLength((Integer)this.property.getValue(stereotype, "length"));
    }

    public MinLength getMinLength() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinLength.name());
        return new MinLength((Integer)this.property.getValue(stereotype, "length"));
    }

    public RangeLength getRangeLength() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeLength.name());
        return new RangeLength((Integer)this.property.getValue(stereotype, "min"), (Integer)this.property.getValue(stereotype, "max"));
    }

    public MaxInteger getMaxInteger() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxInteger.name());
        return new MaxInteger((Integer)this.property.getValue(stereotype, "max"));
    }

    public MinInteger getMinInteger() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinInteger.name());
        return new MinInteger((Integer)this.property.getValue(stereotype, "min"));
    }

    public RangeInteger getRangeInteger() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeInteger.name());
        return new RangeInteger((Integer)this.property.getValue(stereotype, "min"), (Integer)this.property.getValue(stereotype, "max"));
    }

    public MaxUnlimitedNatural getMaxUnlimitedNatural() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxUnlimitedNatural.name());
        return new MaxUnlimitedNatural((Integer)this.property.getValue(stereotype, "max"));
    }

    public MinUnlimitedNatural getMinUnlimitedNatural() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinUnlimitedNatural.name());
        return new MinUnlimitedNatural((Integer)this.property.getValue(stereotype, "min"));
    }

    public RangeUnlimitedNatural getRangeUnlimitedNatural() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeUnlimitedNatural.name());
        return new RangeUnlimitedNatural((Integer)this.property.getValue(stereotype, "min"), (Integer)this.property.getValue(stereotype, "max"));
    }

    public MaxLong getMaxLong() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxLong.name());
        return new MaxLong((Long)this.property.getValue(stereotype, "max"));
    }

    public MinLong getMinLong() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinLong.name());
        return new MinLong((Long)this.property.getValue(stereotype, "min"));
    }

    public RangeLong getRangeLong() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeLong.name());
        return new RangeLong((Long)this.property.getValue(stereotype, "min"), (Long)this.property.getValue(stereotype, "max"));
    }

    public MaxFloat getMaxFloat() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxFloat.name());
        return new MaxFloat((Float)this.property.getValue(stereotype, "max"));
    }

    public MinFloat getMinFloat() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinFloat.name());
        return new MinFloat((Float)this.property.getValue(stereotype, "min"));
    }

    public RangeFloat getRangeFloat() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeFloat.name());
        return new RangeFloat((Float)this.property.getValue(stereotype, "min"), (Float)this.property.getValue(stereotype, "max"));
    }

    public MaxDouble getMaxDouble() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxDouble.name());
        return new MaxDouble((Double)this.property.getValue(stereotype, "max"));
    }

    public MinDouble getMinDouble() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinDouble.name());
        return new MinDouble((Double)this.property.getValue(stereotype, "min"));
    }

    public RangeDouble getRangeDouble() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeDouble.name());
        return new RangeDouble((Double)this.property.getValue(stereotype, "min"), (Double)this.property.getValue(stereotype, "max"));
    }

    public MaxReal getMaxReal() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxReal.name());
        return new MaxReal((Double)this.property.getValue(stereotype, "max"));
    }

    public MinReal getMinReal() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinReal.name());
        return new MinReal((Double)this.property.getValue(stereotype, "min"));
    }

    public RangeReal getRangeReal() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeReal.name());
        return new RangeReal((Double)this.property.getValue(stereotype, "min"), (Double)this.property.getValue(stereotype, "max"));
    }

    public Email getEmail() {
        return new Email();
    }

    public Host getHost() {
        return new Host();
    }

    public QuartzCron getQuartzCron() {
        return new QuartzCron();
    }

    public UnixCron getUnixCron() {
        return new UnixCron();
    }

    public PasswordValidation getPassword() {
        return new PasswordValidation();
    }

    public boolean hasMinLength() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinLength.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isString()) {
                throw new IllegalStateException("The MinLength stereotype may only be applied to properties of type String! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasRangeLength() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeLength.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isString()) {
                throw new IllegalStateException("The RangeLength stereotype may only be applied to properties of type String! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMinInteger() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinInteger.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isInteger()) {
                throw new IllegalStateException("The MinInteger stereotype may only be applied to properties of type Integer! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMaxInteger() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxInteger.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isInteger()) {
                throw new IllegalStateException("The MaxInteger stereotype may only be applied to properties of type Integer! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasRangeInteger() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeInteger.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isInteger()) {
                throw new IllegalStateException("The RangeInteger stereotype may only be applied to properties of type Integer! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMinUnlimitedNatural() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinUnlimitedNatural.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isInteger()) {
                throw new IllegalStateException("The MinUnlimitedNatural stereotype may only be applied to properties of type UnlimitedNatural! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMaxUnlimitedNatural() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxUnlimitedNatural.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isInteger()) {
                throw new IllegalStateException("The MaxUnlimitedNatural stereotype may only be applied to properties of type UnlimitedNatural! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasRangeUnlimitedNatural() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeUnlimitedNatural.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isInteger()) {
                throw new IllegalStateException("The RangeUnlimitedNatural stereotype may only be applied to properties of type UnlimitedNatural! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMinLong() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinLong.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isLong()) {
                throw new IllegalStateException("The MinLong stereotype may only be applied to properties of type JavaPrimitiveType::long! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMaxLong() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxLong.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isLong()) {
                throw new IllegalStateException("The MaxLong stereotype may only be applied to properties of type JavaPrimitiveType::long! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasRangeLong() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeLong.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isLong()) {
                throw new IllegalStateException("The RangeLong stereotype may only be applied to properties of type JavaPrimitiveType::long! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMinFloat() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinFloat.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isFloat()) {
                throw new IllegalStateException("The MinFloat stereotype may only be applied to properties of type JavaPrimitiveType::float! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMaxFloat() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxFloat.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isFloat()) {
                throw new IllegalStateException("The MaxFloat stereotype may only be applied to properties of type JavaPrimitiveType::float! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasRangeFloat() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeFloat.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isFloat()) {
                throw new IllegalStateException("The RangeFloat stereotype may only be applied to properties of type JavaPrimitiveType::float! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMinDouble() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinDouble.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isDouble()) {
                throw new IllegalStateException("The MinDouble stereotype may only be applied to properties of type JavaPrimitiveType::double! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMaxDouble() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxDouble.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isDouble()) {
                throw new IllegalStateException("The MaxFloat stereotype may only be applied to properties of type JavaPrimitiveType::double! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasRangeDouble() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeDouble.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isDouble()) {
                throw new IllegalStateException("The RangeFloat stereotype may only be applied to properties of type JavaPrimitiveType::double! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMinReal() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MinReal.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isDouble()) {
                throw new IllegalStateException("The MinReal stereotype may only be applied to properties of type Real! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasMaxReal() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.MaxReal.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isDouble()) {
                throw new IllegalStateException("The MaxInteger stereotype may only be applied to properties of type Real! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean hasRangeReal() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype(UmlgValidationEnum.RangeReal.name());
        if (this.property.isStereotypeApplied(stereotype)) {
            if (!this.isDouble()) {
                throw new IllegalStateException("The RangeInteger stereotype may only be applied to properties of type Real! property = " + this.getQualifiedName());
            }
            return true;
        }
        return false;
    }

    public boolean validateNonLeafRedefinition(DiagnosticChain arg0, Map<Object, Object> arg1) {
        return false;
    }

    public Interface getInterface() {
        return null;
    }

    public boolean isID() {
        return false;
    }

    public void setInterface(Interface arg0) {
    }

    public void setIsID(boolean arg0) {
    }

    public void setRealDefaultValue(double arg0) {
    }

    public boolean isOtherEndComposite() {
        if (this.getOtherEnd() != null) {
            PropertyWrapper otherEnd = new PropertyWrapper(this.getOtherEnd());
            return otherEnd.isComposite();
        }
        return false;
    }

    public boolean isMemberOfAssociationClass() {
        Element owner = this.property.getOwner();
        if (owner instanceof AssociationClass) {
            AssociationClass ownerClass = (AssociationClass)owner;
            EList memberEnds = ownerClass.getMemberEnds();
            for (Property p : memberEnds) {
                if (p != this.property) continue;
                return true;
            }
            return false;
        }
        if (owner instanceof Class) {
            Class ownerClass = (Class)owner;
            EList associations = ownerClass.getAssociations();
            for (Association association : associations) {
                EList memberEnds = association.getMemberEnds();
                for (Property p : memberEnds) {
                    if (p != this.property || !(association instanceof AssociationClass)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public AssociationClass getAssociationClass() {
        Element owner = this.property.getOwner();
        if (owner instanceof AssociationClass) {
            return (AssociationClass)owner;
        }
        if (owner instanceof Class) {
            Class ownerClass = (Class)owner;
            EList associations = ownerClass.getAssociations();
            for (Association association : associations) {
                EList memberEnds = association.getMemberEnds();
                for (Property p : memberEnds) {
                    if (p != this.property || !(association instanceof AssociationClass)) continue;
                    return (AssociationClass)association;
                }
            }
            return null;
        }
        return null;
    }

    public OJPathName getAssociationClassPathName() {
        return UmlgClassOperations.getPathName((Type)this.getAssociationClass());
    }

    public OJPathName getAssociationClassJavaTumlTypePath() {
        OJPathName fieldType;
        if (this.isOrdered() && this.isUnique()) {
            fieldType = this.hasQualifiers() ? UmlgCollectionKindEnum.QUALIFIED_ORDERED_SET.getInterfacePathName() : UmlgCollectionKindEnum.ORDERED_SET.getInterfacePathName();
        } else if (this.isOrdered() && !this.isUnique()) {
            fieldType = this.hasQualifiers() ? UmlgCollectionKindEnum.QUALIFIED_SEQUENCE.getInterfacePathName() : UmlgCollectionKindEnum.SEQUENCE.getInterfacePathName();
        } else if (!this.isOrdered() && !this.isUnique()) {
            fieldType = this.hasQualifiers() ? UmlgCollectionKindEnum.QUALIFIED_BAG.getInterfacePathName() : UmlgCollectionKindEnum.BAG.getInterfacePathName();
        } else if (!this.isOrdered() && this.isUnique()) {
            fieldType = this.hasQualifiers() ? UmlgCollectionKindEnum.QUALIFIED_SET.getInterfacePathName() : UmlgCollectionKindEnum.SET.getInterfacePathName();
        } else {
            throw new RuntimeException("wtf");
        }
        fieldType.addToGenerics(this.getAssociationClassPathName());
        return fieldType;
    }

    public String updateIndexForQualifierName() {
        if (!this.isQualifier()) {
            throw new IllegalStateException("PropertyWrapper.updateIndexForQualifierName() can only be called for a qualifier!");
        }
        return "updateIndexFor" + StringUtils.capitalize((String)this.getName());
    }

    public boolean isRecursive() {
        return this.getOtherEnd() != null && this.getOtherEnd().getType() == this.getType();
    }

    public boolean isIndexed() {
        Stereotype stereotype = ModelLoader.INSTANCE.findStereotype("Index");
        return this.isStereotypeApplied(stereotype);
    }

    public boolean isRefined() {
        Association association = this.property.getAssociation();
        if (association != null) {
            return !ModelLoader.INSTANCE.getOriginalAbstractionForRefinedAssociation(association).isEmpty();
        }
        return false;
    }

    public List<Property> getRefinedQualifieds() {
        Association association = this.property.getAssociation();
        if (association != null) {
            ArrayList<Property> result = new ArrayList<Property>();
            List abstractions = ModelLoader.INSTANCE.getRefinedAbstraction(association);
            for (Abstraction abstraction : abstractions) {
                EList clients = abstraction.getClients();
                block1: for (NamedElement supplier : clients) {
                    if (!(supplier instanceof Association)) continue;
                    Association refinedAssociation = (Association)supplier;
                    EList refinedMemberEnds = refinedAssociation.getMemberEnds();
                    for (Property p : refinedMemberEnds) {
                        PropertyWrapper propertyWrapper = new PropertyWrapper(p);
                        if (!propertyWrapper.hasQualifiers()) continue;
                        result.add(propertyWrapper.getProperty());
                        continue block1;
                    }
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public boolean isChangedListener() {
        Stereotype changeListener = ModelLoader.INSTANCE.findStereotype("ChangeListener");
        return this.isStereotypeApplied(changeListener);
    }
}

