/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.javageneration.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.operations.ClassOperations;
import org.umlg.framework.ModelLoader;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJVisibilityKind;
import org.umlg.javageneration.util.DataTypeEnum;
import org.umlg.javageneration.util.Namer;
import org.umlg.javageneration.util.PropertyWrapper;
import org.umlg.javageneration.util.UmlgCollectionKindEnum;
import org.umlg.javageneration.util.UmlgInterfaceOperations;

public class UmlgClassOperations
extends ClassOperations {
    public static boolean hasLookupProperty(Class clazz) {
        Set<Property> properties = UmlgClassOperations.getAllProperties((Classifier)clazz);
        for (Property property : properties) {
            if (!new PropertyWrapper(property).hasLookup()) continue;
            return true;
        }
        return false;
    }

    public static Set<Property> getChildPropertiesToDelete(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        Set<Property> ownedProperties = UmlgClassOperations.getAllOwnedProperties((Classifier)clazz);
        for (Property p : ownedProperties) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || !pWrap.isComposite() && (pWrap.isPrimitive() || pWrap.isEnumeration() || pWrap.getOtherEnd() != null)) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getPropertiesToClearOnDeletion(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        Set<Property> ownedProperties = UmlgClassOperations.getAllOwnedProperties((Classifier)clazz);
        for (Property p : ownedProperties) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || pWrap.isComposite() || pWrap.isPrimitive() || pWrap.isEnumeration()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getOnePrimitiveOrEnumProperties(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : clazz.getAttributes()) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || !pWrap.isOne() || !pWrap.isPrimitive() && !pWrap.isEnumeration()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getPrimitiveOrEnumOrComponentsExcludeOneProperties(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : UmlgClassOperations.getAllOwnedProperties((Classifier)clazz)) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || pWrap.isQualifier() || !pWrap.isDataType() && !pWrap.isComponent()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getPropertiesThatHaveAndEdge(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : UmlgClassOperations.getAllOwnedProperties((Classifier)clazz)) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || pWrap.isQualifier() || !pWrap.isMany() && pWrap.isPrimitive()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getOneProperties(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : UmlgClassOperations.getAllOwnedProperties((Classifier)clazz)) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || pWrap.isQualifier() || pWrap.isDataType() || !pWrap.isComponent() && !pWrap.isOne() || pWrap.isOne() && pWrap.getOtherEnd() != null && pWrap.getOtherEnd().isComposite()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getNonCompositeRequiredManyProperties(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : UmlgClassOperations.getAllOwnedProperties((Classifier)clazz)) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || pWrap.isQualifier() || pWrap.isDataType() || pWrap.getLower() <= 0 || !pWrap.isMany() || pWrap.isComposite()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getNonCompositeProperties(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : UmlgClassOperations.getAllOwnedProperties((Classifier)clazz)) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isDerived() || pWrap.isQualifier() || pWrap.isComposite()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getPropertiesForToJson(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : UmlgClassOperations.getAllOwnedProperties((Classifier)clazz)) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isQualified()) continue;
            if (pWrap.isComponent() || pWrap.isDataType()) {
                result.add(p);
                continue;
            }
            if (pWrap.isDataType() || !pWrap.isOne()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getPropertiesForToJsonExcludingCompositeParent(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        for (Property p : UmlgClassOperations.getAllOwnedProperties((Classifier)clazz)) {
            PropertyWrapper pWrap = new PropertyWrapper(p);
            if (pWrap.isQualified()) continue;
            if (pWrap.isComponent() || pWrap.isDataType()) {
                if (pWrap.getOtherEnd() != null && pWrap.getOtherEnd().isComposite()) continue;
                result.add(p);
                continue;
            }
            if (pWrap.isDataType() || !pWrap.isOne() || pWrap.getOtherEnd() != null && pWrap.getOtherEnd().isComposite()) continue;
            result.add(p);
        }
        return result;
    }

    public static Set<Property> getAllOwnedProperties(Classifier clazz) {
        return UmlgClassOperations.filterOutRefinedProperties(UmlgClassOperations.getAllOwnedPropertiesIncludingRefinedAssociationMemberEnds(clazz));
    }

    public static Set<Property> getAllOwnedPropertiesIncludingRefinedAssociationMemberEnds(Classifier clazz) {
        HashSet<Property> result = new HashSet<Property>((Collection<Property>)clazz.getAttributes());
        EList associations = clazz.getAssociations();
        for (Association association : associations) {
            EList memberEnds = association.getMemberEnds();
            if (((Property)memberEnds.get(0)).getType().equals(clazz) && ((Property)memberEnds.get(1)).getType().equals(clazz)) {
                result.addAll((Collection<Property>)memberEnds);
                continue;
            }
            for (Property property : memberEnds) {
                if (property.getType() == clazz) continue;
                result.add(property);
            }
        }
        if (clazz instanceof Class) {
            result.addAll(UmlgClassOperations.getPropertiesOnRealizedInterfaces((Class)clazz));
        }
        return result;
    }

    public static Set<Property> getAllProperties(Classifier classifier) {
        HashSet<Property> result = new HashSet<Property>((Collection<Property>)classifier.getAllAttributes());
        Set<Association> associations = UmlgClassOperations.getAllAssociations(classifier);
        for (Association association : associations) {
            EList memberEnds = association.getMemberEnds();
            Property memberEnd1 = (Property)memberEnds.get(0);
            Property memberEnd2 = (Property)memberEnds.get(1);
            if (UmlgClassOperations.isSpecializationOf(classifier, memberEnd1.getType()) && UmlgClassOperations.isSpecializationOf(classifier, memberEnd2.getType())) {
                result.add(memberEnd1);
                result.add(memberEnd2);
            }
            if (!UmlgClassOperations.isSpecializationOf(classifier, memberEnd1.getType())) {
                result.add(memberEnd1);
            }
            if (UmlgClassOperations.isSpecializationOf(classifier, memberEnd2.getType())) continue;
            result.add(memberEnd2);
        }
        if (classifier instanceof Class) {
            result.addAll(UmlgClassOperations.getPropertiesOnRealizedInterfaces((Class)classifier));
        }
        return UmlgClassOperations.filterOutRefinedProperties(result);
    }

    private static Set<Property> filterOutRefinedProperties(Set<Property> result) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Property p : result) {
            if (new PropertyWrapper(p).isRefined()) continue;
            properties.add(p);
        }
        return properties;
    }

    private static List<Association> filterOutRefinedAssociation(List<Association> result) {
        ArrayList<Association> associations = new ArrayList<Association>();
        for (Association a : result) {
            if (ModelLoader.INSTANCE.isRefinedAssociation(a)) continue;
            associations.add(a);
        }
        return associations;
    }

    public static Set<Property> getPropertiesOnRealizedInterfaces(Class clazz) {
        HashSet<Property> result = new HashSet<Property>();
        EList interfaces = clazz.getImplementedInterfaces();
        for (Interface inf : interfaces) {
            Set<Property> properties = UmlgInterfaceOperations.getAllProperties(inf);
            for (Property p : properties) {
                result.add(p);
            }
        }
        return result;
    }

    public static Set<Property> getOtherEndToComposite(Classifier classifier) {
        HashSet<Property> compositeOwners = new HashSet<Property>();
        Set<Association> associations = UmlgClassOperations.getAllAssociations(classifier);
        for (Association association : associations) {
            EList memberEnds = association.getMemberEnds();
            for (Property property : memberEnds) {
                if (property.isComposite() || !property.getOtherEnd().isComposite() || !UmlgClassOperations.isSpecializationOf(classifier, property.getOtherEnd().getType())) continue;
                compositeOwners.add(property);
            }
        }
        return compositeOwners;
    }

    public static boolean isSpecializationOf(Classifier special, Type type) {
        if (special == type) {
            return true;
        }
        if (special instanceof BehavioredClassifier && ((BehavioredClassifier)special).getAllImplementedInterfaces().contains((Object)type)) {
            return true;
        }
        for (Classifier general : special.getGenerals()) {
            if (!UmlgClassOperations.isSpecializationOf(general, type)) continue;
            return true;
        }
        return false;
    }

    public static Set<Association> getAllAssociations(Classifier classifier) {
        HashSet<Association> result = new HashSet<Association>();
        if (classifier instanceof Class) {
            for (Interface implementedInterface : ((Class)classifier).getAllImplementedInterfaces()) {
                result.addAll(UmlgClassOperations.filterOutRefinedAssociation((List<Association>)implementedInterface.getAssociations()));
            }
        }
        UmlgClassOperations.getAllAssociationsFromGenerals(classifier, result);
        return result;
    }

    public static void getAllAssociationsFromGenerals(Classifier classifier, Set<Association> result) {
        result.addAll((Collection<Association>)classifier.getAssociations());
        for (Classifier general : classifier.getGenerals()) {
            UmlgClassOperations.getAllAssociationsFromGenerals(general, result);
        }
    }

    public static Set<OJPathName> getOtherEndToCompositePathName(Class clazz) {
        HashSet<OJPathName> result = new HashSet<OJPathName>();
        Set<Property> endsToComposite = UmlgClassOperations.getOtherEndToComposite((Classifier)clazz);
        for (Property p : endsToComposite) {
            result.add(UmlgClassOperations.getPathName(p.getType()));
        }
        return result;
    }

    public static OJPathName getPathName(Type type) {
        String className = Namer.name(type);
        String fullPackageName = Namer.name(type.getNearestPackage());
        OJPathName ojPathName = new OJPathName(fullPackageName + "." + className);
        return ojPathName;
    }

    public static boolean hasSupertype(Class clazz) {
        return !UmlgClassOperations.getConcreteGenerals((Classifier)clazz).isEmpty();
    }

    public static List<Class> getConcreteGenerals(Classifier clazz) {
        ArrayList<Class> result = new ArrayList<Class>();
        EList generals = clazz.getGenerals();
        for (Classifier classifier : generals) {
            if (!(classifier instanceof Class)) continue;
            result.add((Class)classifier);
        }
        return result;
    }

    private static void getConcreteImplementations(Set<Classifier> result, Classifier clazz) {
        if (!clazz.isAbstract() && !(clazz instanceof Interface)) {
            result.add(clazz);
        }
        List generalizations = ModelLoader.INSTANCE.getSpecifics(clazz);
        for (Generalization generalization : generalizations) {
            Classifier specific = generalization.getSpecific();
            UmlgClassOperations.getConcreteImplementations(result, specific);
        }
    }

    private static void internalGetSpecializations(Set<Classifier> result, Classifier clazz) {
        result.add(clazz);
        List generalizations = ModelLoader.INSTANCE.getSpecifics(clazz);
        for (Generalization generalization : generalizations) {
            Classifier specific = generalization.getSpecific();
            UmlgClassOperations.internalGetSpecializations(result, specific);
        }
    }

    public static Set<Classifier> getRealizationWithCompositeOwner(Interface inf) {
        HashSet<Classifier> result = new HashSet<Classifier>();
        List interfaceRealizations = ModelLoader.INSTANCE.getInterfaceRealization(inf);
        for (InterfaceRealization interfaceRealization : interfaceRealizations) {
            BehavioredClassifier c = interfaceRealization.getImplementingClassifier();
            if (!UmlgClassOperations.hasCompositeOwner((Classifier)c)) continue;
            result.add((Classifier)c);
        }
        return result;
    }

    public static Set<Classifier> getConcreteRealization(Classifier classifier) {
        if (classifier instanceof Interface) {
            return UmlgClassOperations.getConcreteRealizationForInterface((Interface)classifier);
        }
        return UmlgClassOperations.getConcreteRealizationForClass((Class)classifier);
    }

    private static Set<Classifier> getConcreteRealizationForInterface(Interface inf) {
        HashSet<Classifier> result = new HashSet<Classifier>();
        List interfaceRealizations = ModelLoader.INSTANCE.getInterfaceRealization(inf);
        for (InterfaceRealization interfaceRealization : interfaceRealizations) {
            BehavioredClassifier c = interfaceRealization.getImplementingClassifier();
            result.add((Classifier)c);
        }
        return result;
    }

    public static Set<Classifier> getConcreteRealizationForClass(Class clazz) {
        return UmlgClassOperations.getSpecializations((Classifier)clazz);
    }

    public static Set<Classifier> getRealizationWithoutCompositeOwner(Interface inf) {
        HashSet<Classifier> result = new HashSet<Classifier>();
        List interfaceRealizations = ModelLoader.INSTANCE.getInterfaceRealization(inf);
        for (InterfaceRealization interfaceRealization : interfaceRealizations) {
            BehavioredClassifier c = interfaceRealization.getImplementingClassifier();
            if (UmlgClassOperations.hasCompositeOwner((Classifier)c)) continue;
            result.add((Classifier)c);
        }
        return result;
    }

    public static Set<Classifier> getSpecializationWithCompositeOwner(Classifier clazz) {
        HashSet<Classifier> result = new HashSet<Classifier>();
        Set<Classifier> specializations = UmlgClassOperations.getSpecializations(clazz);
        for (Classifier c : specializations) {
            if (!UmlgClassOperations.hasCompositeOwner(c)) continue;
            result.add(c);
        }
        return result;
    }

    public static Set<Classifier> getConcreteSpecializationsWithoutCompositeOwner(Classifier clazz) {
        HashSet<Classifier> result = new HashSet<Classifier>();
        Set<Classifier> specializations = UmlgClassOperations.getSpecializations(clazz);
        for (Classifier c : specializations) {
            if (c.isAbstract() || !(c instanceof Class) || UmlgClassOperations.hasCompositeOwner((Classifier)((Class)c))) continue;
            result.add((Classifier)((Class)c));
        }
        return result;
    }

    public static Set<Classifier> getSpecializations(Classifier clazz) {
        HashSet<Classifier> result = new HashSet<Classifier>();
        UmlgClassOperations.internalGetSpecializations(result, clazz);
        result.remove(clazz);
        return result;
    }

    public static SortedSet<Classifier> getConcreteImplementations(Classifier clazz) {
        TreeSet<Classifier> result = new TreeSet<Classifier>(new Comparator<Classifier>(){

            @Override
            public int compare(Classifier o1, Classifier o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        UmlgClassOperations.getConcreteImplementations(result, clazz);
        if (clazz instanceof Interface) {
            result.addAll(UmlgClassOperations.getConcreteRealization((Classifier)((Interface)clazz)));
        }
        return result;
    }

    public static boolean hasCompositeOwner(Classifier classifier) {
        return !UmlgClassOperations.getOtherEndToComposite(classifier).isEmpty();
    }

    public static String className(Classifier clazz) {
        if (clazz instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)clazz;
            StringBuilder sb = new StringBuilder();
            sb.append(UmlgCollectionKindEnum.from(collectionType.getKind()).getOjPathName().getLast());
            sb.append("<");
            sb.append(UmlgClassOperations.className((Classifier)collectionType.getElementType()));
            sb.append(">");
            return sb.toString();
        }
        if (!(clazz instanceof PrimitiveType) && !(clazz instanceof Enumeration) && clazz instanceof DataType) {
            return DataTypeEnum.getPathNameFromDataType((DataType)clazz).getLast();
        }
        return Namer.name((Type)clazz);
    }

    public static String getMetaClassName(Classifier clazz) {
        if (clazz instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)clazz;
            StringBuilder sb = new StringBuilder();
            sb.append(UmlgCollectionKindEnum.from(collectionType.getKind()).getOjPathName().getLast());
            sb.append("<");
            sb.append(UmlgClassOperations.className((Classifier)collectionType.getElementType()));
            sb.append(">");
            return sb.toString();
        }
        return Namer.getMetaName((Type)clazz);
    }

    public static OJPathName getMetaClassPathName(Classifier clazz) {
        OJPackage ojPackage = new OJPackage(Namer.name(clazz.getNearestPackage()) + ".meta");
        OJPathName result = ojPackage.getPathName().append(UmlgClassOperations.getMetaClassName(clazz));
        return result;
    }

    public static String propertyEnumName(Type type) {
        return Namer.name(type) + "RuntimePropertyEnum";
    }

    public static OJVisibilityKind getVisibility(VisibilityKind visibility) {
        switch (visibility) {
            case PRIVATE_LITERAL: {
                return OJVisibilityKind.PRIVATE;
            }
            case PROTECTED_LITERAL: {
                return OJVisibilityKind.PROTECTED;
            }
            case PUBLIC_LITERAL: {
                return OJVisibilityKind.PUBLIC;
            }
            case PACKAGE_LITERAL: {
                return OJVisibilityKind.DEFAULT;
            }
        }
        throw new RuntimeException("Not supported");
    }

    public static boolean isRoot(Class clazz) {
        return false;
    }

    public static OJPathName getAuditPathName(Class c) {
        OJPathName pathName = UmlgClassOperations.getPathName((Type)c);
        return pathName.renameLast(pathName.getLast() + "Audit");
    }

    public static Property getAttribute(Class c, String name) {
        for (Property p : c.getAllAttributes()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static boolean isOnInterface(PropertyWrapper pWrap) {
        return pWrap.getOwningType() instanceof Interface;
    }

    public static boolean isHierarchy(Class clazz) {
        if (UmlgClassOperations.realizesHierarchy(clazz)) {
            return true;
        }
        EList generals = UmlgClassOperations.getGenerals((Classifier)clazz);
        for (Classifier general : generals) {
            if (!UmlgClassOperations.realizesHierarchy((Class)general)) continue;
            return true;
        }
        return false;
    }

    private static boolean realizesHierarchy(Class clazz) {
        EList realizedInterfaces = clazz.getImplementedInterfaces();
        for (Interface interface1 : realizedInterfaces) {
            if (!interface1.getQualifiedName().equals("umlglib::org::umlg::hierarchy::Hierarchy")) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnumeration(Type owningType) {
        return owningType instanceof Enumeration;
    }

    public static String checkClassConstraintName(Constraint constraint) {
        return "checkClassConstraint" + StringUtils.capitalize((String)constraint.getName());
    }

    public static boolean isAssociationClass(Class clazz) {
        return clazz instanceof AssociationClass;
    }

    public static List<Classifier> getGeneralizationHierarchy(Class clazz) {
        ArrayList<Classifier> result = new ArrayList<Classifier>();
        result.add((Classifier)clazz);
        UmlgClassOperations.getGeneralizationHierarchy(result, (Classifier)clazz);
        return result;
    }

    private static void getGeneralizationHierarchy(List<Classifier> hierarchy, Classifier clazz) {
        EList generals = clazz.getGenerals();
        if (generals.size() > 1) {
            throw new IllegalStateException(String.format("Multiple inheritance is not supported! Class %s has more than on generalization.", clazz.getName()));
        }
        if (!generals.isEmpty()) {
            hierarchy.add((Classifier)generals.get(0));
            UmlgClassOperations.getGeneralizationHierarchy(hierarchy, (Classifier)generals.get(0));
        }
    }
}

