/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.javageneration.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.internal.operations.OperationOperations;
import org.umlg.javageneration.util.UmlgGenerationUtil;
import org.umlg.javageneration.util.UmlgMultiplicityOperations;

public class UmlgOperationOperations
extends OperationOperations {
    public static String asOclSignature(Operation oper) {
        StringBuilder sb = new StringBuilder();
        sb.append(oper.getClass_().getName());
        sb.append("::");
        sb.append(oper.getName());
        sb.append("(");
        List<Parameter> parametersExceptReturn = UmlgOperationOperations.getParametersExceptReturn(oper);
        int count = 1;
        for (Parameter param : parametersExceptReturn) {
            sb.append(param.getName());
            sb.append(": ");
            sb.append(param.getType().getQualifiedName());
            if (count++ == parametersExceptReturn.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        Parameter returnResult = oper.getReturnResult();
        if (returnResult != null) {
            sb.append(" : ");
            if (UmlgMultiplicityOperations.isMany((MultiplicityElement)returnResult)) {
                sb.append(UmlgGenerationUtil.getCollectionInterface((MultiplicityElement)returnResult));
                sb.append("(");
                sb.append(returnResult.getType().getQualifiedName());
                sb.append(")");
            } else {
                sb.append(returnResult.getType().getQualifiedName());
            }
        }
        return sb.toString();
    }

    public static List<Parameter> getParametersExceptReturn(Operation oper) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Parameter param : oper.getOwnedParameters()) {
            if (param.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
            result.add(param);
        }
        return result;
    }
}

