/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.javageneration.validation;

import org.umlg.java.metamodel.OJPathName;
import org.umlg.javageneration.validation.Validation;

public class RangeDouble
implements Validation {
    private Number min;
    private Number max;

    public RangeDouble(Number min, Number max) {
        this.min = min;
        this.max = max;
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    @Override
    public String toStringForMethod() {
        return this.getMin().toString() + "D, " + this.getMax().toString() + "D";
    }

    @Override
    public String toNewRuntimeTumlValidation() {
        return "new RangeDouble(" + this.min.toString() + "D, " + this.max.toString() + "D)";
    }

    @Override
    public OJPathName getPathName() {
        return new OJPathName("org.umlg.runtime.validation.RangeDouble");
    }

    @Override
    public String toJson() {
        return "\\\"range\\\": {\\\"min\\\": " + String.valueOf(this.min) + ", \\\"max\\\": " + String.valueOf(this.max) + "}";
    }
}

