/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.javageneration.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.internal.operations.InterfaceOperations;
import org.umlg.javageneration.util.UmlgClassOperations;

public class UmlgInterfaceOperations
extends InterfaceOperations {
    public static boolean hasCompositeOwner(Interface inf) {
        return UmlgInterfaceOperations.getOtherEndToComposite(inf) != null;
    }

    public static Property getOtherEndToComposite(Interface inf) {
        Set<Association> associations = UmlgInterfaceOperations.getAllAssociations(inf);
        for (Association association : associations) {
            EList memberEnds = association.getMemberEnds();
            for (Property property : memberEnds) {
                if (property.isComposite() || property.getType() == inf || !property.getOtherEnd().isComposite() || !UmlgClassOperations.isSpecializationOf((Classifier)inf, property.getOtherEnd().getType())) continue;
                return property;
            }
        }
        return null;
    }

    public static Set<Association> getAllAssociations(Interface inf) {
        HashSet<Association> result = new HashSet<Association>();
        UmlgClassOperations.getAllAssociationsFromGenerals((Classifier)inf, result);
        return result;
    }

    public static Set<Property> getAllProperties(Interface inf) {
        HashSet<Property> result = new HashSet<Property>();
        result.addAll((Collection<Property>)inf.getAllAttributes());
        Set<Association> associations = UmlgInterfaceOperations.getAllAssociations(inf);
        for (Association association : associations) {
            EList memberEnds = association.getMemberEnds();
            for (Property property : memberEnds) {
                if (UmlgClassOperations.isSpecializationOf((Classifier)inf, property.getType())) continue;
                result.add(property);
            }
        }
        return result;
    }
}

