/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.javageneration.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.internal.operations.PropertyOperations;
import org.umlg.framework.ModelLoader;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJSimpleStatement;
import org.umlg.javageneration.util.DataTypeEnum;
import org.umlg.javageneration.util.Namer;
import org.umlg.javageneration.util.PropertyWrapper;
import org.umlg.javageneration.util.UmlgClassOperations;
import org.umlg.javageneration.util.UmlgCollectionKindEnum;
import org.umlg.javageneration.util.UmlgGenerationUtil;
import org.umlg.javageneration.util.UmlgMultiplicityOperations;

public final class UmlgPropertyOperations
extends PropertyOperations {
    public static List<Constraint> getConstraints(Property p) {
        return ModelLoader.INSTANCE.getConstraintsForConstrainedElement((Element)p);
    }

    public static Type getOwningType(Property p) {
        Element owner = p.getOwner();
        if (owner instanceof Association) {
            Association a = (Association)owner;
            EList members = a.getMemberEnds();
            if (!members.contains(p)) {
                if (!(owner instanceof AssociationClass)) {
                    throw new IllegalStateException("Expected owner to be an association class");
                }
                return (AssociationClass)owner;
            }
            Property otherEnd = null;
            for (Property member : members) {
                if (member == p) continue;
                otherEnd = member;
                break;
            }
            if (otherEnd == null) {
                throw new IllegalStateException("Oy, where is the other end gone to!!!");
            }
            return otherEnd.getType();
        }
        if (owner instanceof Classifier) {
            return (Classifier)owner;
        }
        if (owner instanceof Property && UmlgPropertyOperations.isQualifier(p)) {
            throw new IllegalStateException("Property is a qualifier, this method can not be called for qualifiers");
        }
        throw new IllegalStateException("Not catered for, think about ne. " + owner.getClass().getSimpleName());
    }

    public static boolean isUnqualifiedOne(Property property) {
        return !UmlgPropertyOperations.isUnqualifiedMany(property);
    }

    public static boolean isUnqualifiedMany(Property property) {
        return UmlgMultiplicityOperations.isMany((MultiplicityElement)property);
    }

    public static boolean isOne(Property property) {
        return !UmlgPropertyOperations.isMany(property);
    }

    public static boolean isQualifier(Property p) {
        return p.getOwner() != null && p.getOwner() instanceof Property;
    }

    public static String fieldName(Property p) {
        return StringUtils.uncapitalize((String)p.getName());
    }

    public static boolean isPrimitive(Property property) {
        return property.getType() instanceof PrimitiveType;
    }

    public static boolean isEnumeration(Property property) {
        return property.getType() instanceof Enumeration;
    }

    public static boolean isControllingSide(Property p) {
        boolean result = p.isComposite();
        if (p.getOtherEnd() == null) {
            result = true;
        } else if (UmlgPropertyOperations.isOneToOne(p) && !p.isComposite() && !p.getOtherEnd().isComposite()) {
            result = p.getLower() == 0 && p.getOtherEnd().getLower() == 0 || p.getLower() == 1 && p.getOtherEnd().getLower() == 1 ? p.getName().compareTo(p.getOtherEnd().getName()) > -1 : p.getLower() == 1 && p.getUpper() == 1;
        } else if (UmlgPropertyOperations.isOneToMany(p) && !p.isComposite() && !p.getOtherEnd().isComposite()) {
            result = true;
        } else if (UmlgPropertyOperations.isManyToMany(p) && !p.isComposite() && !p.getOtherEnd().isComposite()) {
            result = 0 > p.getName().compareTo(p.getOtherEnd().getName());
        }
        return result;
    }

    public static boolean isOneToMany(Property p) {
        return UmlgPropertyOperations.otherEndIsOne(p) && UmlgPropertyOperations.isMany(p);
    }

    public static boolean isManyToMany(Property p) {
        return !UmlgPropertyOperations.otherEndIsOne(p) && UmlgPropertyOperations.isMany(p);
    }

    public static boolean isManyToOne(Property p) {
        return !UmlgPropertyOperations.otherEndIsOne(p) && UmlgPropertyOperations.isOne(p);
    }

    public static boolean isMany(Property property) {
        int qualifierCount = property.getQualifiers().size();
        return UmlgMultiplicityOperations.isMany((MultiplicityElement)property) || qualifierCount > 0;
    }

    public static boolean isOneToOne(Property p) {
        return UmlgPropertyOperations.otherEndIsOne(p) && UmlgPropertyOperations.isOne(p);
    }

    protected static boolean otherEndIsOne(Property p) {
        if (p.getOtherEnd() != null) {
            Property otherEnd = p.getOtherEnd();
            return UmlgPropertyOperations.isOne(otherEnd) && otherEnd.getQualifiers().size() == 0;
        }
        return false;
    }

    public static OJPathName getDefaultTinkerCollection(Property p) {
        return UmlgPropertyOperations.getDefaultTinkerCollection(p, false);
    }

    public static OJPathName getDefaultTinkerCollection(Property p, boolean ignoreAssociationClass) {
        OJPathName collectionPathName;
        PropertyWrapper pWrap = new PropertyWrapper(p);
        if (p.isOrdered() && p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_ORDERED_SET.getImplementationPathName() : (ignoreAssociationClass || !pWrap.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.ORDERED_SET.getImplementationPathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_ORDERED_SET.getImplementationPathName());
        } else if (p.isOrdered() && !p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_SEQUENCE.getImplementationPathName() : (ignoreAssociationClass || !pWrap.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.SEQUENCE.getImplementationPathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_SEQUENCE.getImplementationPathName());
        } else if (!p.isOrdered() && !p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_BAG.getImplementationPathName() : (ignoreAssociationClass || !pWrap.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.BAG.getImplementationPathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_BAG.getImplementationPathName());
        } else if (!p.isOrdered() && p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_SET.getImplementationPathName() : (ignoreAssociationClass || !pWrap.isMemberOfAssociationClass() ? UmlgCollectionKindEnum.SET.getImplementationPathName() : UmlgCollectionKindEnum.ASSOCIATION_CLASS_SET.getImplementationPathName());
        } else {
            throw new RuntimeException("wtf");
        }
        collectionPathName.addToGenerics(UmlgPropertyOperations.getTypePath(p));
        if (!ignoreAssociationClass && pWrap.isMemberOfAssociationClass()) {
            collectionPathName.addToGenerics(pWrap.getAssociationClassPathName());
        }
        return collectionPathName;
    }

    public static OJPathName getDefaultTinkerCollectionForAssociationClass(Property p) {
        OJPathName collectionPathName;
        if (p.isOrdered() && p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_ORDERED_SET.getImplementationPathName() : UmlgCollectionKindEnum.AC_ORDERED_SET.getImplementationPathName();
        } else if (p.isOrdered() && !p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_SEQUENCE.getImplementationPathName() : UmlgCollectionKindEnum.AC_SEQUENCE.getImplementationPathName();
        } else if (!p.isOrdered() && !p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_BAG.getImplementationPathName() : UmlgCollectionKindEnum.AC_BAG.getImplementationPathName();
        } else if (!p.isOrdered() && p.isUnique()) {
            collectionPathName = !p.getQualifiers().isEmpty() ? UmlgCollectionKindEnum.QUALIFIED_SET.getImplementationPathName() : UmlgCollectionKindEnum.AC_SET.getImplementationPathName();
        } else {
            throw new RuntimeException("wtf");
        }
        collectionPathName.addToGenerics(new PropertyWrapper(p).getAssociationClassPathName());
        return collectionPathName;
    }

    public static OJSimpleStatement getDefaultTinkerCollectionInitalisation(Property p, BehavioredClassifier propertyConcreteOwner) {
        return UmlgPropertyOperations.getDefaultTinkerCollectionInitalisation(p, (Classifier)propertyConcreteOwner, false);
    }

    static OJSimpleStatement getDefaultTinkerCollectionInitalisation(Property p, Classifier propertyConcreteOwner, boolean ignoreAssociationClass) {
        OJSimpleStatement s = UmlgPropertyOperations.getDefaultTinkerCollectionInitalisation(p, propertyConcreteOwner, UmlgPropertyOperations.getDefaultTinkerCollection(p, ignoreAssociationClass));
        return s;
    }

    static OJSimpleStatement getDefaultTinkerCollectionInitalisationForAssociationClass(Property p, Classifier propertyConcreteOwner, boolean withLoaded) {
        return UmlgPropertyOperations.getDefaultTinkerCollectionInitalisationForAssociationClass(p, propertyConcreteOwner, UmlgPropertyOperations.getDefaultTinkerCollectionForAssociationClass(p), withLoaded);
    }

    private static OJSimpleStatement getDefaultTinkerCollectionInitalisation(Property p, Classifier propertyConcreteOwner, OJPathName collectionPathName) {
        OJSimpleStatement ojSimpleStatement = new OJSimpleStatement(" new " + collectionPathName.getCollectionTypeName() + "(this");
        ojSimpleStatement.setExpression(ojSimpleStatement.getExpression() + ", " + UmlgGenerationUtil.PropertyTree.getLast() + ".from(" + UmlgClassOperations.propertyEnumName((Type)propertyConcreteOwner) + "." + new PropertyWrapper(p).fieldname() + "), loaded");
        if (new PropertyWrapper(p).isMemberOfAssociationClass() && !(propertyConcreteOwner instanceof AssociationClass)) {
            ojSimpleStatement.setExpression(ojSimpleStatement.getExpression() + ", " + UmlgGenerationUtil.PropertyTree.getLast() + ".from(" + UmlgClassOperations.propertyEnumName((Type)propertyConcreteOwner) + "." + new PropertyWrapper(p).getAssociationClassFakePropertyName() + "), loaded");
        }
        ojSimpleStatement.setExpression(ojSimpleStatement.getExpression() + ")");
        return ojSimpleStatement;
    }

    private static OJSimpleStatement getDefaultTinkerCollectionInitalisationForAssociationClass(Property p, Classifier propertyConcreteOwner, OJPathName collectionPathName, boolean withLoaded) {
        OJSimpleStatement ojSimpleStatement = new OJSimpleStatement(" new " + collectionPathName.getCollectionTypeName() + "(this");
        if (withLoaded) {
            ojSimpleStatement.setExpression(ojSimpleStatement.getExpression() + ", " + UmlgGenerationUtil.PropertyTree.getLast() + ".from(" + UmlgClassOperations.propertyEnumName((Type)propertyConcreteOwner) + "." + new PropertyWrapper(p).fieldname() + "), " + UmlgGenerationUtil.PropertyTree.getLast() + ".from(" + UmlgClassOperations.propertyEnumName((Type)propertyConcreteOwner) + "." + new PropertyWrapper(p).getAssociationClassFakePropertyName() + "), loaded");
        } else {
            ojSimpleStatement.setExpression(ojSimpleStatement.getExpression() + ", " + UmlgGenerationUtil.PropertyTree.getLast() + ".from(" + UmlgClassOperations.propertyEnumName((Type)propertyConcreteOwner) + "." + new PropertyWrapper(p).fieldname() + "), " + UmlgGenerationUtil.PropertyTree.getLast() + ".from(" + UmlgClassOperations.propertyEnumName((Type)propertyConcreteOwner) + "." + new PropertyWrapper(p).getAssociationClassFakePropertyName() + ")");
        }
        ojSimpleStatement.setExpression(ojSimpleStatement.getExpression() + ")");
        return ojSimpleStatement;
    }

    public static OJPathName getTypePath(Property p) {
        Objects.requireNonNull(p.getType(), "property " + p.getName() + "'s type is not defined");
        if (!(p.getType() instanceof PrimitiveType) && !(p.getType() instanceof Enumeration) && p.getType() instanceof DataType) {
            return DataTypeEnum.getPathNameFromDataType((DataType)p.getType());
        }
        return new OJPathName(Namer.name(p.getType().getNearestPackage()) + "." + UmlgPropertyOperations.umlPrimitiveTypeToJava(p.getType()));
    }

    public static String umlPrimitiveTypeToJava(Type type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            if (primitiveType.getName().equals("String")) {
                return "String";
            }
            if (primitiveType.getName().equals("Integer") || primitiveType.getName().equals("int")) {
                return "Integer";
            }
            if (primitiveType.getName().equals("Boolean") || primitiveType.getName().equals("boolean")) {
                return "Boolean";
            }
            if (primitiveType.getName().equals("UnlimitedNatural")) {
                return "Integer";
            }
            if (primitiveType.getName().equals("long")) {
                return "Long";
            }
            if (primitiveType.getName().equals("float")) {
                return "Float";
            }
            if (primitiveType.getName().equals("Real") || primitiveType.getName().equals("double")) {
                return "Double";
            }
            if (primitiveType.getName().equals("byte")) {
                return "Byte";
            }
            throw new IllegalStateException("unknown primitive " + primitiveType.getName());
        }
        if (type instanceof DataType) {
            if (type instanceof Enumeration) {
                return type.getName();
            }
            DataType dataType = (DataType)type;
            OJPathName dataTypePathName = DataTypeEnum.getPathNameFromDataType(dataType);
            if (dataTypePathName != null) {
                return dataTypePathName.getLast();
            }
            throw new IllegalStateException("Unknown datatype " + type.getName());
        }
        return type.getName();
    }

    public static String finder(Property property) {
        return "findBy" + StringUtils.capitalize((String)property.getName());
    }

    public static String getter(Property property) {
        return "get" + StringUtils.capitalize((String)property.getName());
    }

    public static String internalGetter(Property property) {
        return "z_internal_get" + StringUtils.capitalize((String)property.getName());
    }

    public static String setter(Property property) {
        return "set" + StringUtils.capitalize((String)property.getName());
    }

    public static String internalSetter(Property property) {
        return "z_internal_set" + StringUtils.capitalize((String)property.getName());
    }

    public static String validator(Property property) {
        return "validate" + StringUtils.capitalize((String)property.getName());
    }

    public static String checkConstraint(Property property, Constraint constraint) {
        return "checkConstraintForProperty" + StringUtils.capitalize((String)(property.getName() + "AndConstraint" + StringUtils.capitalize((String)constraint.getName())));
    }

    public static String adder(Property property) {
        return "addTo" + StringUtils.capitalize((String)property.getName());
    }

    public static String remover(Property property) {
        return "removeFrom" + StringUtils.capitalize((String)property.getName());
    }

    public static String clearer(Property property) {
        return "clear" + StringUtils.capitalize((String)property.getName());
    }

    public static String internalAdder(Property property) {
        return "z_internalAddTo" + StringUtils.capitalize((String)property.getName());
    }

    public static String internalRemover(Property property) {
        return "z_internalRemoveFrom" + StringUtils.capitalize((String)property.getName());
    }

    public static boolean validateRedefinedPropertyInherited(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Property redefiningProperty = (Property)context.get("redefiningProperty");
        HashSet redefinedContextAllParents = new HashSet();
        for (Classifier redefinedContext : redefiningProperty.getRedefinitionContexts()) {
            redefinedContextAllParents.addAll(redefinedContext.allParents());
        }
        HashSet redefinedContextAllFeatures = new HashSet();
        for (Classifier contextParent : redefinedContextAllParents) {
            redefinedContextAllFeatures.addAll(contextParent.allFeatures());
        }
        if (!redefinedContextAllFeatures.contains(property)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2.uml", 45, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"validateRedefinedPropertyInherited", EObjectValidator.getObjectLabel((EObject)property, context)}), new Object[]{property}));
            }
            return false;
        }
        return true;
    }
}

