/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.umlg.java.metamodel.OJBlock;
import org.umlg.java.metamodel.OJField;
import org.umlg.java.metamodel.OJForStatement;
import org.umlg.java.metamodel.OJIfStatement;
import org.umlg.java.metamodel.OJOperation;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJStatement;
import org.umlg.java.metamodel.OJSwitchCase;
import org.umlg.java.metamodel.OJSwitchStatement;
import org.umlg.java.metamodel.OJTryStatement;
import org.umlg.java.metamodel.OJWhileStatement;
import org.umlg.java.metamodel.annotation.OJAnnotatedOperation;
import org.umlg.java.metamodel.generated.OJClassifierGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;
import org.umlg.java.metamodel.utilities.OJOperationComparator;
import org.umlg.java.metamodel.utilities.OJPathNameComparator;

public class OJClassifier
extends OJClassifierGEN {
    boolean isInnerClass = false;
    protected OJPackage f_myPackage;
    protected String suffix;

    public void calcImports() {
        for (OJOperation oper : this.getOperations()) {
            this.addAll(oper.getParamTypes());
            this.addToImports(oper.getReturnType());
            this.addImportsRecursively(oper.getBody());
        }
    }

    public OJOperation getUniqueOperation(String name) {
        Set<OJOperation> set = this.f_operations.get(name);
        if (set != null && set.size() == 1) {
            return set.iterator().next();
        }
        return null;
    }

    protected void addImportsRecursively(OJBlock body) {
        if (body != null) {
            for (OJField ojField : body.getLocals()) {
                this.addToImports(ojField.getType());
            }
            for (OJStatement s : body.getStatements()) {
                if (s instanceof OJIfStatement) {
                    this.addImportsRecursively(((OJIfStatement)s).getThenPart());
                    this.addImportsRecursively(((OJIfStatement)s).getElsePart());
                    continue;
                }
                if (s instanceof OJBlock) {
                    this.addImportsRecursively((OJBlock)s);
                    continue;
                }
                if (s instanceof OJTryStatement) {
                    this.addImportsRecursively(((OJTryStatement)s).getTryPart());
                    this.addImportsRecursively(((OJTryStatement)s).getCatchPart());
                    continue;
                }
                if (s instanceof OJWhileStatement) {
                    this.addImportsRecursively(((OJWhileStatement)s).getBody());
                    continue;
                }
                if (s instanceof OJForStatement) {
                    this.addImportsRecursively(((OJForStatement)s).getBody());
                    this.addToImports(((OJForStatement)s).getElemType());
                    continue;
                }
                if (!(s instanceof OJSwitchStatement)) continue;
                for (OJSwitchCase ojSwitchCase : ((OJSwitchStatement)s).getCases()) {
                    this.addImportsRecursively(ojSwitchCase.getBody());
                }
            }
        }
    }

    private void addAll(List<OJPathName> types) {
        for (OJPathName type : types) {
            if (type == null) continue;
            this.addToImports(type);
            if (type.getElementTypes().isEmpty()) continue;
            this.addAll(type.getElementTypes());
        }
    }

    @Override
    public void addToImports(OJPathName path) {
        block10: {
            if (path == null) {
                return;
            }
            if (path.isSingleName() || path.getLast().equals("void") || path.getHead().equals(new OJPathName("java.lang")) || path.getLast().equals("int") || path.getLast().equals("Integer") || path.getLast().equals("String") || path.getLast().equals("Boolean") || path.getLast().equals("boolean") || path.getLast().equals("float") || path.getLast().equals("Object")) break block10;
            if (path.getLast().charAt(path.getLast().length() - 1) == '>') {
                String lastEntry = path.getLast();
                try {
                    lastEntry = lastEntry.substring(0, lastEntry.indexOf("<"));
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.out.print("");
                }
                OJPathName path2 = path.getCopy().getHead();
                path2.addToNames(lastEntry);
                this.addToImports(path2);
                for (OJPathName generic : path.getGenerics()) {
                    this.addToImports(generic);
                }
            } else if (path.getLast().charAt(path.getLast().length() - 1) == ']') {
                String lastEntry = path.getLast();
                lastEntry = lastEntry.substring(0, lastEntry.length() - 2);
                OJPathName path2 = path.getCopy().getHead();
                path2.addToNames(lastEntry);
                this.addToImports(path2);
            } else {
                super.addToImports(path);
                if (!path.getElementTypes().isEmpty()) {
                    this.addAll(path.getElementTypes());
                }
                for (OJPathName generic : path.getGenerics()) {
                    this.addToImports(generic);
                }
            }
        }
    }

    public void addToImports(String pathName) {
        if (pathName == null) {
            return;
        }
        OJPathName path = new OJPathName(pathName);
        this.addToImports(path);
    }

    @Override
    public int getUniqueNumber() {
        int i = super.getUniqueNumber() + 1;
        super.setUniqueNumber(i);
        return i;
    }

    @Override
    public OJOperation findToString() {
        OJOperation result = null;
        for (OJOperation oper : this.getOperations()) {
            if (!oper.getName().equals("toString")) continue;
            result = oper;
        }
        return result;
    }

    @Override
    public OJOperation findIdentOper() {
        OJOperation result = null;
        for (OJOperation oper : this.getOperations()) {
            if (!oper.getName().equals("getIdentifyingString")) continue;
            result = oper;
        }
        return result;
    }

    protected void addJavaDocComment(StringBuilder result) {
        String comment = JavaStringHelpers.firstCharToUpper(this.getComment());
        result.append("/** " + comment);
        result.append("\n */\n");
    }

    protected StringBuilder operations() {
        ArrayList<OJOperation> temp = new ArrayList<OJOperation>(this.getOperations());
        Collections.sort(temp, new OJOperationComparator());
        StringBuilder result = new StringBuilder();
        result.append(JavaUtil.collectionToJavaString(temp, "\n"));
        return result;
    }

    protected StringBuilder imports() {
        TreeSet<OJPathName> myImports = new TreeSet<OJPathName>(new OJPathNameComparator());
        myImports.addAll(this.getImports());
        StringBuilder result = new StringBuilder();
        Iterator it = myImports.iterator();
        String prevPackageName = "";
        while (it.hasNext()) {
            OJPathName path = (OJPathName)it.next();
            if (!this.isInnerClass && this.getMyPackage().getPathName().equals(path.getHead())) continue;
            if (!path.getFirst().equals(prevPackageName)) {
                result.append("\n");
            }
            result.append("import " + path.toString() + ";\n");
            prevPackageName = path.getFirst();
        }
        return result;
    }

    public OJAnnotatedOperation findOperation(String name) {
        return (OJAnnotatedOperation)this.findOperation(name, Collections.emptyList());
    }

    @Override
    public OJOperation findOperation(String name, List<OJPathName> types) {
        OJOperation result = null;
        for (OJOperation elem : this.getOperations()) {
            if (!elem.isEqual(name, (List)types)) continue;
            return elem;
        }
        return result;
    }

    public void copyDeepInfoInto(OJClassifier copy) {
        super.copyDeepInfoInto(copy);
        copy.setUniqueNumber(this.getUniqueNumber());
        copy.setDerived(this.isDerived());
        copy.setAbstract(this.isAbstract());
        for (OJOperation elem : new ArrayList<OJOperation>(this.getOperations())) {
            copy.addToOperations(elem.getDeepCopy());
        }
        for (OJPathName elem : new ArrayList<OJPathName>(this.getImports())) {
            copy.addToImports(elem.getCopy());
        }
    }

    @Override
    public String getName() {
        if (this.suffix != null) {
            return super.getName() + this.suffix;
        }
        return super.getName();
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String suffix) {
        if (renamePathNames.contains(this.getPathName())) {
            this.suffix = suffix;
        }
        HashSet<OJPathName> newImports = new HashSet<OJPathName>();
        Set<OJPathName> imports = this.getImports();
        for (OJPathName ojPathName : imports) {
            OJPathName newImport = ojPathName.getDeepCopy();
            newImport.renameAll(renamePathNames, suffix);
            newImports.add(newImport);
        }
        this.setImports(newImports);
        Set<OJOperation> operations = this.getOperations();
        for (OJOperation ojOperation : operations) {
            ojOperation.renameAll(renamePathNames, suffix);
        }
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public void setInnerClass(boolean isInnerClass) {
        this.isInnerClass = isInnerClass;
    }
}

