/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.umlg.java.metamodel.OJBlock;
import org.umlg.java.metamodel.OJClass;
import org.umlg.java.metamodel.OJConstructor;
import org.umlg.java.metamodel.OJField;
import org.umlg.java.metamodel.OJOperation;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJParameter;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.OJStatement;
import org.umlg.java.metamodel.annotation.AnnotationHelper;
import org.umlg.java.metamodel.annotation.OJAnnotatedElement;
import org.umlg.java.metamodel.annotation.OJAnnotatedOperation;
import org.umlg.java.metamodel.annotation.OJAnnotationValue;
import org.umlg.java.metamodel.annotation.OJEnum;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;
import org.umlg.java.metamodel.utilities.OJOperationComparator;

public class OJAnnotatedClass
extends OJClass
implements OJAnnotatedElement {
    Map<OJPathName, OJAnnotationValue> f_annotations = new TreeMap<OJPathName, OJAnnotationValue>();
    private List<String> genericTypeParams = new ArrayList<String>();
    private List<OJEnum> innerEnums = new ArrayList<OJEnum>();
    private OJBlock staticBlock = new OJBlock();

    public OJAnnotatedClass(String string) {
        this.setName(string);
    }

    public void organizeImports() {
    }

    public OJAnnotatedOperation findOperation(String name, OJPathName ... pathNames) {
        return (OJAnnotatedOperation)super.findOperation(name, Arrays.asList(pathNames));
    }

    @Override
    public OJAnnotationValue findAnnotation(OJPathName path) {
        return AnnotationHelper.getAnnotation(this, path);
    }

    @Override
    public boolean addAnnotationIfNew(OJAnnotationValue value) {
        if (this.f_annotations.containsKey(value.getType())) {
            return false;
        }
        this.putAnnotation(value);
        return true;
    }

    @Override
    public Collection<OJAnnotationValue> getAnnotations() {
        return this.f_annotations.values();
    }

    @Override
    public void release() {
        super.release();
        this.f_annotations.clear();
        this.genericTypeParams.clear();
    }

    @Override
    public OJAnnotationValue putAnnotation(OJAnnotationValue value) {
        return this.f_annotations.put(value.getType(), value);
    }

    @Override
    public OJAnnotationValue removeAnnotation(OJPathName type) {
        return this.f_annotations.remove(type);
    }

    public OJConstructor findConstructor(OJPathName ... parameter1) {
        List<OJPathName> pathNames = Arrays.asList(parameter1);
        return this.findConstructor(pathNames);
    }

    public OJConstructor findConstructor(OJPathName parameter1) {
        List<OJPathName> pathnames = Collections.singletonList(parameter1);
        return this.findConstructor(pathnames);
    }

    public OJConstructor findConstructor(List<OJPathName> pathnames) {
        for (OJConstructor con : this.getConstructors()) {
            if (!OJAnnotatedClass.isMatch(pathnames, con.getParamTypes())) continue;
            return con;
        }
        return null;
    }

    private static boolean isMatch(List<OJPathName> pathnames, List<OJPathName> paramTypes) {
        if (paramTypes.size() == pathnames.size()) {
            for (int i = 0; i < paramTypes.size(); ++i) {
                if (paramTypes.get(i).equals(pathnames.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void calcImports() {
        super.calcImports();
        for (OJEnum ojEnum : this.innerEnums) {
            ojEnum.calcImports();
            this.addToImports(ojEnum.getImports());
            ojEnum.setImports(new HashSet<OJPathName>());
        }
        this.addToImports(AnnotationHelper.getImportsFrom(this.getFields()));
        this.addToImports(AnnotationHelper.getImportsFrom(this.getOperations()));
        this.addToImports(AnnotationHelper.getImportsFrom(this));
    }

    @Override
    public String toJavaString() {
        this.calcImports();
        StringBuilder classInfo = new StringBuilder();
        classInfo.append(this.getMyPackage().toJavaString());
        classInfo.append("\n");
        classInfo.append((CharSequence)this.imports());
        classInfo.append("\n");
        this.addJavaDocComment(classInfo);
        if (this.getAnnotations().size() > 0) {
            classInfo.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getAnnotations(), "\n"), 0));
            classInfo.append("\n");
        }
        if (this.isAbstract()) {
            classInfo.append("abstract ");
        }
        classInfo.append(this.visToJava(this) + " ");
        classInfo.append("class ");
        classInfo.append(this.getName());
        Iterator<String> it = this.genericTypeParams.iterator();
        if (it.hasNext()) {
            classInfo.append("<");
        }
        while (it.hasNext()) {
            classInfo.append(it.next());
            if (it.hasNext()) {
                classInfo.append(",");
                continue;
            }
            classInfo.append(">");
        }
        if (this.getSuperclass() != null) {
            classInfo.append(" extends " + this.getSuperclass().getLast());
        }
        classInfo.append((CharSequence)this.implementedInterfaces());
        classInfo.append(" {\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.fields(), 1));
        classInfo.append("\n\n");
        if (!this.staticBlock.getStatements().isEmpty()) {
            classInfo.append((CharSequence)JavaStringHelpers.indent(this.staticBlock(), 1));
            classInfo.append("\n\n");
        }
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.constructors(), 1));
        classInfo.append("\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.operations(), 1));
        classInfo.append("\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.innerEnums(), 1));
        classInfo.append("\n");
        classInfo.append("}");
        return classInfo.toString();
    }

    @Override
    public StringBuilder operations() {
        ArrayList<OJOperation> temp = new ArrayList<OJOperation>(this.getOperations());
        Collections.sort(temp, new OJOperationComparator());
        StringBuilder result = new StringBuilder();
        result.append(JavaUtil.collectionToJavaString(temp, "\n"));
        return result;
    }

    protected StringBuilder constructors() {
        StringBuilder result = new StringBuilder();
        TreeSet<OJOperation> treeSet = new TreeSet<OJOperation>(new OJOperationComparator());
        treeSet.addAll(this.getConstructors());
        result.append(JavaUtil.collectionToJavaString(treeSet, "\n"));
        return result;
    }

    public StringBuilder fields() {
        StringBuilder result = new StringBuilder();
        result.append(JavaUtil.collectionToJavaString(this.getFields(), "\n"));
        return result;
    }

    public StringBuilder staticBlock() {
        StringBuilder result = new StringBuilder();
        result.append("static {\n");
        result.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.staticBlock.getStatements(), "\n"), 1));
        result.append("\n}\n");
        return result;
    }

    public StringBuilder innerEnums() {
        StringBuilder result = new StringBuilder();
        result.append(JavaUtil.collectionToJavaString(this.innerEnums, "\n"));
        return result;
    }

    protected StringBuilder implementedInterfaces() {
        StringBuilder result = new StringBuilder();
        if (!this.getImplementedInterfaces().isEmpty()) {
            result.append(" implements ");
        }
        Iterator<OJPathName> it = this.getImplementedInterfaces().iterator();
        while (it.hasNext()) {
            OJPathName elem = it.next();
            result.append(elem.getLast());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result;
    }

    public void addGenericTypeParam(String string) {
        this.genericTypeParams.add(string);
    }

    public void addInnerEnum(OJEnum ojEnum) {
        this.innerEnums.add(ojEnum);
        ojEnum.setInnerClass(true);
    }

    @Override
    protected void addJavaDocComment(StringBuilder result) {
        if (this.getComment() != null && !this.getComment().equals("")) {
            String comment = JavaStringHelpers.firstCharToUpper(this.getComment());
            result.append("/** " + comment);
            result.append("\n */\n");
        }
    }

    public boolean hasAnnotation(OJPathName pathName) {
        return this.f_annotations.containsKey(pathName);
    }

    @Override
    public OJAnnotatedClass getDeepCopy(OJPackage owner) {
        OJAnnotatedClass copy = new OJAnnotatedClass(this.getName());
        copy.setMyPackage(owner);
        this.copyDeepInfoInto(copy);
        return copy;
    }

    protected void copyDeepInfoInto(OJAnnotatedClass copy) {
        super.copyDeepInfoInto(copy);
        Set<OJPathName> interfaces = this.getImplementedInterfaces();
        for (OJPathName ojInterface : interfaces) {
            OJPathName copyInterface = ojInterface.getCopy();
            copy.addToImplementedInterfaces(copyInterface);
        }
        Collection<OJAnnotationValue> annotations = this.getAnnotations();
        for (OJAnnotationValue ojAnnotationValue : annotations) {
            OJAnnotationValue copyAnnotation = ojAnnotationValue.getDeepCopy();
            copy.addAnnotationIfNew(copyAnnotation);
        }
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String suffix) {
        super.renameAll(renamePathNames, suffix);
        Collection<OJAnnotationValue> annotations = this.getAnnotations();
        for (OJAnnotationValue ojAnnotationValue : annotations) {
            ojAnnotationValue.renameAll(renamePathNames, suffix);
        }
    }

    @Override
    public String toString() {
        return this.getPathName().toString();
    }

    public void removeFromOperations(String internalRemover, List<OJPathName> singletonList) {
        Set methodSet = (Set)this.f_operations.get(internalRemover);
        if (methodSet != null) {
            Iterator iterator = methodSet.iterator();
            while (iterator.hasNext()) {
                OJOperation ojOperation = (OJOperation)iterator.next();
                if (!ojOperation.getName().equals(internalRemover) || !ojOperation.paramsEquals(singletonList)) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void removeFromFields(String name) {
        this.f_fields.remove(name);
    }

    public String toAbstractSuperclassJavaString() {
        String concreteName = this.getName();
        String oldName = this.f_name;
        this.setName(oldName + "Generated");
        String result = this.toJavaString();
        result = result.replaceAll("[\\(]this[\\)]", "((" + concreteName + ")this)");
        this.setName(oldName);
        return result;
    }

    public static void main(String[] args) {
        System.out.println("this,this;this this)this.".replaceAll("\\bthis\\b", "bla"));
    }

    public String toConcreteImplementationJavaString() {
        this.calcImports();
        StringBuilder classInfo = new StringBuilder();
        classInfo.append(this.getMyPackage().toJavaString());
        classInfo.append("\n");
        classInfo.append((CharSequence)this.imports());
        classInfo.append("\n");
        this.addJavaDocComment(classInfo);
        if (this.getAnnotations().size() > 0) {
            classInfo.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getAnnotations(), "\n"), 0));
            classInfo.append("\n");
        }
        if (this.isAbstract()) {
            classInfo.append("abstract ");
        }
        classInfo.append(this.visToJava(this) + " ");
        classInfo.append("class ");
        classInfo.append(this.getName());
        if (this.suffix == null) {
            classInfo.append(" extends " + this.getName() + "Generated");
        } else {
            classInfo.append(" extends " + this.f_name + "Generated" + this.suffix);
        }
        classInfo.append(" {\n");
        Set<OJConstructor> constructors = this.getConstructors();
        ArrayList<OJConstructor> tempConstructors = new ArrayList<OJConstructor>();
        for (OJConstructor ojConstructor : constructors) {
            OJConstructor e = ojConstructor.getDeepCopy();
            e.z_internalAddToOwningClass(this);
            e.setBody(new OJBlock());
            Iterator<OJParameter> iterator = e.getParameters().iterator();
            StringBuilder sb = new StringBuilder("super(");
            while (iterator.hasNext()) {
                OJParameter ojParameter = iterator.next();
                sb.append(ojParameter.getName());
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
            tempConstructors.add(e);
        }
        classInfo.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(tempConstructors, "\n"), 1));
        classInfo.append("\n}");
        return classInfo.toString();
    }

    public String getQualifiedName() {
        return this.getMyPackage().toString() + "." + this.getName();
    }

    public void implementGetter() {
        for (OJField field : this.getFields()) {
            String name = field.getName();
            if (name.startsWith("_")) {
                name = name.substring(1);
            }
            OJAnnotatedOperation getter = new OJAnnotatedOperation((field.getType().getLast().equals("boolean") ? "is" : "get") + StringUtils.capitalize((String)name), field.getType());
            getter.getBody().addToStatements("return this." + field.getName());
            this.addToOperations(getter);
        }
    }

    public void createConstructorFromFields() {
        OJConstructor constructor = new OJConstructor();
        for (OJField field : this.getFields()) {
            constructor.addParam(field.getName(), field.getType());
            constructor.getBody().addToStatements("this." + field.getName() + " = " + field.getName());
        }
        this.addToConstructors(constructor);
    }

    public int countOperationsStartingWith(String name) {
        int count = 0;
        for (OJOperation oper : this.getOperations()) {
            if (!oper.getName().startsWith(name)) continue;
            ++count;
        }
        return count;
    }

    public OJEnum findEnum(String enumName) {
        for (OJEnum e : this.innerEnums) {
            if (!e.getName().equals(enumName)) continue;
            return e;
        }
        return null;
    }

    public void addToStaticBlock(OJStatement ojStatement) {
        this.staticBlock.addToStatements(ojStatement);
    }
}

