/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.umlg.java.metamodel.OJElement;
import org.umlg.java.metamodel.OJPackage;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.AnnotationHelper;
import org.umlg.java.metamodel.annotation.OJAnnotatedElement;
import org.umlg.java.metamodel.annotation.OJAnnotationValue;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJAnnotatedPackageInfo
extends OJElement
implements OJAnnotatedElement {
    private OJPackage myPackage;
    Map<OJPathName, OJAnnotationValue> f_annotations = new TreeMap<OJPathName, OJAnnotationValue>();

    public OJAnnotatedPackageInfo(String string) {
        this.setName(string);
    }

    public OJAnnotatedPackageInfo() {
        this.setName("");
    }

    @Override
    public boolean addAnnotationIfNew(OJAnnotationValue value) {
        if (this.f_annotations.containsKey(value.getType())) {
            return false;
        }
        this.putAnnotation(value);
        return true;
    }

    @Override
    public Collection<OJAnnotationValue> getAnnotations() {
        return this.f_annotations.values();
    }

    @Override
    public OJAnnotationValue putAnnotation(OJAnnotationValue value) {
        return this.f_annotations.put(value.getType(), value);
    }

    @Override
    public OJAnnotationValue removeAnnotation(OJPathName type) {
        return this.f_annotations.remove(type);
    }

    @Override
    public String toJavaString() {
        StringBuilder sb = new StringBuilder();
        if (super.getComment() != null && super.getComment().length() > 0) {
            sb.append("/**\n");
            sb.append(super.getComment());
            sb.append("*/\n");
        }
        sb.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getAnnotations(), "\n"), 0));
        sb.append("\n");
        sb.append(this.getMyPackage().toJavaString());
        sb.append("\n");
        sb.append(JavaStringHelpers.indent(this.imports(), 0));
        return sb.toString();
    }

    private String imports() {
        StringBuilder sb = new StringBuilder();
        for (OJPathName path : this.getImports()) {
            if (this.getMyPackage().getPathName().equals(path.getHead())) continue;
            sb.append("import " + path.toString() + ";\n");
        }
        return sb.toString();
    }

    private Collection<OJPathName> getImports() {
        HashSet<OJPathName> results = new HashSet<OJPathName>();
        for (OJAnnotationValue an : this.getAnnotations()) {
            results.addAll(an.getAllTypesUsed());
        }
        return results;
    }

    public OJAnnotatedPackageInfo getDeepCopy(OJAnnotatedPackageInfo owner) {
        OJAnnotatedPackageInfo copy = new OJAnnotatedPackageInfo(this.getName());
        this.copyDeepInfoInto(owner, copy);
        return copy;
    }

    protected void copyDeepInfoInto(OJAnnotatedPackageInfo owner, OJAnnotatedPackageInfo copy) {
        for (OJAnnotationValue annotation : this.getAnnotations()) {
            copy.addAnnotationIfNew(annotation.getDeepCopy());
        }
    }

    @Override
    public OJAnnotationValue findAnnotation(OJPathName ojPathName) {
        return AnnotationHelper.getAnnotation(this, ojPathName);
    }

    public OJPackage getMyPackage() {
        return this.myPackage;
    }

    public void setMyPackage(OJPackage myPackage) {
        this.myPackage = myPackage;
    }

    @Override
    public void renameAll(Set<OJPathName> match, String suffix) {
        for (OJAnnotationValue a : this.getAnnotations()) {
            a.renameAll(match, suffix);
        }
    }
}

