/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.java.metamodel.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.umlg.java.metamodel.OJConstructor;
import org.umlg.java.metamodel.OJPathName;
import org.umlg.java.metamodel.annotation.OJAnnotatedClass;
import org.umlg.java.metamodel.annotation.OJEnumLiteral;
import org.umlg.java.metamodel.generated.OJVisibilityKindGEN;
import org.umlg.java.metamodel.utilities.JavaStringHelpers;
import org.umlg.java.metamodel.utilities.JavaUtil;

public class OJEnum
extends OJAnnotatedClass {
    List<OJEnumLiteral> f_literals = new ArrayList<OJEnumLiteral>();

    public OJEnum(String string) {
        super(string);
    }

    @Override
    public void release() {
        super.release();
        this.f_literals.clear();
    }

    public void addToLiterals(OJEnumLiteral literal) {
        this.f_literals.add(literal);
    }

    public List<OJEnumLiteral> getLiterals() {
        return this.f_literals;
    }

    @Override
    public void renameAll(Set<OJPathName> renamePathNames, String suffix) {
        super.renameAll(renamePathNames, suffix);
        for (OJEnumLiteral l : this.getLiterals()) {
            l.renameAll(renamePathNames, suffix);
        }
    }

    @Override
    public String toJavaString() {
        StringBuilder classInfo = new StringBuilder();
        if (!this.isInnerClass()) {
            this.calcImports();
            classInfo.append(this.getMyPackage().toJavaString());
            classInfo.append("\n");
            classInfo.append((CharSequence)this.imports());
            classInfo.append("\n");
        }
        this.addJavaDocComment(classInfo);
        if (this.getNeedsSuppress()) {
            classInfo.append("@SuppressWarnings(\"serial\")\n");
        }
        classInfo.append(JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getAnnotations(), "\n"), 0));
        if (this.isAbstract()) {
            classInfo.append("abstract ");
        }
        classInfo.append(this.visToJava(this) + " ");
        classInfo.append("enum " + this.getName());
        if (this.getSuperclass() != null) {
            classInfo.append(" extends " + this.getSuperclass().getLast());
        }
        classInfo.append((CharSequence)this.implementedInterfaces());
        classInfo.append(" {\n");
        classInfo.append(JavaStringHelpers.indent(this.literals(), 1));
        classInfo.append(";\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.fields(), 1));
        classInfo.append("\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.constructors(), 1));
        classInfo.append("\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.operations(), 1));
        classInfo.append("\n");
        classInfo.append((CharSequence)JavaStringHelpers.indent(this.innerEnums(), 1));
        classInfo.append("\n");
        classInfo.append("}");
        return classInfo.toString();
    }

    @Override
    public StringBuilder constructors() {
        StringBuilder result = new StringBuilder();
        for (OJConstructor c : this.getConstructors()) {
            c.setVisibility(OJVisibilityKindGEN.PRIVATE);
            result.append(c.toJavaString());
        }
        return result;
    }

    private String literals() {
        return JavaStringHelpers.indent(JavaUtil.collectionToJavaString(this.getLiterals(), ",\n"), 0);
    }

    public OJEnumLiteral findLiteral(String name) {
        for (OJEnumLiteral l : this.getLiterals()) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        return null;
    }
}

