/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.jetty.websocket;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.umlg.jetty.websocket.UmlgWebsocketSessionManager;

public class UmlgWebsocket
implements WebSocketListener {
    private Session outbound;

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
    }

    public void onWebSocketClose(int statusCode, String reason) {
        UmlgWebsocketSessionManager.INSTANCE.removeSession(this.outbound);
        this.outbound = null;
    }

    public void onWebSocketConnect(Session session) {
        this.outbound = session;
        UmlgWebsocketSessionManager.INSTANCE.addSession(session, session.getRemoteAddress().toString());
    }

    public void onWebSocketError(Throwable cause) {
        cause.printStackTrace(System.err);
    }

    public void onWebSocketText(String message) {
        if (this.outbound != null && this.outbound.isOpen()) {
            System.out.printf("Echoing back message [%s]%n", message);
            this.outbound.getRemote().sendString(message, null);
        }
    }
}

