/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.dialect;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.umlg.sqlg.predicate.FullText;
import org.umlg.sqlg.sql.dialect.BaseSqlDialect;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgExceptions;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.SqlgVertex;
import org.umlg.sqlg.util.SqlgUtil;

public class CockroachdbDialect
extends BaseSqlDialect {
    private static final int PARAMETER_LIMIT = Short.MAX_VALUE;
    private static Logger logger = LoggerFactory.getLogger(CockroachdbDialect.class);

    public String sqlgSqlgSchemaCreationScript() {
        return "CREATE DATABASE " + this.maybeWrapInQoutes("sqlg_schema");
    }

    public boolean supportsDistribution() {
        return true;
    }

    public boolean supportsSchemas() {
        return false;
    }

    public String dialectName() {
        return "Postgresql";
    }

    public String createSchemaStatement(String schemaName) {
        return "CREATE DATABASE IF NOT EXISTS " + this.maybeWrapInQoutes(schemaName);
    }

    public String dropSchemaStatement(String schema) {
        return "DROP DATABASE IF EXISTS " + this.maybeWrapInQoutes(schema);
    }

    public boolean supportsCascade() {
        return false;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public Set<String> getInternalSchemas() {
        return ImmutableSet.copyOf(Arrays.asList("system", "crdb_internal", "pg_catalog", "information_schema", "tiger", "tiger_data", "topology"));
    }

    public Set<String> getSpacialRefTable() {
        return ImmutableSet.copyOf(Collections.singletonList("spatial_ref_sys"));
    }

    public List<String> getGisSchemas() {
        return Arrays.asList("tiger", "tiger_data", "topology");
    }

    public String getForeignKeyTypeDefinition() {
        return "BIGINT";
    }

    public String getColumnEscapeKey() {
        return "\"";
    }

    public String getPrimaryKeyType() {
        return "BIGINT NOT NULL PRIMARY KEY";
    }

    public String getAutoIncrementPrimaryKeyConstruct() {
        return "BIGSERIAL PRIMARY KEY";
    }

    public void assertTableName(String tableName) {
        if (!StringUtils.isEmpty((CharSequence)tableName) && tableName.length() > 63) {
            throw new IllegalStateException(String.format("Postgres table names must be 63 characters or less! Given table name is %s", tableName));
        }
    }

    public String getArrayDriverType(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 23: {
                return "bytea";
            }
            case 22: {
                return "bytea";
            }
            case 20: {
                return "bool";
            }
            case 21: {
                return "bool";
            }
            case 25: {
                return "smallint";
            }
            case 24: {
                return "smallint";
            }
            case 27: {
                return "integer";
            }
            case 26: {
                return "integer";
            }
            case 29: {
                return "bigint";
            }
            case 28: {
                return "bigint";
            }
            case 31: {
                return "float";
            }
            case 30: {
                return "float";
            }
            case 33: {
                return "float";
            }
            case 32: {
                return "float";
            }
            case 34: {
                return "varchar";
            }
            case 35: {
                return "timestamptz";
            }
            case 36: {
                return "date";
            }
            case 37: {
                return "timetz";
            }
            case 38: {
                return "timestamptz";
            }
            case 41: {
                return "jsonb";
            }
        }
        throw new IllegalStateException("propertyType " + propertyType.name() + " unknown!");
    }

    public String existIndexQuery(SchemaTable schemaTable, String prefix, String indexName) {
        StringBuilder sb = new StringBuilder("SELECT 1 FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace");
        sb.append(" WHERE  c.relname = '");
        sb.append(indexName);
        sb.append("' AND n.nspname = '");
        sb.append(schemaTable.getSchema());
        sb.append("'");
        return sb.toString();
    }

    private void appendSqlValue(StringBuilder sql, Object value, PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                if (value != null) {
                    sql.append(value);
                    break;
                }
                sql.append("null");
                break;
            }
            case 1: {
                if (value != null) {
                    sql.append(value);
                    break;
                }
                sql.append("null");
                break;
            }
            case 2: {
                if (value != null) {
                    sql.append(value);
                    break;
                }
                sql.append("null");
                break;
            }
            case 3: {
                if (value != null) {
                    sql.append(value);
                    break;
                }
                sql.append("null");
                break;
            }
            case 4: {
                if (value != null) {
                    sql.append(value);
                    break;
                }
                sql.append("null");
                break;
            }
            case 5: {
                if (value != null) {
                    sql.append(value);
                    break;
                }
                sql.append("null");
                break;
            }
            case 6: {
                if (value != null) {
                    sql.append(value);
                    break;
                }
                sql.append("null");
                break;
            }
            case 7: {
                if (value != null) {
                    sql.append("'");
                    sql.append(value.toString().replace("'", "''"));
                    sql.append("'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 9: {
                if (value != null) {
                    sql.append("'");
                    sql.append(value.toString());
                    sql.append("'::TIMESTAMP");
                    break;
                }
                sql.append("null");
                break;
            }
            case 8: {
                if (value != null) {
                    sql.append("'");
                    sql.append(value.toString());
                    sql.append("'::DATE");
                    break;
                }
                sql.append("null");
                break;
            }
            case 10: {
                if (value != null) {
                    sql.append("'");
                    sql.append(CockroachdbDialect.shiftDST((LocalTime)value).toString());
                    sql.append("'::TIME");
                    break;
                }
                sql.append("null");
                break;
            }
            case 11: {
                if (value != null) {
                    ZonedDateTime zonedDateTime = (ZonedDateTime)value;
                    LocalDateTime localDateTime = zonedDateTime.toLocalDateTime();
                    TimeZone timeZone = TimeZone.getTimeZone(zonedDateTime.getZone());
                    sql.append("'");
                    sql.append(localDateTime.toString());
                    sql.append("'::TIMESTAMP");
                    sql.append(",'");
                    sql.append(timeZone.getID());
                    sql.append("'");
                    break;
                }
                sql.append("null,null");
                break;
            }
            case 13: {
                if (value != null) {
                    Duration duration = (Duration)value;
                    sql.append("'");
                    sql.append(duration.getSeconds());
                    sql.append("'::BIGINT");
                    sql.append(",'");
                    sql.append(duration.getNano());
                    sql.append("'::INTEGER");
                    break;
                }
                sql.append("null,null");
                break;
            }
            case 12: {
                if (value != null) {
                    Period period = (Period)value;
                    sql.append("'");
                    sql.append(period.getYears());
                    sql.append("'::INTEGER");
                    sql.append(",'");
                    sql.append(period.getMonths());
                    sql.append("'::INTEGER");
                    sql.append(",'");
                    sql.append(period.getDays());
                    sql.append("'::INTEGER");
                    break;
                }
                sql.append("null,null,null");
                break;
            }
            case 14: {
                if (value != null) {
                    sql.append("'");
                    sql.append(value.toString().replace("'", "''"));
                    sql.append("'::JSONB");
                    break;
                }
                sql.append("null");
                break;
            }
            case 20: {
                if (value != null) {
                    sql.append("'{");
                    boolean[] booleanArray = (boolean[])value;
                    int countBooleanArray = 1;
                    boolean[] timeZone = booleanArray;
                    int n = timeZone.length;
                    for (int i = 0; i < n; ++i) {
                        Boolean b = timeZone[i];
                        sql.append(b);
                        if (countBooleanArray++ >= booleanArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 21: {
                if (value != null) {
                    sql.append("'{");
                    Boolean[] BooleanArray = (Boolean[])value;
                    int countBOOLEANArray = 1;
                    for (Boolean b : BooleanArray) {
                        sql.append(b);
                        if (countBOOLEANArray++ >= BooleanArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 22: {
                if (value != null) {
                    sql.append("'");
                    sql.append(PGbytea.toPGString((byte[])((byte[])value)).replace("'", "''"));
                    sql.append("'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 23: {
                if (value != null) {
                    sql.append("'");
                    sql.append(PGbytea.toPGString((byte[])((byte[])SqlgUtil.convertByteArrayToPrimitiveArray((Byte[])((Byte[])value)))).replace("'", "''"));
                    sql.append("'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 24: {
                if (value != null) {
                    sql.append("'{");
                    short[] sortArray = (short[])value;
                    int countShortArray = 1;
                    short[] timeZone = sortArray;
                    int n = timeZone.length;
                    for (int i = 0; i < n; ++i) {
                        Short s = timeZone[i];
                        sql.append(s);
                        if (countShortArray++ >= sortArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 25: {
                if (value != null) {
                    sql.append("'{");
                    Short[] shortObjectArray = (Short[])value;
                    for (int i = 0; i < shortObjectArray.length; ++i) {
                        Short s = shortObjectArray[i];
                        sql.append(s);
                        if (i >= shortObjectArray.length - 1) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 26: {
                if (value != null) {
                    sql.append("'{");
                    int[] intArray = (int[])value;
                    int countIntArray = 1;
                    int[] nArray = intArray;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Integer i2 = nArray[i];
                        sql.append(i2);
                        if (countIntArray++ >= intArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 27: {
                if (value != null) {
                    sql.append("'{");
                    Integer[] integerArray = (Integer[])value;
                    int countIntegerArray = 1;
                    for (Integer i : integerArray) {
                        sql.append(i);
                        if (countIntegerArray++ >= integerArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 29: {
                if (value != null) {
                    sql.append("'{");
                    Long[] longArray = (Long[])value;
                    int countLongArray = 1;
                    for (Long l : longArray) {
                        sql.append(l);
                        if (countLongArray++ >= longArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 28: {
                if (value != null) {
                    sql.append("'{");
                    long[] longPrimitiveArray = (long[])value;
                    int countLongPrimitiveArray = 1;
                    long[] lArray = longPrimitiveArray;
                    int n = lArray.length;
                    for (int i = 0; i < n; ++i) {
                        Long l = lArray[i];
                        sql.append(l);
                        if (countLongPrimitiveArray++ >= longPrimitiveArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 31: {
                if (value != null) {
                    sql.append("'{");
                    Float[] floatArray = (Float[])value;
                    int countFloatArray = 1;
                    for (Float f : floatArray) {
                        sql.append(f);
                        if (countFloatArray++ >= floatArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 30: {
                if (value != null) {
                    sql.append("'{");
                    float[] floatPrimitiveArray = (float[])value;
                    int countFloatPrimitiveArray = 1;
                    float[] fArray = floatPrimitiveArray;
                    int n = fArray.length;
                    for (int i = 0; i < n; ++i) {
                        Float f = Float.valueOf(fArray[i]);
                        sql.append(f);
                        if (countFloatPrimitiveArray++ >= floatPrimitiveArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 33: {
                if (value != null) {
                    sql.append("'{");
                    Double[] doubleArray = (Double[])value;
                    int countDoubleArray = 1;
                    for (Double d : doubleArray) {
                        sql.append(d);
                        if (countDoubleArray++ >= doubleArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 32: {
                if (value != null) {
                    sql.append("'{");
                    double[] doublePrimitiveArray = (double[])value;
                    int countDoublePrimitiveArray = 1;
                    double[] dArray = doublePrimitiveArray;
                    int n = dArray.length;
                    for (int i = 0; i < n; ++i) {
                        Double d = dArray[i];
                        sql.append(d);
                        if (countDoublePrimitiveArray++ >= doublePrimitiveArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 34: {
                if (value != null) {
                    sql.append("'{");
                    String[] stringArray = (String[])value;
                    int countStringArray = 1;
                    for (String s : stringArray) {
                        sql.append("\"");
                        sql.append(s);
                        sql.append("\"");
                        if (countStringArray++ >= stringArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("}'");
                    break;
                }
                sql.append("null");
                break;
            }
            case 35: {
                if (value != null) {
                    sql.append("ARRAY[");
                    LocalDateTime[] localDateTimeArray = (LocalDateTime[])value;
                    int countStringArray = 1;
                    for (LocalDateTime s : localDateTimeArray) {
                        sql.append("'");
                        sql.append(s.toString());
                        sql.append("'::TIMESTAMP");
                        if (countStringArray++ >= localDateTimeArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("]");
                    break;
                }
                sql.append("null");
                break;
            }
            case 36: {
                if (value != null) {
                    sql.append("ARRAY[");
                    LocalDate[] localDateArray = (LocalDate[])value;
                    int countStringArray = 1;
                    for (LocalDate s : localDateArray) {
                        sql.append("'");
                        sql.append(s.toString());
                        sql.append("'::DATE");
                        if (countStringArray++ >= localDateArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("]");
                    break;
                }
                sql.append("null");
                break;
            }
            case 37: {
                if (value != null) {
                    sql.append("ARRAY[");
                    LocalTime[] localTimeArray = (LocalTime[])value;
                    int countStringArray = 1;
                    for (LocalTime s : localTimeArray) {
                        sql.append("'");
                        sql.append(CockroachdbDialect.shiftDST(s).toLocalTime().toString());
                        sql.append("'::TIME");
                        if (countStringArray++ >= localTimeArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("]");
                    break;
                }
                sql.append("null");
                break;
            }
            case 38: {
                if (value != null) {
                    TimeZone timeZone;
                    LocalDateTime localDateTime;
                    sql.append("ARRAY[");
                    ZonedDateTime[] localZonedDateTimeArray = (ZonedDateTime[])value;
                    int countStringArray = 1;
                    for (ZonedDateTime zonedDateTime : localZonedDateTimeArray) {
                        localDateTime = zonedDateTime.toLocalDateTime();
                        timeZone = TimeZone.getTimeZone(zonedDateTime.getZone());
                        sql.append("'");
                        sql.append(localDateTime.toString());
                        sql.append("'::TIMESTAMP");
                        if (countStringArray++ >= localZonedDateTimeArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("],");
                    sql.append("ARRAY[");
                    countStringArray = 1;
                    for (ZonedDateTime zonedDateTime : localZonedDateTimeArray) {
                        localDateTime = zonedDateTime.toLocalDateTime();
                        timeZone = TimeZone.getTimeZone(zonedDateTime.getZone());
                        sql.append("'");
                        sql.append(timeZone.getID());
                        sql.append("'");
                        if (countStringArray++ >= localZonedDateTimeArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("]");
                    break;
                }
                sql.append("null,null");
                break;
            }
            case 39: {
                if (value != null) {
                    sql.append("ARRAY[");
                    Duration[] durationArray = (Duration[])value;
                    int countStringArray = 1;
                    for (Duration duration : durationArray) {
                        sql.append("'");
                        sql.append(duration.getSeconds());
                        sql.append("'::BIGINT");
                        if (countStringArray++ >= durationArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("],");
                    sql.append("ARRAY[");
                    countStringArray = 1;
                    for (Duration duration : durationArray) {
                        sql.append("'");
                        sql.append(duration.getNano());
                        sql.append("'::INTEGER");
                        if (countStringArray++ >= durationArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("]");
                    break;
                }
                sql.append("null,null");
                break;
            }
            case 40: {
                if (value != null) {
                    sql.append("ARRAY[");
                    Period[] periodArray = (Period[])value;
                    int countStringArray = 1;
                    for (Period period : periodArray) {
                        sql.append("'");
                        sql.append(period.getYears());
                        sql.append("'::INTEGER");
                        if (countStringArray++ >= periodArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("],");
                    sql.append("ARRAY[");
                    countStringArray = 1;
                    for (Period period : periodArray) {
                        sql.append("'");
                        sql.append(period.getMonths());
                        sql.append("'::INTEGER");
                        if (countStringArray++ >= periodArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("],");
                    sql.append("ARRAY[");
                    countStringArray = 1;
                    for (Period period : periodArray) {
                        sql.append("'");
                        sql.append(period.getDays());
                        sql.append("'::INTEGER");
                        if (countStringArray++ >= periodArray.length) continue;
                        sql.append(",");
                    }
                    sql.append("]");
                    break;
                }
                sql.append("null,null,null");
                break;
            }
            case 15: {
                throw new IllegalStateException("JSON Arrays are not supported.");
            }
            case 16: {
                throw new IllegalStateException("JSON Arrays are not supported.");
            }
            case 17: {
                throw new IllegalStateException("JSON Arrays are not supported.");
            }
            case 18: {
                throw new IllegalStateException("JSON Arrays are not supported.");
            }
            case 19: {
                throw new IllegalStateException("JSON Arrays are not supported.");
            }
            case 41: {
                throw new IllegalStateException("JSON Arrays are not supported.");
            }
            default: {
                throw new IllegalStateException("Unknown propertyType " + propertyType.name());
            }
        }
    }

    private void sqlCastArray(StringBuilder sql, PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 20: {
                sql.append("::boolean[]");
                break;
            }
            case 22: {
                sql.append("::bytea");
                break;
            }
            case 24: {
                sql.append("::smallint[]");
                break;
            }
            case 26: {
                sql.append("::int[]");
                break;
            }
            case 28: {
                sql.append("::bigint[]");
                break;
            }
            case 30: {
                sql.append("::real[]");
                break;
            }
            case 32: {
                sql.append("::double precision[]");
                break;
            }
            case 34: {
                sql.append("::text[]");
                break;
            }
            case 21: {
                sql.append("::boolean[]");
                break;
            }
            case 23: {
                sql.append("::bytea");
                break;
            }
            case 25: {
                sql.append("::smallint[]");
                break;
            }
            case 27: {
                sql.append("::int[]");
                break;
            }
            case 29: {
                sql.append("::bigint[]");
                break;
            }
            case 31: {
                sql.append("::real[]");
                break;
            }
            case 33: {
                sql.append("::double precision[]");
                break;
            }
        }
    }

    private void deleteEdges(SqlgGraph sqlgGraph, SchemaTable schemaTable, List<SqlgVertex> subVertices, Set<SchemaTable> labels, boolean inDirection) {
        Iterator<SchemaTable> iterator = labels.iterator();
        if (iterator.hasNext()) {
            SchemaTable inLabel = iterator.next();
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ");
            sql.append(this.maybeWrapInQoutes(inLabel.getSchema()));
            sql.append(".");
            sql.append(this.maybeWrapInQoutes(inLabel.getTable()));
            sql.append(" WHERE ");
            sql.append(this.maybeWrapInQoutes(schemaTable.toString() + (inDirection ? "__I" : "__O")));
            sql.append(" IN (");
            int count = 1;
            for (Vertex vertex : subVertices) {
                sql.append("?");
                if (count++ >= subVertices.size()) continue;
                sql.append(",");
            }
            sql.append(")");
            if (sqlgGraph.getSqlDialect().needsSemicolon()) {
                sql.append(";");
            }
            if (logger.isDebugEnabled()) {
                logger.debug(sql.toString());
            }
            Connection conn = sqlgGraph.tx().getConnection();
            try {
                PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());
                Throwable throwable = null;
                try {
                    try {
                        count = 1;
                        throw new RuntimeException("handle ID");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (preparedStatement != null) {
                        CockroachdbDialect.$closeResource(throwable, preparedStatement);
                    }
                    throw throwable3;
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
    }

    public String[] propertyTypeToSqlDefinition(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                return new String[]{"BOOLEAN"};
            }
            case 2: {
                return new String[]{"SMALLINT"};
            }
            case 3: {
                return new String[]{"INTEGER"};
            }
            case 4: {
                return new String[]{"BIGINT"};
            }
            case 5: {
                return new String[]{"REAL"};
            }
            case 6: {
                return new String[]{"DOUBLE PRECISION"};
            }
            case 8: {
                return new String[]{"DATE"};
            }
            case 9: {
                return new String[]{"TIMESTAMP WITH TIME ZONE"};
            }
            case 11: {
                return new String[]{"TIMESTAMP WITH TIME ZONE", "TEXT"};
            }
            case 10: {
                return new String[]{"TIME WITH TIME ZONE"};
            }
            case 12: {
                return new String[]{"INTEGER", "INTEGER", "INTEGER"};
            }
            case 13: {
                return new String[]{"BIGINT", "INTEGER"};
            }
            case 7: {
                return new String[]{"TEXT"};
            }
            case 14: {
                return new String[]{"JSONB"};
            }
            case 15: {
                return new String[]{"geometry(POINT)"};
            }
            case 16: {
                return new String[]{"geometry(LINESTRING)"};
            }
            case 17: {
                return new String[]{"geometry(POLYGON)"};
            }
            case 18: {
                return new String[]{"geography(POINT, 4326)"};
            }
            case 19: {
                return new String[]{"geography(POLYGON, 4326)"};
            }
            case 22: {
                return new String[]{"BYTEA"};
            }
            case 20: {
                return new String[]{"BOOLEAN[]"};
            }
            case 24: {
                return new String[]{"SMALLINT[]"};
            }
            case 26: {
                return new String[]{"INTEGER[]"};
            }
            case 28: {
                return new String[]{"BIGINT[]"};
            }
            case 30: {
                return new String[]{"REAL[]"};
            }
            case 32: {
                return new String[]{"DOUBLE PRECISION[]"};
            }
            case 34: {
                return new String[]{"TEXT[]"};
            }
            case 35: {
                return new String[]{"TIMESTAMP WITH TIME ZONE[]"};
            }
            case 36: {
                return new String[]{"DATE[]"};
            }
            case 37: {
                return new String[]{"TIME WITH TIME ZONE[]"};
            }
            case 38: {
                return new String[]{"TIMESTAMP WITH TIME ZONE[]", "TEXT[]"};
            }
            case 39: {
                return new String[]{"BIGINT[]", "INTEGER[]"};
            }
            case 40: {
                return new String[]{"INTEGER[]", "INTEGER[]", "INTEGER[]"};
            }
            case 27: {
                return new String[]{"INTEGER[]"};
            }
            case 21: {
                return new String[]{"BOOLEAN[]"};
            }
            case 23: {
                return new String[]{"BYTEA"};
            }
            case 25: {
                return new String[]{"SMALLINT[]"};
            }
            case 29: {
                return new String[]{"BIGINT[]"};
            }
            case 31: {
                return new String[]{"REAL[]"};
            }
            case 33: {
                return new String[]{"DOUBLE PRECISION[]"};
            }
            case 41: {
                return new String[]{"JSONB[]"};
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public PropertyType sqlTypeToPropertyType(SqlgGraph sqlgGraph, String schema, String table, String column, int sqlType, String typeName, ListIterator<Triple<String, Integer, String>> metaDataIter) {
        switch (sqlType) {
            case -7: {
                return PropertyType.BOOLEAN;
            }
            case 5: {
                return PropertyType.SHORT;
            }
            case 4: {
                return PropertyType.INTEGER;
            }
            case -5: {
                return PropertyType.LONG;
            }
            case 7: {
                return PropertyType.FLOAT;
            }
            case 8: {
                return PropertyType.DOUBLE;
            }
            case 12: {
                return PropertyType.STRING;
            }
            case 93: {
                return PropertyType.LOCALDATETIME;
            }
            case 91: {
                return PropertyType.LOCALDATE;
            }
            case 92: {
                return PropertyType.LOCALTIME;
            }
            case 1111: {
                switch (typeName) {
                    case "jsonb": {
                        return PropertyType.JSON;
                    }
                }
                throw new RuntimeException("Other type not supported " + typeName);
            }
            case -2: {
                return PropertyType.BYTE_ARRAY;
            }
            case 2003: {
                return this.sqlArrayTypeNameToPropertyType(typeName, sqlgGraph, schema, table, column, metaDataIter);
            }
        }
        throw new IllegalStateException("Unknown sqlType " + sqlType);
    }

    public PropertyType sqlArrayTypeNameToPropertyType(String typeName, SqlgGraph sqlgGraph, String schema, String table, String columnName, ListIterator<Triple<String, Integer, String>> metaDataIter) {
        switch (typeName) {
            case "_bool": {
                return PropertyType.BOOLEAN_ARRAY;
            }
            case "_int2": {
                return PropertyType.SHORT_ARRAY;
            }
            case "_int4": {
                return PropertyType.INTEGER_ARRAY;
            }
            case "_int8": {
                return PropertyType.LONG_ARRAY;
            }
            case "_float4": {
                return PropertyType.FLOAT_ARRAY;
            }
            case "_float8": {
                return PropertyType.DOUBLE_ARRAY;
            }
            case "_text": {
                return PropertyType.STRING_ARRAY;
            }
            case "_date": {
                return PropertyType.LOCALDATE_ARRAY;
            }
            case "_timetz": {
                return PropertyType.LOCALTIME_ARRAY;
            }
            case "_timestamptz": {
                Triple<String, Integer, String> metaData = metaDataIter.next();
                metaDataIter.previous();
                if (((String)metaData.getLeft()).startsWith(columnName + "~~~")) {
                    return PropertyType.ZONEDDATETIME_ARRAY;
                }
                return PropertyType.LOCALDATETIME_ARRAY;
            }
            case "_jsonb": {
                return PropertyType.JSON_ARRAY;
            }
        }
        throw new RuntimeException("Array type not supported " + typeName);
    }

    public int[] propertyTypeToJavaSqlType(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 0: {
                return new int[]{16};
            }
            case 2: {
                return new int[]{5};
            }
            case 3: {
                return new int[]{4};
            }
            case 4: {
                return new int[]{-5};
            }
            case 5: {
                return new int[]{7};
            }
            case 6: {
                return new int[]{8};
            }
            case 7: {
                return new int[]{2005};
            }
            case 22: {
                return new int[]{2003};
            }
            case 9: {
                return new int[]{93};
            }
            case 8: {
                return new int[]{91};
            }
            case 10: {
                return new int[]{92};
            }
            case 11: {
                return new int[]{93, 2005};
            }
            case 13: {
                return new int[]{-5, 4};
            }
            case 12: {
                return new int[]{4, 4, 4};
            }
            case 14: {
                return new int[]{1111};
            }
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return new int[]{2003};
            }
            case 38: {
                return new int[]{2003, 2003};
            }
            case 39: {
                return new int[]{2003, 2003};
            }
            case 40: {
                return new int[]{2003, 2003, 2003};
            }
        }
        throw new IllegalStateException("Unknown propertyType " + propertyType.name());
    }

    public void validateProperty(Object key, Object value) {
        if (key instanceof String && ((String)key).length() > 63) {
            this.validateColumnName((String)key);
        }
        if (value instanceof String) {
            return;
        }
        if (value instanceof Character) {
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        if (value instanceof Byte) {
            return;
        }
        if (value instanceof Short) {
            return;
        }
        if (value instanceof Integer) {
            return;
        }
        if (value instanceof Long) {
            return;
        }
        if (value instanceof Float) {
            return;
        }
        if (value instanceof Double) {
            return;
        }
        if (value instanceof LocalDate) {
            return;
        }
        if (value instanceof LocalDateTime) {
            return;
        }
        if (value instanceof ZonedDateTime) {
            return;
        }
        if (value instanceof LocalTime) {
            return;
        }
        if (value instanceof Period) {
            return;
        }
        if (value instanceof Duration) {
            return;
        }
        if (value instanceof JsonNode) {
            return;
        }
        if (value instanceof byte[]) {
            return;
        }
        if (value instanceof boolean[]) {
            return;
        }
        if (value instanceof char[]) {
            return;
        }
        if (value instanceof short[]) {
            return;
        }
        if (value instanceof int[]) {
            return;
        }
        if (value instanceof long[]) {
            return;
        }
        if (value instanceof float[]) {
            return;
        }
        if (value instanceof double[]) {
            return;
        }
        if (value instanceof String[]) {
            return;
        }
        if (value instanceof Character[]) {
            return;
        }
        if (value instanceof Boolean[]) {
            return;
        }
        if (value instanceof Byte[]) {
            return;
        }
        if (value instanceof Short[]) {
            return;
        }
        if (value instanceof Integer[]) {
            return;
        }
        if (value instanceof Long[]) {
            return;
        }
        if (value instanceof Float[]) {
            return;
        }
        if (value instanceof Double[]) {
            return;
        }
        if (value instanceof LocalDateTime[]) {
            return;
        }
        if (value instanceof LocalDate[]) {
            return;
        }
        if (value instanceof LocalTime[]) {
            return;
        }
        if (value instanceof ZonedDateTime[]) {
            return;
        }
        if (value instanceof Duration[]) {
            return;
        }
        if (value instanceof Period[]) {
            return;
        }
        if (value instanceof JsonNode[]) {
            return;
        }
        throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)value);
    }

    public boolean needForeignKeyIndex() {
        return true;
    }

    private Set<String> getForeignKeyConstraintNames(SqlgGraph sqlgGraph, String foreignKeySchema, String foreignKeyTable) {
        HashSet<String> result = new HashSet<String>();
        Connection conn = sqlgGraph.tx().getConnection();
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            String childCatalog = null;
            ResultSet resultSet = metadata.getImportedKeys(childCatalog, foreignKeySchema, foreignKeyTable);
            while (resultSet.next()) {
                result.add(resultSet.getString("FK_NAME"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean supportsClientInfo() {
        return true;
    }

    public void validateSchemaName(String schema) {
        if (schema.length() > this.getMaximumSchemaNameLength()) {
            throw SqlgExceptions.invalidSchemaName((String)("Postgresql schema names can only be 63 characters. " + schema + " exceeds that"));
        }
    }

    public void validateTableName(String table) {
        if (table.length() > this.getMaximumTableNameLength()) {
            throw SqlgExceptions.invalidTableName((String)("Postgresql table names can only be 63 characters. " + table + " exceeds that"));
        }
    }

    public void validateColumnName(String column) {
        super.validateColumnName(column);
        if (column.length() > this.getMaximumColumnNameLength()) {
            throw SqlgExceptions.invalidColumnName((String)("Postgresql column names can only be 63 characters. " + column + " exceeds that"));
        }
    }

    public int getMaximumSchemaNameLength() {
        return 63;
    }

    public int getMaximumTableNameLength() {
        return 63;
    }

    public int getMaximumColumnNameLength() {
        return 63;
    }

    public boolean supportsILike() {
        return Boolean.TRUE;
    }

    public boolean needsTimeZone() {
        return Boolean.TRUE;
    }

    public void setJson(PreparedStatement preparedStatement, int parameterStartIndex, JsonNode json) {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("jsonb");
        try {
            jsonObject.setValue(json.toString());
            preparedStatement.setObject(parameterStartIndex, jsonObject);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void handleOther(Map<String, Object> properties, String columnName, Object o, PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 14: {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    JsonNode jsonNode = objectMapper.readTree(((PGobject)o).getValue());
                    properties.put(columnName, jsonNode);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 23: {
                Array array = (Array)o;
                String arrayAsString = array.toString();
                arrayAsString = arrayAsString.substring(1);
                arrayAsString = arrayAsString.substring(0, arrayAsString.length() - 1);
                String[] byteAsString = arrayAsString.split(",");
                Byte[] result = new Byte[byteAsString.length];
                int count = 0;
                for (String s : byteAsString) {
                    Integer byteAsInteger = Integer.parseUnsignedInt(s.replace("\"", ""));
                    result[count++] = new Byte("");
                }
                properties.put(columnName, result);
                break;
            }
            default: {
                throw new IllegalStateException("sqlgDialect.handleOther does not handle " + propertyType.name());
            }
        }
    }

    public void lockTable(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        StringBuilder sql = new StringBuilder();
        sql.append("LOCK TABLE ");
        sql.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(schemaTable.getSchema()));
        sql.append(".");
        sql.append(sqlgGraph.getSqlDialect().maybeWrapInQoutes(prefix + schemaTable.getTable()));
        sql.append(" IN SHARE MODE");
        if (this.needsSemicolon()) {
            sql.append(";");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void alterSequenceCacheSize(SqlgGraph sqlgGraph, SchemaTable schemaTable, String sequence, int batchSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER SEQUENCE ");
        sql.append(sequence);
        sql.append(" CACHE ");
        sql.append(String.valueOf(batchSize));
        if (this.needsSemicolon()) {
            sql.append(";");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public long nextSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        long result;
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        Connection conn = sqlgGraph.tx().getConnection();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT NEXTVAL('\"" + schemaTable.getSchema() + "\".\"" + prefix + schemaTable.getTable() + "_ID_seq\"');");
        if (logger.isDebugEnabled()) {
            logger.debug(sql.toString());
        }
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            result = resultSet.getLong(1);
            resultSet.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public long currSequenceVal(SqlgGraph sqlgGraph, SchemaTable schemaTable, String prefix) {
        long result;
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        Connection conn = sqlgGraph.tx().getConnection();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT CURRVAL('\"" + schemaTable.getSchema() + "\".\"" + prefix + schemaTable.getTable() + "_ID_seq\"');");
        if (logger.isDebugEnabled()) {
            logger.debug(sql.toString());
        }
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            result = resultSet.getLong(1);
            resultSet.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String sequenceName(SqlgGraph sqlgGraph, SchemaTable outSchemaTable, String prefix) {
        String result;
        Preconditions.checkArgument((prefix.equals("V_") || prefix.equals("E_") ? 1 : 0) != 0, (Object)"prefix must be V_ or E_");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT pg_get_serial_sequence('\"");
        sql.append(outSchemaTable.getSchema());
        sql.append("\".\"");
        sql.append(prefix).append(outSchemaTable.getTable()).append("\"', 'ID')");
        if (logger.isDebugEnabled()) {
            logger.debug(sql.toString());
        }
        Connection conn = sqlgGraph.tx().getConnection();
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql.toString());){
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            result = resultSet.getString(1);
            resultSet.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean supportsBulkWithinOut() {
        return true;
    }

    public boolean isPostgresql() {
        return true;
    }

    public String afterCreateTemporaryTableStatement() {
        return "ON COMMIT DROP";
    }

    public List<String> sqlgTopologyCreationScripts() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"V_schema\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"V_vertex\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT, \"schemaVertex\" TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"V_edge\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"V_property\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT, \"type\" TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"V_index\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT, \"index_type\" TEXT);");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"V_globalUniqueIndex\" (\"ID\" SERIAL PRIMARY KEY, \"createdOn\" TIMESTAMP WITH TIME ZONE, \"name\" TEXT, CONSTRAINT propertyUniqueConstraint UNIQUE(name));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_schema_vertex\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.vertex__I\" BIGINT, \"sqlg_schema.schema__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.vertex__I\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.schema__O\") REFERENCES \"sqlg_schema\".\"V_schema\" (\"ID\"), INDEX (\"sqlg_schema.vertex__I\"), INDEX (\"sqlg_schema.schema__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_in_edges\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), INDEX (\"sqlg_schema.edge__I\"), INDEX (\"sqlg_schema.vertex__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_out_edges\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.edge__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.edge__I\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), INDEX (\"sqlg_schema.edge__I\"), INDEX (\"sqlg_schema.vertex__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_vertex_property\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), INDEX (\"sqlg_schema.property__I\"), INDEX (\"sqlg_schema.vertex__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_edge_property\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"), INDEX (\"sqlg_schema.property__I\"), INDEX (\"sqlg_schema.edge__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_vertex_index\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.index__I\" BIGINT, \"sqlg_schema.vertex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.index__I\") REFERENCES \"sqlg_schema\".\"V_index\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.vertex__O\") REFERENCES \"sqlg_schema\".\"V_vertex\" (\"ID\"), INDEX (\"sqlg_schema.index__I\"), INDEX (\"sqlg_schema.vertex__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_edge_index\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.index__I\" BIGINT, \"sqlg_schema.edge__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.index__I\") REFERENCES \"sqlg_schema\".\"V_index\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.edge__O\") REFERENCES \"sqlg_schema\".\"V_edge\" (\"ID\"), INDEX (\"sqlg_schema.index__I\"), INDEX (\"sqlg_schema.edge__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_index_property\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.index__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.index__O\") REFERENCES \"sqlg_schema\".\"V_index\" (\"ID\"), INDEX (\"sqlg_schema.property__I\"), INDEX (\"sqlg_schema.index__O\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"E_globalUniqueIndex_property\"(\"ID\" SERIAL PRIMARY KEY, \"sqlg_schema.property__I\" BIGINT, \"sqlg_schema.globalUniqueIndex__O\" BIGINT, FOREIGN KEY (\"sqlg_schema.property__I\") REFERENCES \"sqlg_schema\".\"V_property\" (\"ID\"), FOREIGN KEY (\"sqlg_schema.globalUniqueIndex__O\") REFERENCES \"sqlg_schema\".\"V_globalUniqueIndex\" (\"ID\"));");
        result.add("CREATE TABLE IF NOT EXISTS \"sqlg_schema\".\"V_log\"(\"ID\" SERIAL PRIMARY KEY, \"timestamp\" TIMESTAMP, \"pid\" INTEGER, \"log\" TEXT);");
        return result;
    }

    public String sqlgCreateTopologyGraph() {
        return null;
    }

    public String sqlgAddIndexEdgeSequenceColumn() {
        return null;
    }

    public boolean isIndexPartOfCreateTable() {
        return true;
    }

    public String valueToValuesString(PropertyType propertyType, Object value) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean supportsType(PropertyType propertyType) {
        return false;
    }

    private Array createArrayOf(Connection conn, PropertyType propertyType, Object[] data) {
        try {
            switch (propertyType.ordinal()) {
                case 37: {
                    if (data != null) {
                        int a = 0;
                        for (Object o : data) {
                            data[a++] = CockroachdbDialect.shiftDST(((Time)o).toLocalTime());
                        }
                    }
                }
                case 20: 
                case 21: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 38: 
                case 41: {
                    return conn.createArrayOf(this.getArrayDriverType(propertyType), data);
                }
            }
            throw new IllegalStateException("Unhandled array type " + propertyType.name());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object convertArray(PropertyType propertyType, Array array) throws SQLException {
        switch (propertyType.ordinal()) {
            case 21: {
                return array.getArray();
            }
            case 20: {
                return SqlgUtil.convertObjectArrayToBooleanPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 25: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortArray((Object[])((Object[])array.getArray()));
            }
            case 24: {
                return SqlgUtil.convertObjectOfIntegersArrayToShortPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 27: {
                return array.getArray();
            }
            case 26: {
                return SqlgUtil.convertObjectOfIntegersArrayToIntegerPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 29: {
                return array.getArray();
            }
            case 28: {
                return SqlgUtil.convertObjectOfLongsArrayToLongPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 33: {
                return array.getArray();
            }
            case 32: {
                return SqlgUtil.convertObjectOfDoublesArrayToDoublePrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 31: {
                return array.getArray();
            }
            case 30: {
                return SqlgUtil.convertObjectOfFloatsArrayToFloatPrimitiveArray((Object[])((Object[])array.getArray()));
            }
            case 34: {
                return array.getArray();
            }
            case 35: {
                Timestamp[] timestamps = (Timestamp[])array.getArray();
                return SqlgUtil.copyToLocalDateTime((Timestamp[])timestamps, (Object)new LocalDateTime[timestamps.length]);
            }
            case 36: {
                Date[] dates = (Date[])array.getArray();
                return SqlgUtil.copyToLocalDate((Date[])dates, (Object)new LocalDate[dates.length]);
            }
            case 37: {
                Time[] times = (Time[])array.getArray();
                return SqlgUtil.copyToLocalTime((Time[])times, (Object)new LocalTime[times.length]);
            }
            case 41: {
                String arrayAsString = array.toString();
                arrayAsString = arrayAsString.substring(1);
                arrayAsString = arrayAsString.substring(0, arrayAsString.length() - 1);
                arrayAsString = StringEscapeUtils.unescapeJava((String)arrayAsString);
                arrayAsString = arrayAsString.substring(1);
                arrayAsString = arrayAsString.substring(0, arrayAsString.length() - 1);
                String[] jsons = arrayAsString.split("\",\"");
                JsonNode[] jsonNodes = new JsonNode[jsons.length];
                ObjectMapper objectMapper = new ObjectMapper();
                int count = 0;
                for (String json : jsons) {
                    try {
                        JsonNode jsonNode = objectMapper.readTree(json);
                        jsonNodes[count++] = jsonNode;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return jsonNodes;
            }
        }
        throw new IllegalStateException("Unhandled property type " + propertyType.name());
    }

    public void setArray(PreparedStatement statement, int index, PropertyType type, Object[] values) throws SQLException {
        statement.setArray(index, this.createArrayOf(statement.getConnection(), type, values));
    }

    private static Time shiftDST(LocalTime lt) {
        Time t = Time.valueOf(lt);
        int offset = Calendar.getInstance().get(16) / 1000;
        int m = t.getSeconds();
        t.setSeconds(m + offset);
        return t;
    }

    public String getFullTextQueryText(FullText fullText, String column) {
        String toQuery = fullText.isPlain() ? "plainto_tsquery" : "to_tsquery";
        String leftHand = fullText.getQuery();
        if (leftHand == null) {
            leftHand = column;
        }
        return "to_tsvector('" + fullText.getConfiguration() + "', " + leftHand + ") @@ " + toQuery + "('" + fullText.getConfiguration() + "',?)";
    }

    public boolean isSystemIndex(String indexName) {
        return indexName.endsWith("_pkey") || indexName.endsWith("_idx");
    }

    public boolean needsSchemaCreationPrecommit() {
        return true;
    }

    public boolean supportsBooleanArrayValues() {
        return false;
    }

    public boolean supportsDoubleArrayValues() {
        return false;
    }

    public boolean supportsFloatArrayValues() {
        return false;
    }

    public boolean supportsIntegerArrayValues() {
        return false;
    }

    public boolean supportsShortArrayValues() {
        return false;
    }

    public boolean supportsLongArrayValues() {
        return false;
    }

    public boolean supportsStringArrayValues() {
        return false;
    }

    public boolean supportsFloatValues() {
        return false;
    }

    public boolean supportsByteValues() {
        return false;
    }

    public boolean supportsLocalDateTimeArrayValues() {
        return false;
    }

    public boolean supportsLocalTimeArrayValues() {
        return false;
    }

    public boolean supportsLocalDateArrayValues() {
        return false;
    }

    public boolean supportsZonedDateTimeArrayValues() {
        return false;
    }

    public boolean supportsPeriodArrayValues() {
        return false;
    }

    public boolean supportsDurationArrayValues() {
        return false;
    }
}

