/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.predicate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullText
implements BiPredicate<String, String> {
    private static Logger logger = LoggerFactory.getLogger((String)FullText.class.getName());
    private String configuration;
    private boolean plain = false;
    private String query;

    public static P<String> fullTextMatch(String configuration, String value) {
        return FullText.fullTextMatch(configuration, false, value);
    }

    public static P<String> fullTextMatch(String configuration, boolean plain, String value) {
        return new P((BiPredicate)new FullText(configuration, null, plain), (Object)value);
    }

    public static P<String> fullTextMatch(String configuration, boolean plain, String query, String value) {
        return new P((BiPredicate)new FullText(configuration, query, plain), (Object)value);
    }

    public static P<String> fullTextMatch(String configuration, boolean plain, List<String> columns, String value) {
        StringBuilder query = new StringBuilder();
        int count = 1;
        for (String column : columns) {
            query.append("\"" + column + "\"");
            if (count++ >= columns.size()) continue;
            query.append(" || ' ' || ");
        }
        return new P((BiPredicate)new FullText(configuration, query.toString(), plain), (Object)value);
    }

    public FullText(String configuration, String query, boolean plain) {
        this.configuration = configuration;
        this.query = query;
        this.plain = plain;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public boolean test(String first, String second) {
        logger.warn("Using Java implementation of FullText search instead of database");
        HashSet<String> words1 = new HashSet<String>(Arrays.asList(first.toLowerCase(Locale.ENGLISH).split("\\s")));
        HashSet<String> words2 = new HashSet<String>(Arrays.asList(second.toLowerCase(Locale.ENGLISH).split("\\s")));
        return words1.containsAll(words2);
    }

    public String toString() {
        return "FullText('" + this.configuration + "')";
    }
}

