/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.dialect;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.tinkerpop.gremlin.structure.T;
import org.umlg.sqlg.predicate.FullText;
import org.umlg.sqlg.structure.IndexRef;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;

public interface SqlDialect {
    public String dialectName();

    public Set<String> getDefaultSchemas();

    public PropertyType sqlTypeToPropertyType(SqlgGraph var1, String var2, String var3, String var4, int var5, String var6, ListIterator<Triple<String, Integer, String>> var7);

    public PropertyType sqlArrayTypeNameToPropertyType(String var1, SqlgGraph var2, String var3, String var4, String var5, ListIterator<Triple<String, Integer, String>> var6);

    public void validateProperty(Object var1, Object var2);

    default public boolean needsSemicolon() {
        return true;
    }

    default public boolean supportsCascade() {
        return true;
    }

    default public boolean needsSchemaDropCascade() {
        return this.supportsCascade();
    }

    public String getColumnEscapeKey();

    public String getPrimaryKeyType();

    public String getAutoIncrementPrimaryKeyConstruct();

    public String[] propertyTypeToSqlDefinition(PropertyType var1);

    public int propertyTypeToJavaSqlType(PropertyType var1);

    public String getForeignKeyTypeDefinition();

    default public String maybeWrapInQoutes(String field) {
        return this.getColumnEscapeKey() + field + this.getColumnEscapeKey();
    }

    default public boolean supportsFloatValues() {
        return true;
    }

    default public boolean supportsByteValues() {
        return false;
    }

    default public boolean supportsTransactionalSchema() {
        return true;
    }

    default public boolean supportsBooleanArrayValues() {
        return true;
    }

    default public boolean supportsByteArrayValues() {
        return true;
    }

    default public boolean supportsDoubleArrayValues() {
        return true;
    }

    default public boolean supportsFloatArrayValues() {
        return true;
    }

    default public boolean supportsIntegerArrayValues() {
        return true;
    }

    default public boolean supportsShortArrayValues() {
        return true;
    }

    default public boolean supportsLongArrayValues() {
        return true;
    }

    default public boolean supportsStringArrayValues() {
        return true;
    }

    default public void assertTableName(String tableName) {
    }

    default public void putJsonObject(ObjectNode obj, String columnName, int sqlType, Object o) {
        block28: {
            try {
                switch (sqlType) {
                    case -7: {
                        obj.put(columnName, (Boolean)o);
                        break;
                    }
                    case 5: {
                        Short v = o instanceof Short ? ((Short)o).shortValue() : ((Integer)o).shortValue();
                        obj.put(columnName, v);
                        break;
                    }
                    case 4: {
                        obj.put(columnName, (Integer)o);
                        break;
                    }
                    case -5: {
                        obj.put(columnName, (Long)o);
                        break;
                    }
                    case 7: {
                        obj.put(columnName, (Float)o);
                        break;
                    }
                    case 8: {
                        obj.put(columnName, (Double)o);
                        break;
                    }
                    case 12: {
                        obj.put(columnName, (String)o);
                        break;
                    }
                    case 2003: {
                        ArrayNode arrayNode = obj.putArray(columnName);
                        Array array = (Array)o;
                        int baseType = array.getBaseType();
                        Object[] objectArray = (Object[])array.getArray();
                        switch (baseType) {
                            case -7: {
                                for (Object arrayElement : objectArray) {
                                    arrayNode.add((Boolean)arrayElement);
                                }
                                break block28;
                            }
                            case 5: {
                                for (Object arrayElement : objectArray) {
                                    arrayNode.add((int)((Short)arrayElement).shortValue());
                                }
                                break block28;
                            }
                            case 4: {
                                for (Object arrayElement : objectArray) {
                                    arrayNode.add((Integer)arrayElement);
                                }
                                break block28;
                            }
                            case -5: {
                                for (Object arrayElement : objectArray) {
                                    arrayNode.add((Long)arrayElement);
                                }
                                break block28;
                            }
                            case 7: {
                                for (Object arrayElement : objectArray) {
                                    arrayNode.add((Float)arrayElement);
                                }
                                break block28;
                            }
                            case 8: {
                                for (Object arrayElement : objectArray) {
                                    arrayNode.add((Double)arrayElement);
                                }
                                break block28;
                            }
                            case 12: {
                                for (Object arrayElement : objectArray) {
                                    arrayNode.add((String)arrayElement);
                                }
                                break block28;
                            }
                            default: {
                                throw new IllegalStateException("Unknown array sqlType " + sqlType);
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException("Unknown sqlType " + sqlType);
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    default public void putJsonMetaObject(ObjectMapper mapper, ArrayNode metaNodeArray, String columnName, int sqlType, Object o) {
        try {
            ObjectNode metaNode = mapper.createObjectNode();
            metaNode.put("name", columnName);
            metaNodeArray.add((JsonNode)metaNode);
            block1 : switch (sqlType) {
                case -7: {
                    metaNode.put("type", PropertyType.BOOLEAN.name());
                    break;
                }
                case 5: {
                    metaNode.put("type", PropertyType.SHORT.name());
                    break;
                }
                case 4: {
                    metaNode.put("type", PropertyType.INTEGER.name());
                    break;
                }
                case -5: {
                    metaNode.put("type", PropertyType.LONG.name());
                    break;
                }
                case 7: {
                    metaNode.put("type", PropertyType.FLOAT.name());
                    break;
                }
                case 8: {
                    metaNode.put("type", PropertyType.DOUBLE.name());
                    break;
                }
                case 12: {
                    metaNode.put("type", PropertyType.STRING.name());
                    break;
                }
                case 2003: {
                    Array array = (Array)o;
                    int baseType = array.getBaseType();
                    switch (baseType) {
                        case -7: {
                            metaNode.put("type", PropertyType.boolean_ARRAY.name());
                            break block1;
                        }
                        case 5: {
                            metaNode.put("type", PropertyType.short_ARRAY.name());
                            break block1;
                        }
                        case 4: {
                            metaNode.put("type", PropertyType.int_ARRAY.name());
                            break block1;
                        }
                        case -5: {
                            metaNode.put("type", PropertyType.long_ARRAY.name());
                            break block1;
                        }
                        case 7: {
                            metaNode.put("type", PropertyType.float_ARRAY.name());
                            break block1;
                        }
                        case 8: {
                            metaNode.put("type", PropertyType.double_ARRAY.name());
                            break block1;
                        }
                        case 12: {
                            metaNode.put("type", PropertyType.STRING_ARRAY.name());
                            break block1;
                        }
                    }
                    throw new IllegalStateException("Unknown array sqlType " + sqlType);
                }
                default: {
                    throw new IllegalStateException("Unknown sqlType " + sqlType);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getArrayDriverType(PropertyType var1);

    default public String createTableStatement() {
        return "CREATE TABLE ";
    }

    default public String createTemporaryTableStatement() {
        return "CREATE TEMPORARY TABLE ";
    }

    default public String createSchemaStatement() {
        return "CREATE SCHEMA ";
    }

    default public void prepareDB(Connection conn) {
    }

    default public String getPublicSchema() {
        return "public";
    }

    default public String indexName(SchemaTable schemaTable, String prefix, List<String> columns) {
        Preconditions.checkState((!columns.isEmpty() ? 1 : 0) != 0, (Object)"SqlDialect.indexName may not be called with an empty list of columns");
        StringBuilder sb = new StringBuilder();
        sb.append(schemaTable.getSchema());
        sb.append("_");
        sb.append(prefix);
        sb.append(schemaTable.getTable());
        sb.append("_");
        sb.append((String)columns.stream().reduce((a, b) -> a + "_" + b).get());
        sb.append("Idx");
        return sb.toString();
    }

    public String existIndexQuery(SchemaTable var1, String var2, String var3);

    default public boolean supportSchemas() {
        return true;
    }

    default public boolean supportsBatchMode() {
        return false;
    }

    default public boolean supportsJson() {
        return false;
    }

    default public String hasContainerKeyToColumn(String key) {
        if (key.equals(T.id.getAccessor())) {
            return "ID";
        }
        return key;
    }

    default public boolean needForeignKeyIndex() {
        return false;
    }

    default public boolean supportsClientInfo() {
        return false;
    }

    default public void validateSchemaName(String schema) {
    }

    default public void validateTableName(String table) {
    }

    default public void validateColumnName(String column) {
    }

    default public int getMinimumSchemaNameLength() {
        return Integer.MAX_VALUE;
    }

    default public int getMinimumTableNameLength() {
        return Integer.MAX_VALUE;
    }

    default public int getMinimumColumnNameLength() {
        return Integer.MAX_VALUE;
    }

    default public boolean supportsILike() {
        return Boolean.FALSE;
    }

    default public boolean needsTimeZone() {
        return Boolean.FALSE;
    }

    public Set<String> getSpacialRefTable();

    public List<String> getGisSchemas();

    public void setJson(PreparedStatement var1, int var2, JsonNode var3);

    public void handleOther(Map<String, Object> var1, String var2, Object var3, PropertyType var4);

    public void setPoint(PreparedStatement var1, int var2, Object var3);

    public void setLineString(PreparedStatement var1, int var2, Object var3);

    public void setPolygon(PreparedStatement var1, int var2, Object var3);

    public void setGeographyPoint(PreparedStatement var1, int var2, Object var3);

    default public boolean isPostgresql() {
        return false;
    }

    public <T> T getGis(SqlgGraph var1);

    public void lockTable(SqlgGraph var1, SchemaTable var2, String var3);

    public void alterSequenceCacheSize(SqlgGraph var1, SchemaTable var2, String var3, int var4);

    public long nextSequenceVal(SqlgGraph var1, SchemaTable var2, String var3);

    public long currSequenceVal(SqlgGraph var1, SchemaTable var2, String var3);

    public String sequenceName(SqlgGraph var1, SchemaTable var2, String var3);

    public boolean supportsBulkWithinOut();

    public String afterCreateTemporaryTableStatement();

    default public List<String> columnsToIgnore() {
        return Collections.emptyList();
    }

    default public String sqlgSqlgSchemaCreationScript() {
        return "CREATE SCHEMA " + this.maybeWrapInQoutes("sqlg_schema");
    }

    public List<String> sqlgTopologyCreationScripts();

    public String sqlgAddPropertyIndexTypeColumn();

    default public Long getPrimaryKeyStartValue() {
        return 1L;
    }

    public Object convertArray(PropertyType var1, Array var2) throws SQLException;

    public void setArray(PreparedStatement var1, int var2, PropertyType var3, Object[] var4) throws SQLException;

    default public String getRangeClause(Range<Long> r) {
        return "LIMIT " + ((Long)r.getMaximum() - (Long)r.getMinimum()) + " OFFSET " + r.getMinimum();
    }

    default public boolean requiredPreparedStatementDeallocate() {
        return false;
    }

    default public String getFullTextQueryText(FullText fullText, String column) {
        throw new UnsupportedOperationException("FullText search is not supported on this database");
    }

    default public boolean schemaExists(DatabaseMetaData metadata, String catalog, String schema) throws SQLException {
        ResultSet schemaRs = metadata.getSchemas(catalog, schema);
        return schemaRs.next();
    }

    default public Map<String, Set<IndexRef>> extractIndices(Connection conn, String catalog, String schema) throws SQLException {
        return null;
    }

    public boolean isSystemIndex(String var1);
}

