/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.parse;

import java.util.LinkedHashMap;
import java.util.Map;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;

public class ColumnList {
    private Map<Column, String> columns = new LinkedHashMap<Column, String>();
    private SqlgGraph sqlgGraph;

    public ColumnList(SqlgGraph graph) {
        this.sqlgGraph = graph;
    }

    public void add(String schema, String table, String column, int stepDepth, String alias) {
        Column c = new Column(schema, table, column, stepDepth);
        this.columns.put(c, alias);
    }

    public void add(SchemaTableTree stt, String column, String alias) {
        this.add(stt.getSchemaTable(), column, stt.getStepDepth(), alias);
    }

    public void add(SchemaTable st, String column, int stepDepth, String alias) {
        this.add(st.getSchema(), st.getTable(), column, stepDepth, alias);
    }

    public String getAlias(String schema, String table, String column, int stepDepth) {
        Column c = new Column(schema, table, column, stepDepth);
        return this.columns.get(c);
    }

    public String getAlias(SchemaTableTree stt, String column) {
        return this.getAlias(stt.getSchemaTable(), column, stt.getStepDepth());
    }

    public String getAlias(SchemaTable st, String column, int stepDepth) {
        return this.getAlias(st.getSchema(), st.getTable(), column, stepDepth);
    }

    public String toString() {
        String sep = "";
        StringBuilder sb = new StringBuilder();
        for (Column c : this.columns.keySet()) {
            String alias = this.columns.get(c);
            sb.append(sep);
            sep = ",\n\t";
            c.toString(sb);
            sb.append(" AS ");
            sb.append(this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(alias));
        }
        return sb.toString();
    }

    private class Column {
        private String schema;
        private String table;
        private String column;
        private int stepDepth = -1;

        public Column(String schema, String table, String column, int stepDepth) {
            this.schema = schema;
            this.table = table;
            this.column = column;
            this.stepDepth = stepDepth;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
            result = 31 * result + this.stepDepth;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Column other = (Column)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
                return false;
            }
            if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
                return false;
            }
            if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
                return false;
            }
            return this.stepDepth == other.stepDepth;
        }

        private ColumnList getOuterType() {
            return ColumnList.this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        public void toString(StringBuilder sb) {
            sb.append(ColumnList.this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.schema));
            sb.append(".");
            sb.append(ColumnList.this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.table));
            sb.append(".");
            sb.append(ColumnList.this.sqlgGraph.getSqlDialect().maybeWrapInQoutes(this.column));
        }
    }
}

