/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.parse;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.umlg.sqlg.sql.parse.ReplacedStep;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.util.SqlgUtil;

public class GremlinParser<S extends Element, E extends Element> {
    private SqlgGraph sqlgGraph;

    public GremlinParser(SqlgGraph sqlgGraph) {
        this.sqlgGraph = sqlgGraph;
    }

    public Set<SchemaTableTree> parseForStrategy(List<ReplacedStep<S, E>> replacedSteps) {
        ReplacedStep<S, E> startReplacedStep = replacedSteps.get(0);
        Set<SchemaTableTree> result = this.parse(replacedSteps);
        replacedSteps.add(0, startReplacedStep);
        return result;
    }

    public Set<SchemaTableTree> parse(List<ReplacedStep<S, E>> replacedSteps) {
        ReplacedStep<S, E> startReplacedStep = replacedSteps.remove(0);
        Preconditions.checkState((boolean)startReplacedStep.isGraphStep(), (Object)"Step must be a GraphStep");
        Set<SchemaTableTree> rootSchemaTableTrees = startReplacedStep.getRootSchemaTableTrees(this.sqlgGraph, replacedSteps.size());
        HashSet<SchemaTableTree> toRemove = new HashSet<SchemaTableTree>();
        for (SchemaTableTree rootSchemaTableTree : rootSchemaTableTrees) {
            SqlgUtil.removeTopologyStrategyHasContainer(rootSchemaTableTree.getHasContainers());
            Set<SchemaTableTree> schemaTableTrees = new HashSet<SchemaTableTree>();
            schemaTableTrees.add(rootSchemaTableTree);
            for (ReplacedStep<S, E> replacedStep : replacedSteps) {
                schemaTableTrees = replacedStep.calculatePathForStep(schemaTableTrees);
            }
            boolean remove = rootSchemaTableTree.removeNodesInvalidatedByHas();
            if (remove) {
                toRemove.add(rootSchemaTableTree);
            }
            rootSchemaTableTree.removeAllButDeepestAndAddCacheLeafNodes(replacedSteps.size());
        }
        rootSchemaTableTrees.removeAll(toRemove);
        return rootSchemaTableTrees;
    }

    public SchemaTableTree parse(SchemaTable schemaTable, List<ReplacedStep<S, E>> replacedSteps) {
        Preconditions.checkArgument((!replacedSteps.get(0).isGraphStep() ? 1 : 0) != 0, (Object)"Expected VertexStep, found GraphStep");
        Set<SchemaTableTree> schemaTableTrees = new HashSet<SchemaTableTree>();
        SchemaTableTree rootSchemaTableTree = new SchemaTableTree(this.sqlgGraph, schemaTable, 0, replacedSteps.size() - 1);
        rootSchemaTableTree.setOptionalLeftJoin(replacedSteps.get(0).isLeftJoin());
        rootSchemaTableTree.setEmit(replacedSteps.get(0).isEmit());
        rootSchemaTableTree.setUntilFirst(replacedSteps.get(0).isUntilFirst());
        rootSchemaTableTree.initializeAliasColumnNameMaps();
        rootSchemaTableTree.setStepType(schemaTable.isVertexTable() ? SchemaTableTree.STEP_TYPE.VERTEX_STEP : SchemaTableTree.STEP_TYPE.EDGE_VERTEX_STEP);
        schemaTableTrees.add(rootSchemaTableTree);
        for (ReplacedStep<S, E> replacedStep : replacedSteps) {
            if (replacedStep.isFake()) continue;
            schemaTableTrees = replacedStep.calculatePathForStep(schemaTableTrees);
        }
        rootSchemaTableTree.removeNodesInvalidatedByHas();
        rootSchemaTableTree.removeAllButDeepestAndAddCacheLeafNodes(replacedSteps.size() - 1);
        rootSchemaTableTree.setLocalStep(true);
        return rootSchemaTableTree;
    }
}

