/*
 * Decompiled with CFR 0.152.
 */
package org.umlg.sqlg.sql.parse;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.javatuples.Pair;
import org.umlg.sqlg.sql.parse.SchemaTableTree;
import org.umlg.sqlg.structure.PropertyType;
import org.umlg.sqlg.structure.RecordId;
import org.umlg.sqlg.structure.SchemaTable;
import org.umlg.sqlg.structure.SqlgGraph;
import org.umlg.sqlg.structure.Topology;
import org.umlg.sqlg.util.SqlgUtil;

public class ReplacedStep<S, E> {
    private Topology topology;
    private AbstractStep<S, E> step;
    private Set<String> labels;
    private List<HasContainer> hasContainers;
    private List<Pair<Traversal.Admin, Comparator>> comparators;
    private Range<Long> range;
    private int depth;
    private boolean emit;
    private boolean untilFirst;
    private boolean leftJoin;
    private boolean fake;

    private ReplacedStep() {
    }

    public static ReplacedStep from(Topology topology) {
        ReplacedStep replacedStep = new ReplacedStep();
        replacedStep.step = null;
        replacedStep.labels = new HashSet<String>();
        replacedStep.hasContainers = new ArrayList<HasContainer>();
        replacedStep.comparators = new ArrayList<Pair<Traversal.Admin, Comparator>>();
        replacedStep.topology = topology;
        replacedStep.fake = true;
        return replacedStep;
    }

    public static <S, E> ReplacedStep from(Topology topology, AbstractStep<S, E> step, int pathCount) {
        ReplacedStep<S, E> replacedStep = new ReplacedStep<S, E>();
        replacedStep.step = step;
        replacedStep.labels = step.getLabels().stream().map(l -> pathCount + "P~~~" + l).collect(Collectors.toSet());
        replacedStep.hasContainers = new ArrayList<HasContainer>();
        replacedStep.comparators = new ArrayList<Pair<Traversal.Admin, Comparator>>();
        replacedStep.topology = topology;
        replacedStep.fake = false;
        return replacedStep;
    }

    public boolean isFake() {
        return this.fake;
    }

    List<HasContainer> getHasContainers() {
        return this.hasContainers;
    }

    public List<Pair<Traversal.Admin, Comparator>> getComparators() {
        return this.comparators;
    }

    public void addLabel(String label) {
        this.labels.add(label);
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    private Set<SchemaTableTree> appendPath(SchemaTableTree schemaTableTree) {
        if (this.step instanceof VertexStep) {
            return this.appendPathForVertexStep(schemaTableTree);
        }
        if (this.step instanceof EdgeVertexStep) {
            return this.appendPathForEdgeVertexStep(schemaTableTree);
        }
        if (this.step instanceof EdgeOtherVertexStep) {
            return this.appendPathForEdgeOtherVertexStep(schemaTableTree);
        }
        throw new IllegalStateException("Only VertexStep, EdgeVertexStep and EdgeOtherVertexStep are handled! Found " + this.step.getClass().getName());
    }

    private Set<SchemaTableTree> appendPathForEdgeVertexStep(SchemaTableTree schemaTableTree) {
        EdgeVertexStep edgeVertexStep = (EdgeVertexStep)this.step;
        return this.calculatePathFromEdgeToVertex(schemaTableTree, schemaTableTree.getSchemaTable(), edgeVertexStep.getDirection());
    }

    private Set<SchemaTableTree> appendPathForEdgeOtherVertexStep(SchemaTableTree schemaTableTree) {
        Preconditions.checkArgument((schemaTableTree.getDirection() != Direction.BOTH ? 1 : 0) != 0, (Object)"ReplacedStep.appendPathForEdgeOtherVertexStep schemaTableTree may not have direction BOTH");
        return this.calculatePathFromEdgeToVertex(schemaTableTree, schemaTableTree.getSchemaTable(), schemaTableTree.getDirection() == Direction.IN ? Direction.OUT : Direction.IN);
    }

    private Set<SchemaTableTree> appendPathForVertexStep(SchemaTableTree schemaTableTree) {
        boolean filter;
        SchemaTable schemaTableTo;
        String foreignKeyTable;
        String foreignKeySchema;
        String[] split;
        SchemaTableTree schemaTableTreeChild;
        boolean first;
        Set<String> foreignKeys;
        Map<String, Set<String>> edgeForeignKeys;
        SchemaTableTree schemaTableTreeChild2;
        Set<SchemaTable> outLabelsToTraversers;
        Set<SchemaTable> inLabelsToTraversers;
        Preconditions.checkArgument((boolean)schemaTableTree.getSchemaTable().isVertexTable(), (Object)("Expected a Vertex table found " + schemaTableTree.getSchemaTable().getTable()));
        HashSet<SchemaTableTree> result = new HashSet<SchemaTableTree>();
        org.apache.commons.lang3.tuple.Pair<Set<SchemaTable>, Set<SchemaTable>> inAndOutLabelsFromCurrentPosition = this.topology.getTableLabels(schemaTableTree.getSchemaTable());
        VertexStep vertexStep = (VertexStep)this.step;
        String[] edgeLabels = vertexStep.getEdgeLabels();
        Direction direction = vertexStep.getDirection();
        Class elementClass = vertexStep.getReturnClass();
        HashSet<SchemaTable> inLabels = inAndOutLabelsFromCurrentPosition != null ? (Set)inAndOutLabelsFromCurrentPosition.getLeft() : new HashSet();
        HashSet<SchemaTable> outLabels = inAndOutLabelsFromCurrentPosition != null ? (Set)inAndOutLabelsFromCurrentPosition.getRight() : new HashSet();
        switch (vertexStep.getDirection()) {
            case IN: {
                inLabelsToTraversers = this.filter(inLabels, edgeLabels);
                outLabelsToTraversers = new HashSet<SchemaTable>();
                break;
            }
            case OUT: {
                outLabelsToTraversers = this.filter(outLabels, edgeLabels);
                inLabelsToTraversers = new HashSet<SchemaTable>();
                break;
            }
            case BOTH: {
                inLabelsToTraversers = edgeLabels.length > 0 ? this.filter(inLabels, edgeLabels) : inLabels;
                outLabelsToTraversers = edgeLabels.length > 0 ? this.filter(outLabels, edgeLabels) : outLabels;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown direction " + direction.name());
            }
        }
        if (elementClass.isAssignableFrom(Edge.class)) {
            inLabelsToTraversers = this.filterEdgeOnIdHasContainers(inLabelsToTraversers);
            outLabelsToTraversers = this.filterEdgeOnIdHasContainers(outLabelsToTraversers);
        }
        for (SchemaTable inLabelsToTravers : inLabelsToTraversers) {
            if (elementClass.isAssignableFrom(Edge.class)) {
                schemaTableTreeChild2 = schemaTableTree.addChild(inLabelsToTravers, Direction.IN, elementClass, this, this.labels);
                result.add(schemaTableTreeChild2);
                continue;
            }
            edgeForeignKeys = this.topology.getAllEdgeForeignKeys();
            foreignKeys = edgeForeignKeys.get(inLabelsToTravers.toString());
            first = true;
            schemaTableTreeChild = null;
            for (String foreignKey : foreignKeys) {
                if (!foreignKey.endsWith("__O")) continue;
                split = foreignKey.split("\\.");
                foreignKeySchema = split[0];
                foreignKeyTable = split[1];
                schemaTableTo = SchemaTable.of(foreignKeySchema, "V_" + SqlgUtil.removeTrailingOutId(foreignKeyTable));
                filter = this.filterVertexOnIdHasContainers(schemaTableTo);
                if (filter) continue;
                if (first) {
                    first = false;
                    schemaTableTreeChild = schemaTableTree.addChild(inLabelsToTravers, Direction.IN, elementClass, this, Collections.emptySet());
                }
                result.addAll(this.calculatePathFromVertexToEdge(schemaTableTreeChild, schemaTableTo, Direction.IN));
            }
        }
        for (SchemaTable outLabelToTravers : outLabelsToTraversers) {
            if (elementClass.isAssignableFrom(Edge.class)) {
                schemaTableTreeChild2 = schemaTableTree.addChild(outLabelToTravers, Direction.OUT, elementClass, this, this.labels);
                result.add(schemaTableTreeChild2);
                continue;
            }
            edgeForeignKeys = this.topology.getAllEdgeForeignKeys();
            foreignKeys = edgeForeignKeys.get(outLabelToTravers.toString());
            first = true;
            schemaTableTreeChild = null;
            for (String foreignKey : foreignKeys) {
                if (!foreignKey.endsWith("__I")) continue;
                split = foreignKey.split("\\.");
                foreignKeySchema = split[0];
                foreignKeyTable = split[1];
                schemaTableTo = SchemaTable.of(foreignKeySchema, "V_" + SqlgUtil.removeTrailingInId(foreignKeyTable));
                filter = this.filterVertexOnIdHasContainers(schemaTableTo);
                if (filter) continue;
                if (first) {
                    first = false;
                    schemaTableTreeChild = schemaTableTree.addChild(outLabelToTravers, Direction.OUT, elementClass, this, Collections.emptySet());
                }
                result.addAll(this.calculatePathFromVertexToEdge(schemaTableTreeChild, schemaTableTo, Direction.OUT));
            }
        }
        return result;
    }

    private Set<SchemaTable> filterEdgeOnIdHasContainers(Set<SchemaTable> labelsToTraversers) {
        HashSet<SchemaTable> idFilteredResult = new HashSet<SchemaTable>(labelsToTraversers);
        for (HasContainer idHasContainer : this.getIdHasContainer()) {
            SchemaTable hasContainerSchemaTable = RecordId.from((Object)idHasContainer.getValue().toString()).getSchemaTable();
            hasContainerSchemaTable = SchemaTable.of(hasContainerSchemaTable.getSchema(), "E_" + hasContainerSchemaTable.getTable());
            for (SchemaTable schemaTable : labelsToTraversers) {
                if (schemaTable.equals(hasContainerSchemaTable)) continue;
                idFilteredResult.remove(schemaTable);
            }
        }
        return idFilteredResult;
    }

    private boolean filterVertexOnIdHasContainers(SchemaTable labelsToTraverser) {
        boolean result = !this.getIdHasContainer().isEmpty();
        for (HasContainer idHasContainer : this.getIdHasContainer()) {
            if (idHasContainer.getValue() instanceof Collection) {
                Collection recordIds = (Collection)idHasContainer.getValue();
                for (Object id : recordIds) {
                    RecordId recordId = id instanceof String ? RecordId.from(id) : (RecordId)id;
                    SchemaTable hasContainerSchemaTable = recordId.getSchemaTable();
                    if (!labelsToTraverser.equals(hasContainerSchemaTable = SchemaTable.of(hasContainerSchemaTable.getSchema(), "V_" + hasContainerSchemaTable.getTable()))) continue;
                    return false;
                }
                continue;
            }
            SchemaTable hasContainerSchemaTable = RecordId.from((Object)idHasContainer.getValue().toString()).getSchemaTable();
            if (!labelsToTraverser.equals(hasContainerSchemaTable = SchemaTable.of(hasContainerSchemaTable.getSchema(), "V_" + hasContainerSchemaTable.getTable()))) continue;
            return false;
        }
        return result;
    }

    private Set<SchemaTableTree> calculatePathFromEdgeToVertex(SchemaTableTree schemaTableTree, SchemaTable labelToTravers, Direction direction) {
        Preconditions.checkArgument((boolean)labelToTravers.isEdgeTable());
        HashSet<SchemaTableTree> result = new HashSet<SchemaTableTree>();
        Map<String, Set<String>> edgeForeignKeys = this.topology.getAllEdgeForeignKeys();
        Set<String> foreignKeys = edgeForeignKeys.get(labelToTravers.toString());
        for (String foreignKey : foreignKeys) {
            SchemaTableTree schemaTableTreeChild;
            String[] split = foreignKey.split("\\.");
            String foreignKeySchema = split[0];
            String foreignKeyTable = split[1];
            if ((direction == Direction.BOTH || direction == Direction.OUT) && foreignKey.endsWith("__O")) {
                schemaTableTreeChild = schemaTableTree.addChild(SchemaTable.of(foreignKeySchema, "V_" + SqlgUtil.removeTrailingOutId(foreignKeyTable)), Direction.OUT, Vertex.class, this, true, this.labels);
                result.add(schemaTableTreeChild);
            }
            if (direction != Direction.BOTH && direction != Direction.IN || !foreignKey.endsWith("__I")) continue;
            schemaTableTreeChild = schemaTableTree.addChild(SchemaTable.of(foreignKeySchema, "V_" + SqlgUtil.removeTrailingInId(foreignKeyTable)), Direction.IN, Vertex.class, this, true, this.labels);
            result.add(schemaTableTreeChild);
        }
        return result;
    }

    private Set<SchemaTableTree> calculatePathFromVertexToEdge(SchemaTableTree schemaTableTree, SchemaTable schemaTableTo, Direction direction) {
        HashSet<SchemaTableTree> result = new HashSet<SchemaTableTree>();
        SchemaTableTree schemaTableTree1 = schemaTableTree.addChild(schemaTableTo, direction, Vertex.class, this, this.labels);
        ArrayList<HasContainer> toRemove = new ArrayList<HasContainer>();
        List<HasContainer> idHasContainers = this.getIdHasContainer();
        for (HasContainer idHasContainer : idHasContainers) {
            RecordId recordId;
            ArrayList<Long> idsToAdd = new ArrayList<Long>();
            Object o = idHasContainer.getValue();
            if (o instanceof Collection) {
                Collection ids = (Collection)o;
                for (Object id : ids) {
                    RecordId recordId2 = id instanceof RecordId ? (RecordId)id : RecordId.from(id);
                    if (!recordId2.getSchemaTable().equals(schemaTableTo.withOutPrefix())) continue;
                    idsToAdd.add(recordId2.getId());
                }
            } else if (o instanceof RecordId) {
                recordId = (RecordId)o;
                if (recordId.getSchemaTable().equals(schemaTableTo.withOutPrefix())) {
                    idsToAdd.add(recordId.getId());
                }
            } else {
                recordId = RecordId.from(o);
                if (recordId.getSchemaTable().equals(schemaTableTo.withOutPrefix())) {
                    idsToAdd.add(recordId.getId());
                }
            }
            if (idHasContainer.getBiPredicate() == Compare.neq || idHasContainer.getBiPredicate() == Contains.without) {
                schemaTableTree1.getHasContainers().add(new HasContainer(T.id.getAccessor(), P.without(idsToAdd)));
                toRemove.add(idHasContainer);
                continue;
            }
            if (idHasContainer.getBiPredicate() == Compare.eq || idHasContainer.getBiPredicate() == Contains.within) {
                schemaTableTree1.getHasContainers().add(new HasContainer(T.id.getAccessor(), P.within(idsToAdd)));
                toRemove.add(idHasContainer);
                continue;
            }
            throw new IllegalStateException("Not handled " + idHasContainer.getBiPredicate().toString());
        }
        schemaTableTree1.getHasContainers().removeAll(toRemove);
        result.add(schemaTableTree1);
        return result;
    }

    Set<SchemaTableTree> calculatePathForStep(Set<SchemaTableTree> schemaTableTrees) {
        HashSet<SchemaTableTree> result = new HashSet<SchemaTableTree>();
        for (SchemaTableTree schemaTableTree : schemaTableTrees) {
            result.addAll(this.appendPath(schemaTableTree));
        }
        return result;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    private Set<SchemaTable> filter(Set<SchemaTable> labels, String[] edgeLabels) {
        HashSet<SchemaTable> result = new HashSet<SchemaTable>();
        List<String> edges = Arrays.asList(edgeLabels);
        for (SchemaTable label : labels) {
            if (!label.getTable().startsWith("E_")) {
                throw new IllegalStateException("Expected label to start with E_");
            }
            String rawLabel = label.getTable().substring("E_".length());
            if (!edges.isEmpty()) {
                if (!edges.contains(rawLabel)) continue;
                result.add(label);
                continue;
            }
            result.add(label);
        }
        return result;
    }

    private List<HasContainer> getIdHasContainer() {
        return this.hasContainers.stream().filter(h -> h.getKey().equals(T.id.getAccessor())).collect(Collectors.toList());
    }

    public String toString() {
        if (this.step != null) {
            return this.step.toString() + " :: " + this.hasContainers.toString();
        }
        return "fakeStep :: " + this.hasContainers.toString();
    }

    public boolean isGraphStep() {
        return this.step instanceof GraphStep;
    }

    public boolean isVertexStep() {
        return this.step instanceof VertexStep;
    }

    public boolean isEdgeVertexStep() {
        return this.step instanceof EdgeVertexStep;
    }

    Set<SchemaTableTree> getRootSchemaTableTrees(SqlgGraph sqlgGraph, int replacedStepDepth) {
        Preconditions.checkState((boolean)this.isGraphStep(), (Object)"ReplacedStep must be for a GraphStep!");
        GraphStep graphStep = (GraphStep)this.step;
        Map<String, Map<String, PropertyType>> filteredAllTables = SqlgUtil.filterHasContainers(this.topology, this.hasContainers, false);
        ArrayList<HasContainer> toRemove = new ArrayList<HasContainer>();
        LinkedHashMultimap groupedIds = LinkedHashMultimap.create();
        if (graphStep.getIds().length > 0) {
            this.groupIdsBySchemaTable(graphStep, (Multimap<SchemaTable, RecordId>)groupedIds);
            for (SchemaTable schemaTable : groupedIds.keySet()) {
                boolean containsLabel = this.isContainsLabel(sqlgGraph, schemaTable);
                if (containsLabel) continue;
                HasContainer labelHasContainer = new HasContainer(T.label.getAccessor(), P.eq((Object)schemaTable.toString()));
                this.hasContainers.add(labelHasContainer);
                toRemove.add(labelHasContainer);
            }
        }
        ArrayList labelHasContainers = new ArrayList();
        ArrayList idHasContainersToRemove = new ArrayList();
        this.hasContainers.stream().filter(h -> h.getKey().equals(T.id.getAccessor())).forEach(arg_0 -> this.lambda$getRootSchemaTableTrees$3((Multimap)groupedIds, sqlgGraph, labelHasContainers, idHasContainersToRemove, arg_0));
        this.hasContainers.removeAll(idHasContainersToRemove);
        this.hasContainers.addAll(labelHasContainers);
        HashSet<SchemaTableTree> result = new HashSet<SchemaTableTree>();
        List hasContainersWithoutLabel = this.hasContainers.stream().filter(h -> !h.getKey().equals(T.label.getAccessor())).collect(Collectors.toList());
        List hasContainersWithLabel = this.hasContainers.stream().filter(h -> h.getKey().equals(T.label.getAccessor())).collect(Collectors.toList());
        Set hashCodes = hasContainersWithLabel.stream().map(HasContainer::hashCode).collect(Collectors.toSet());
        hasContainersWithLabel = hasContainersWithLabel.stream().filter(h -> hashCodes.remove(h.hashCode())).collect(Collectors.toList());
        if (hasContainersWithLabel.isEmpty()) {
            filteredAllTables.forEach((t, p) -> {
                if (graphStep.getReturnClass().isAssignableFrom(Vertex.class) && t.substring(t.indexOf(".") + 1).startsWith("V_") || graphStep.getReturnClass().isAssignableFrom(Edge.class) && t.substring(t.indexOf(".") + 1).startsWith("E_")) {
                    SchemaTable schemaTable = SchemaTable.from(sqlgGraph, t);
                    SchemaTableTree schemaTableTree = new SchemaTableTree(sqlgGraph, schemaTable, 0, hasContainersWithoutLabel, this.comparators, this.range, SchemaTableTree.STEP_TYPE.GRAPH_STEP, this.emit, this.untilFirst, this.leftJoin, replacedStepDepth, this.labels);
                    result.add(schemaTableTree);
                }
            });
        } else {
            for (HasContainer h2 : hasContainersWithLabel) {
                String tbl = (String)h2.getValue();
                boolean isVertex = graphStep.getReturnClass().isAssignableFrom(Vertex.class);
                SchemaTable schemaTable = SqlgUtil.parseLabelMaybeNoSchema(sqlgGraph, tbl);
                String table = (isVertex ? "V_" : "E_") + schemaTable.getTable();
                SchemaTable schemaTableWithPrefix = SchemaTable.from(sqlgGraph, schemaTable.getSchema() == null ? table : schemaTable.getSchema() + "." + table);
                HashSet<SchemaTable> potentialsTables = new HashSet<SchemaTable>();
                potentialsTables.add(schemaTableWithPrefix);
                if (!isVertex && !tbl.contains(".")) {
                    for (String key : filteredAllTables.keySet()) {
                        if (!key.endsWith("." + table)) continue;
                        potentialsTables.add(SchemaTable.from(sqlgGraph, key));
                    }
                }
                for (SchemaTable schemaTableForLabel : potentialsTables) {
                    if (!filteredAllTables.containsKey(schemaTableForLabel.toString())) continue;
                    ArrayList<HasContainer> hasContainers = new ArrayList<HasContainer>(hasContainersWithoutLabel);
                    if (!groupedIds.isEmpty()) {
                        Collection recordIds = groupedIds.get((Object)schemaTable);
                        if (recordIds.isEmpty()) continue;
                        List ids = recordIds.stream().map(RecordId::getId).collect(Collectors.toList());
                        HasContainer idHasContainer = new HasContainer(T.id.getAccessor(), P.within(ids));
                        hasContainers.add(idHasContainer);
                        toRemove.add(idHasContainer);
                    }
                    SchemaTableTree schemaTableTree = new SchemaTableTree(sqlgGraph, schemaTableForLabel, 0, hasContainers, this.comparators, this.range, SchemaTableTree.STEP_TYPE.GRAPH_STEP, this.emit, this.untilFirst, this.leftJoin, replacedStepDepth, this.labels);
                    result.add(schemaTableTree);
                }
            }
        }
        this.hasContainers.removeAll(toRemove);
        return result;
    }

    private boolean isContainsLabel(SqlgGraph sqlgGraph, SchemaTable schemaTable) {
        SchemaTable hasContainerSchemaTable;
        HasContainer hasContainer;
        boolean containsLabel = false;
        Iterator<HasContainer> iterator = this.hasContainers.iterator();
        while (!(!iterator.hasNext() || (hasContainer = iterator.next()).getKey().equals(T.label.getAccessor()) && (containsLabel = schemaTable.equals(hasContainerSchemaTable = SqlgUtil.parseLabelMaybeNoSchema(sqlgGraph, (String)hasContainer.getValue()))))) {
        }
        return containsLabel;
    }

    private void groupIdsBySchemaTable(GraphStep graphStep, Multimap<SchemaTable, RecordId> groupedIds) {
        if (graphStep.getIds()[0] instanceof Element) {
            for (Object element : graphStep.getIds()) {
                RecordId recordId = (RecordId)((Element)element).id();
                groupedIds.put((Object)recordId.getSchemaTable(), (Object)recordId);
            }
        } else {
            for (Object id : graphStep.getIds()) {
                RecordId recordId = id instanceof RecordId ? (RecordId)id : RecordId.from(id);
                groupedIds.put((Object)recordId.getSchemaTable(), (Object)recordId);
            }
        }
    }

    public AbstractStep<S, E> getStep() {
        return this.step;
    }

    public boolean isEmit() {
        return this.emit;
    }

    public void setEmit(boolean emit) {
        this.emit = emit;
    }

    public void setLeftJoin(boolean leftJoin) {
        this.leftJoin = leftJoin;
    }

    public boolean isLeftJoin() {
        return this.leftJoin;
    }

    public boolean isUntilFirst() {
        return this.untilFirst;
    }

    public void setUntilFirst(boolean untilFirst) {
        this.untilFirst = untilFirst;
    }

    public int getDepth() {
        return this.depth;
    }

    public void addHasContainers(List<HasContainer> hasContainers) {
        this.hasContainers.addAll(hasContainers);
    }

    public void addHasContainer(HasContainer hasContainer) {
        this.hasContainers.add(hasContainer);
    }

    public Range<Long> getRange() {
        return this.range;
    }

    public void setRange(Range<Long> range) {
        this.range = range;
    }

    private /* synthetic */ void lambda$getRootSchemaTableTrees$3(Multimap groupedIds, SqlgGraph sqlgGraph, List labelHasContainers, List idHasContainersToRemove, HasContainer h) {
        if (h.getValue() instanceof Collection) {
            Collection coll = (Collection)h.getValue();
            HashSet<SchemaTable> distinctLabels = new HashSet<SchemaTable>();
            for (Object id : coll) {
                RecordId recordId = id instanceof RecordId ? (RecordId)id : RecordId.from(id);
                distinctLabels.add(recordId.getSchemaTable());
                groupedIds.put((Object)recordId.getSchemaTable(), (Object)recordId);
            }
            for (SchemaTable distinctLabel : distinctLabels) {
                boolean containsLabel = this.isContainsLabel(sqlgGraph, distinctLabel);
                if (containsLabel) continue;
                labelHasContainers.add(new HasContainer(T.label.getAccessor(), P.eq((Object)distinctLabel.toString())));
            }
            idHasContainersToRemove.add(h);
        } else {
            labelHasContainers.add(new HasContainer(T.label.getAccessor(), P.eq((Object)((RecordId)h.getValue()).getSchemaTable().toString())));
        }
    }
}

